/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.dtp.model.layout;

import com.kingdee.bos.ui.dtp.model.layout.Layout;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Properties;

public class SmartLayout
extends Layout
implements Serializable,
Cloneable {
    public static final int H_ALIGN_LEFT = 0;
    public static final int H_ALIGN_RIGHT = 1;
    public static final int H_ALIGN_CENTER = 2;
    public static final int V_ALIGN_TOP = 0;
    public static final int V_ALIGN_BOTTOM = 1;
    public static final int V_ALIGN_MIDDLE = 2;
    public int topAlign = 2;
    public int leftAlign = 2;
    public int bottomAlign = 2;
    public int rightAlign = 2;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SmartLayout(").append("topAlign=" + this.hAlignName(this.topAlign) + ";").append("bottomAlign=" + this.hAlignName(this.bottomAlign) + ";").append("leftAlign=" + this.vAlignName(this.leftAlign) + ";").append("rightAlign=" + this.vAlignName(this.rightAlign) + ")");
        return sb.toString();
    }

    private String hAlignName(int align) {
        if (align == 0) {
            return "left";
        }
        if (align == 1) {
            return "right";
        }
        if (align == 2) {
            return "center";
        }
        return "N/A";
    }

    private String vAlignName(int align) {
        if (align == 0) {
            return "top";
        }
        if (align == 1) {
            return "bottom";
        }
        if (align == 2) {
            return "middle";
        }
        return "N/A";
    }

    public SmartLayout(int topAlign, int leftAlign, int bottomAlign, int rightAlign) {
        this.topAlign = topAlign;
        this.leftAlign = leftAlign;
        this.bottomAlign = bottomAlign;
        this.rightAlign = rightAlign;
    }

    public SmartLayout() {
    }

    public String toDataString() {
        StringBuffer sb = new StringBuffer();
        sb.append("topAlign=" + this.topAlign + ";").append("bottomAlign=" + this.bottomAlign + ";").append("leftAlign=" + this.leftAlign + ";").append("rightAlign=" + this.rightAlign);
        return sb.toString();
    }

    public void parse(String s) {
        if (s == null) {
            return;
        }
        byte[] buffer = s.replace(';', '\n').getBytes();
        ByteArrayInputStream is = new ByteArrayInputStream(buffer);
        Properties prop = new Properties();
        try {
            prop.load(is);
            if (prop.getProperty("topAlign") != null) {
                this.topAlign = Integer.parseInt(prop.getProperty("topAlign"));
            }
            if (prop.getProperty("bottomAlign") != null) {
                this.bottomAlign = Integer.parseInt(prop.getProperty("bottomAlign"));
            }
            if (prop.getProperty("leftAlign") != null) {
                this.leftAlign = Integer.parseInt(prop.getProperty("leftAlign"));
            }
            if (prop.getProperty("rightAlign") != null) {
                this.rightAlign = Integer.parseInt(prop.getProperty("rightAlign"));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("error format");
        }
    }
}

