/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.layout;

import com.kingdee.bos.ui.dtp.kdlayout.KDLayoutConstraint;
import java.awt.Rectangle;

public class KDRectangle {
    private Rectangle rect;
    private int anchor = 0;

    public KDRectangle() {
        this.rect = new Rectangle();
    }

    public KDRectangle(KDRectangle kdRect) {
        this.rect = new Rectangle(kdRect.getRectangle());
        if (this.rect.height < 0) {
            this.rect.height = 1;
        }
        if (this.rect.width < 0) {
            this.rect.width = 1;
        }
        this.anchor = kdRect.getAnchor();
    }

    public KDRectangle(Rectangle rect) {
        this.rect = new Rectangle(rect);
    }

    public KDRectangle(Rectangle rect, int anchor) {
        this.rect = new Rectangle(rect);
        this.anchor = anchor;
    }

    public KDRectangle(KDLayoutConstraint kdlayout) {
        this.rect = new Rectangle(kdlayout.toRectangle());
        this.anchor = kdlayout.anchor;
    }

    public Rectangle getRectangle() {
        return this.rect;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public void setAnchor(int anchor) {
        this.anchor = anchor;
    }

    public void setX(int x) {
        this.rect.x = x;
    }

    public int getX() {
        return this.rect.x;
    }

    public void setY(int y) {
        this.rect.y = y;
    }

    public int getY() {
        return this.rect.y;
    }

    public void setWidth(int width) {
        this.rect.width = width;
    }

    public int getWidth() {
        return this.rect.width;
    }

    public void setHeight(int height) {
        this.rect.height = height;
    }

    public int getHeight() {
        return this.rect.height;
    }

    public boolean equals(Object value) {
        if (value == this) {
            return true;
        }
        if (value instanceof KDRectangle) {
            KDRectangle rect = (KDRectangle)value;
            return rect.getRectangle().equals(this.rect) && rect.getAnchor() == this.anchor;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static KDRectangle toKDRectangle(String value) {
        KDRectangle rect = new KDRectangle();
        try {
            String[] values = value.split(",");
            if (values.length != 4 && values.length != 5) {
                return null;
            }
            rect.setX(Integer.valueOf(values[0]));
            rect.setY(Integer.valueOf(values[1]));
            rect.setWidth(Integer.valueOf(values[2]));
            rect.setHeight(Integer.valueOf(values[3]));
            if (values.length == 5) {
                rect.setAnchor(Integer.valueOf(values[4]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rect;
    }

    public String toString() {
        return this.rect.x + "," + this.rect.y + "," + this.rect.width + "," + this.rect.height + "," + this.anchor;
    }
}

