/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.health.managent;

import com.kingdee.bos.health.Constant;
import com.kingdee.bos.health.MemoryHealthInfo;
import com.kingdee.bos.health.ThreadDeadLockHealthInfo;
import com.kingdee.bos.health.managent.HeathReportMBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class HeathReport
implements HeathReportMBean {
    static List<ObjectName> jdbcSurceObjNameLs = new ArrayList<ObjectName>();
    private final ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
    Map<String, Object> report = new HashMap<String, Object>();
    private boolean oomed = false;
    public static final String Status_Code = "Status_Code";
    long timesnamp = 0L;
    public static boolean subhealth = false;
    public static long sleepTime = 10000L;

    public HeathReport() {
        Thread t = new Thread((Runnable)new HealthGetter(), "HealthGetter$HeathReport");
        t.setDaemon(true);
        t.start();
    }

    @Override
    public Map<String, Object> getHeathReport() {
        if (subhealth) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.report;
    }

    private void getHealThReport() {
        this.report.put(Constant.HEALTHSTATUSENUM, Float.valueOf(0.0f));
        this.getThreadDeadLockReport();
        this.getConnectPoolReport();
        this.getMemoryReport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getConnectPoolReport() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        List<ObjectName> list = jdbcSurceObjNameLs;
        synchronized (list) {
            if (jdbcSurceObjNameLs.size() == 0) {
                Set<ObjectInstance> soi = mbs.queryMBeans(null, null);
                for (ObjectInstance oi : soi) {
                    if (!"com.apusic.jdbc.JDBCResource".equals(oi.getClassName())) continue;
                    ObjectName on = oi.getObjectName();
                    jdbcSurceObjNameLs.add(on);
                }
            }
        }
        ArrayList dataSourceHealthReport = new ArrayList();
        for (ObjectName on : jdbcSurceObjNameLs) {
            try {
                HashMap<String, Object> dataSourceHealthInfo = new HashMap<String, Object>();
                dataSourceHealthInfo.put(Constant.HEALTHSTATUSENUM, Float.valueOf(0.0f));
                String ais = (String)mbs.getAttribute(on, "Name");
                dataSourceHealthInfo.put(Constant.AIS, ais);
                int max_con_pool = (Integer)mbs.getAttribute(on, "MaxPoolSize");
                int availbale_con_count = (Integer)mbs.getAttribute(on, "CurrentAvailableConnectionCount");
                int current_con_count = (Integer)mbs.getAttribute(on, "CurrentConnectionCount");
                dataSourceHealthInfo.put(Constant.MAX_CON_POOL, max_con_pool);
                dataSourceHealthInfo.put(Constant.CURENT_CON_COUNT, current_con_count);
                dataSourceHealthInfo.put(Constant.AVAILABLE_CON_COUNT, availbale_con_count);
                if (current_con_count >= max_con_pool && availbale_con_count <= 0) {
                    dataSourceHealthInfo.put(Constant.HEALTHSTATUSENUM, Float.valueOf(-2.0f));
                    this.report.put(Constant.HEALTHSTATUSENUM, Float.valueOf(-2.0f));
                    dataSourceHealthInfo.put(Constant.HEALTHSTATUSINFORMATION, "\u4e25\u91cd\u9519\u8bef\uff0c\u6570\u636e\u4e2d\u5fc3 " + ais + " \u8fde\u63a5\u6c60\u8017\u5c3d\uff0c\u6700\u5927\u8fde\u63a5\u6570\uff1a" + max_con_pool + " ; \u5df2\u7528\u8fde\u63a5\u6570\uff1a" + current_con_count);
                }
                dataSourceHealthReport.add(dataSourceHealthInfo);
            }
            catch (AttributeNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstanceNotFoundException e) {
                e.printStackTrace();
            }
            catch (MBeanException e) {
                e.printStackTrace();
            }
            catch (ReflectionException e) {
                e.printStackTrace();
            }
        }
        this.report.put(Constant.AIS_LS, dataSourceHealthReport);
    }

    private void getThreadDeadLockReport() {
        if (System.currentTimeMillis() - this.timesnamp < 180000L) {
            return;
        }
        this.timesnamp = System.currentTimeMillis();
        HashMap<String, Object> threadDeadLockHealthInfo = new HashMap<String, Object>();
        threadDeadLockHealthInfo.put(Constant.HEALTHSTATUSENUM, Float.valueOf(0.0f));
        threadDeadLockHealthInfo.put(Constant.HEALTHSTATUSINFORMATION, ThreadDeadLockHealthInfo.NORMAL);
        long[] deadlockedThreadIds = this.mbean.findDeadlockedThreads();
        if (deadlockedThreadIds != null) {
            ThreadInfo[] threadInfos = this.mbean.getThreadInfo(deadlockedThreadIds, 50);
            threadDeadLockHealthInfo.put(Constant.HEALTHSTATUSENUM, Float.valueOf(-2.0f));
            StringBuffer sb = new StringBuffer();
            for (ThreadInfo t : threadInfos) {
                StackTraceElement[] stackTraceElements;
                sb.append("\r\nthread ").append(t.getThreadName()).append(" locked by ").append(t.getLockName()).append(" which ownered by ").append(t.getLockOwnerId()).append("\r\n");
                for (StackTraceElement s : stackTraceElements = t.getStackTrace()) {
                    sb.append("\r\n").append(s);
                }
            }
            threadDeadLockHealthInfo.put(Constant.HEALTHSTATUSINFORMATION, sb.toString());
            this.report.put(Constant.HEALTHSTATUSENUM, Float.valueOf(-2.0f));
        }
        this.report.put(Constant.DEAD_LOCK_CHECKED_INFO, threadDeadLockHealthInfo);
    }

    private void getMemoryReport() {
        if (!this.oomed) {
            HashMap<String, Object> memoryHealthInfo;
            block5: {
                long totalMemory = Runtime.getRuntime().totalMemory();
                long freeMemory = Runtime.getRuntime().freeMemory();
                long maxMemory = Runtime.getRuntime().maxMemory();
                memoryHealthInfo = new HashMap<String, Object>();
                memoryHealthInfo.put(Constant.TOTALMEMORY, totalMemory);
                memoryHealthInfo.put(Constant.FREEMEMORY, freeMemory);
                memoryHealthInfo.put(Constant.MAXMEMORY, maxMemory);
                memoryHealthInfo.put(Constant.HEALTHSTATUSENUM, Float.valueOf(0.0f));
                memoryHealthInfo.put(Constant.HEALTHSTATUSINFORMATION, MemoryHealthInfo.NORMAL);
                memoryHealthInfo.put(Constant.OOMED, false);
                if (totalMemory == maxMemory && (double)freeMemory < (double)maxMemory * 0.03) {
                    int xx = (int)(maxMemory * 2L) / 800;
                    try {
                        long[] ll = new long[xx];
                    }
                    catch (Throwable t) {
                        if (!(t instanceof OutOfMemoryError)) break block5;
                        this.oomed = true;
                        memoryHealthInfo.put(Constant.OOMED, true);
                        memoryHealthInfo.put(Constant.HEALTHSTATUSENUM, Float.valueOf(-2.0f));
                        memoryHealthInfo.put(Constant.HEALTHSTATUSINFORMATION, MemoryHealthInfo.ERROR);
                        this.report.put(Constant.HEALTHSTATUSENUM, Float.valueOf(-2.0f));
                    }
                }
            }
            this.report.put(Constant.MEMORY_REPORT, memoryHealthInfo);
        } else {
            HashMap<String, Boolean> memoryHealthInfo = new HashMap<String, Boolean>();
            memoryHealthInfo.put(Constant.OOMED, true);
            this.report.put(Constant.MEMORY_REPORT, memoryHealthInfo);
            this.report.put(Constant.HEALTHSTATUSENUM, Float.valueOf(-2.0f));
        }
    }

    private class HealthGetter
    extends Thread {
        private HealthGetter() {
        }

        @Override
        public void run() {
            while (true) {
                HeathReport.this.getHealThReport();
                try {
                    Thread.sleep(10000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

