/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.core.rmi;

import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.orm.core.ORMEngine;
import com.kingdee.bos.orm.core.rmi.ObjectProxy;
import com.kingdee.bos.orm.core.rmi.ObjectStub;
import com.kingdee.bos.orm.core.rmi.RMIClassLoader;
import com.kingdee.bos.orm.core.rmi.RMISession;
import com.kingdee.bos.orm.core.rmi.StubContext;
import com.kingdee.bos.orm.impl.service.SessionServer;
import com.kingdee.bos.orm.io.IConnection;
import com.kingdee.bos.orm.rmi.IRMISession;
import com.kingdee.bos.orm.rmi.RMIException;
import com.kingdee.bos.orm.service.IServiceSession;
import java.util.Hashtable;

public class RMIEngine {
    private static Hashtable sessions = new Hashtable();

    public static void releaseObjectStub(Object stub) {
        ObjectStub x = (ObjectStub)stub;
        ObjectStub.releaseStubObject(x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRMISession getCurrentSession() {
        Hashtable hashtable = sessions;
        synchronized (hashtable) {
            return (IRMISession)sessions.get(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setCurrentSession(IRMISession session) {
        Hashtable hashtable = sessions;
        synchronized (hashtable) {
            if (session == null) {
                sessions.remove(Thread.currentThread());
            } else {
                sessions.put(Thread.currentThread(), session);
            }
        }
    }

    public static IRMISession getObjectSession(Object stub) {
        if (!(stub instanceof ObjectStub)) {
            throw new RMIException("object not a RemoteObject.");
        }
        ObjectStub x = (ObjectStub)stub;
        return x.ctx.session;
    }

    protected static ObjectProxy createObjectProxy(RMISession session, Object object, Class model) throws RMIException {
        try {
            Class cls = RMIClassLoader.loadProxyClass(model);
            Class[] types = new Class[]{RMISession.class, Object.class};
            Object[] args = new Object[]{session, object};
            return (ObjectProxy)cls.getConstructor(types).newInstance(args);
        }
        catch (Exception e) {
            throw RMIException.createRMIException(e);
        }
    }

    protected static Object createObjectStub(StubContext stub, Class model) throws RMIException {
        try {
            Class cls = RMIClassLoader.loadStubClass(model);
            Class[] types = new Class[]{StubContext.class};
            Object[] args = new Object[]{stub};
            return cls.getConstructor(types).newInstance(args);
        }
        catch (Exception e) {
            throw RMIException.createRMIException(e);
        }
    }

    public static IORMModel createRemoteObject(String serverUrl, String objectName, Class model) throws ORMCoreException {
        return RMIEngine.createSession(serverUrl).createObject(objectName, model);
    }

    public static IORMModel createRemoteObject(String serverUrl, String objectName, Class model, Class[] initArgTypes, Object[] initArgs) throws ORMCoreException {
        return RMIEngine.createSession(serverUrl).createObject(objectName, model, initArgTypes, initArgs);
    }

    public static IRMISession createSession(String serverUrl) throws RMIException {
        try {
            IConnection cn = ORMEngine.connectionSource.getConnection(serverUrl);
            return RMIEngine.createSession(cn);
        }
        catch (Exception e) {
            throw RMIException.createRMIException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRMISession createSession(IConnection cn) throws RMIException {
        try {
            IConnection iConnection = cn;
            synchronized (iConnection) {
                IServiceSession session = SessionServer.createSession(cn, "ORM_RMI_CALL");
                return new RMISession(session);
            }
        }
        catch (Exception e) {
            throw RMIException.createRMIException(e);
        }
    }
}

