/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.core.rmi;

import com.kingdee.bos.orm.core.rmi.InvokeResult;
import com.kingdee.bos.orm.core.rmi.RMIMonitorFactory;
import com.kingdee.bos.orm.core.rmi.RMISession;
import com.kingdee.bos.orm.core.rmi.RemoteReference;
import com.kingdee.bos.orm.impl.service.InputBlock;
import com.kingdee.bos.rpc.performance.DefaultInvokeMonitor;
import com.kingdee.bos.rpc.performance.InvokeRecord;
import com.kingdee.bos.rpc.trace.TraceInvokeMonitor;
import com.kingdee.util.StringUtils;
import com.tool.classfile.sc;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public final class RMIMonitor {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.orm.core.rmi.RMIMonitor");
    public static final int UNREADY = 0;
    public static final int RUNNING = 1;
    public static final int WAITING = 2;
    public static final int TIMER_UNREADY = 0;
    public static final int TIMER_RUNNING = 1;
    public static final int TIMER_PAUSE = 2;
    public static final String START = "START";
    public static final String PAUSE = "PAUSE";
    public static final String STOP = "STOP";
    public static final String RESET = "RESET";
    public static final String GETSTATE = "GETSTATE";
    public static final String GETNAME = "GETNAME";
    public static final String SETNAME = "SETNAME";
    public static final String SAVEPATH = "SAVEPATH";
    public static final String COMMENT = "COMMENT";
    public static final String START_TIMER = "START_TIMER";
    public static final String STOP_TIMER = "STOP_TIMER";
    public static final String PAUSE_TIMER = "PAUSE_TIMER";
    public static final String RESET_TIMER = "RESET_TIMER";
    public static final String GET_TIMER = "GET_TIMER";
    public static final String COMMENTMETHODSIG = "traceComment(Ljava/lang/String;)V";
    private String name = null;
    private String traceLogSavePath = null;
    private int state = 0;
    private final int monitorPort;
    private ObjectOutputStream _os = null;
    protected static MonitorMgmtThread mgmtThread = null;
    private long timer = 0L;
    private int timerState = 0;
    private TraceInvokeMonitor newRPCTraceMonitor;
    private DefaultInvokeMonitor rpcMonitor;

    RMIMonitor(int monitorPort) {
        this.monitorPort = monitorPort;
        JVMHook hook = new JVMHook(this);
        Runtime.getRuntime().addShutdownHook(hook);
        if (mgmtThread == null) {
            mgmtThread = new MonitorMgmtThread(monitorPort, this);
            mgmtThread.setDaemon(true);
            mgmtThread.start();
        }
    }

    public synchronized void start() {
        if (this.state == 0) {
            if (StringUtils.isEmpty((String)this.getName())) {
                throw new IllegalStateException("Trace log name cannot be empty!");
            }
            ObjectOutputStream os = null;
            try {
                this.state = 1;
                os = this.getObjectOutputStream();
                if (os == null) {
                    this.state = 0;
                }
            }
            catch (IOException ioe) {
                this.state = 0;
                this.closeObjectOutputStream();
                throw new IllegalStateException("Cannot open stream!");
            }
            if (this.newRPCTraceMonitor == null) {
                this.newRPCTraceMonitor = new TraceInvokeMonitor();
            }
            this.newRPCTraceMonitor.install();
            if (this.rpcMonitor == null) {
                this.rpcMonitor = new DefaultInvokeMonitor(true, true);
            }
            this.rpcMonitor.install();
            this.state = 1;
            logger.info((Object)("RMIMonitor[" + this.getName() + "] is started!"));
        } else if (this.state == 2) {
            this.state = 1;
        }
    }

    public synchronized void pause() {
        if (this.state == 0) {
            return;
        }
        if (this.state == 1) {
            this.state = 2;
            logger.info((Object)("RMIMonitor[" + this.getName() + "] is paused!"));
        }
    }

    public synchronized void reset() {
        logger.info((Object)("RMIMonitor[" + this.getName() + "] is reseted!"));
        this.closeObjectOutputStream();
        this.start();
    }

    public synchronized void stop() {
        this.closeObjectOutputStream();
        this.newRPCTraceMonitor.restore();
        this.rpcMonitor.restore();
        logger.info((Object)("RMIMonitor[" + this.getName() + "] is stoped!"));
        this.setName(RMIMonitorFactory.getLogName());
    }

    public synchronized void trace(RMISession session, byte[] outData, InvokeResult result) {
        if (this.state != 1) {
            return;
        }
        this.trace0(session, outData, result);
    }

    public synchronized void comment(String comment) {
        if (this.state != 1) {
            return;
        }
        try {
            this.traceCommentMethod(this.getObjectOutputStream(), comment);
        }
        catch (Exception e) {
            this.state = 0;
            this.closeObjectOutputStream();
        }
    }

    public long getTimer() {
        return this.timer;
    }

    public int getTimerState() {
        return this.timerState;
    }

    public synchronized void startTimer() {
        if (this.timerState == 1) {
            return;
        }
        if (this.timerState != 2) {
            this.timer = 0L;
        }
        this.timerState = 1;
    }

    public synchronized void stopTimer() {
        this.timerState = 0;
    }

    public synchronized void pauseTimer() {
        this.timerState = 2;
    }

    public synchronized void resetTimer() {
        this.startTimer();
    }

    synchronized void addInterval(long interval) {
        this.timer += interval;
    }

    private synchronized void trace0(RMISession session, byte[] outData, InvokeResult result) {
        ObjectOutputStream os = null;
        try {
            os = this.getObjectOutputStream();
            InputBlock ibcode = new InputBlock(null, outData);
            RemoteReference rf = new RemoteReference(ibcode.in.readLong());
            String methodSig = session.readClientMethodSig(ibcode.in);
            if (methodSig.equals("createRemoteObject(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)Lcom/kingdee/bos/orm/IORMModel;")) {
                this.traceCreateObjectMethod(os, session, methodSig, result, ibcode);
            } else {
                this.traceCommonMethod(os, methodSig, ibcode, rf);
            }
        }
        catch (Exception e) {
            this.state = 0;
            this.closeObjectOutputStream();
        }
    }

    public synchronized void traceNewRPC(InvokeRecord record) {
        if (this.state != 1) {
            return;
        }
        ObjectOutputStream os = null;
        try {
            os = this.getObjectOutputStream();
            switch (record.command) {
                case 20: {
                    if (record.err != null) {
                        return;
                    }
                    InvokeRecord.MethodInvoke mi = (InvokeRecord.MethodInvoke)record.detail;
                    String methodDes = sc.methodDescriptor((Method)mi.method);
                    String methodSig = mi.method.getName() + methodDes;
                    os.writeLong(mi.objectId);
                    os.writeObject(methodSig);
                    String[] params = sc.methodParameters((String)methodDes);
                    String javaType = null;
                    for (int i = 0; i < params.length; ++i) {
                        javaType = sc.javaType((String)params[i]);
                        if (sc.isPrimitive((String)sc.classDescriptor((String)javaType))) {
                            javaType = params[i];
                            if (javaType.equalsIgnoreCase("B")) {
                                os.writeByte(((Byte)mi.args[i]).byteValue());
                                continue;
                            }
                            if (javaType.equalsIgnoreCase("S")) {
                                os.writeShort(((Short)mi.args[i]).shortValue());
                                continue;
                            }
                            if (javaType.equalsIgnoreCase("I")) {
                                os.writeInt((Integer)mi.args[i]);
                                continue;
                            }
                            if (javaType.equalsIgnoreCase("F")) {
                                os.writeFloat(((Float)mi.args[i]).floatValue());
                                continue;
                            }
                            if (javaType.equalsIgnoreCase("Z")) {
                                os.writeBoolean((Boolean)mi.args[i]);
                                continue;
                            }
                            if (javaType.equalsIgnoreCase("D")) {
                                os.writeDouble((Double)mi.args[i]);
                                continue;
                            }
                            if (javaType.equalsIgnoreCase("C")) {
                                os.writeChar(((Character)mi.args[i]).charValue());
                                continue;
                            }
                            if (!javaType.equalsIgnoreCase("J")) continue;
                            os.writeLong((Long)mi.args[i]);
                            continue;
                        }
                        os.writeObject(mi.args[i]);
                    }
                    break;
                }
                case 0: {
                    if (record.err != null) {
                        return;
                    }
                    InvokeRecord.MethodInvoke mi = (InvokeRecord.MethodInvoke)record.detail;
                    String methodDes = sc.methodDescriptor((Method)mi.method);
                    String methodSig = mi.method.getName() + methodDes;
                    os.writeLong(mi.objectId);
                    os.writeObject(methodSig);
                    String[] params = sc.methodParameters((String)methodDes);
                    String javaType = null;
                    for (int i = 0; i < params.length; ++i) {
                        javaType = sc.javaType((String)params[i]);
                        if (sc.isPrimitive((String)sc.classDescriptor((String)javaType))) {
                            javaType = params[i];
                            if (javaType.equalsIgnoreCase("B")) {
                                os.writeByte(((Byte)mi.args[i]).byteValue());
                                continue;
                            }
                            if (javaType.equalsIgnoreCase("S")) {
                                os.writeShort(((Short)mi.args[i]).shortValue());
                                continue;
                            }
                            if (javaType.equalsIgnoreCase("I")) {
                                os.writeInt((Integer)mi.args[i]);
                                continue;
                            }
                            if (javaType.equalsIgnoreCase("F")) {
                                os.writeFloat(((Float)mi.args[i]).floatValue());
                                continue;
                            }
                            if (javaType.equalsIgnoreCase("Z")) {
                                os.writeBoolean((Boolean)mi.args[i]);
                                continue;
                            }
                            if (javaType.equalsIgnoreCase("D")) {
                                os.writeDouble((Double)mi.args[i]);
                                continue;
                            }
                            if (javaType.equalsIgnoreCase("C")) {
                                os.writeChar(((Character)mi.args[i]).charValue());
                                continue;
                            }
                            if (!javaType.equalsIgnoreCase("J")) continue;
                            os.writeLong((Long)mi.args[i]);
                            continue;
                        }
                        os.writeObject(mi.args[i]);
                    }
                    break;
                }
                case 3: {
                    if (record.err != null) {
                        return;
                    }
                    InvokeRecord.CreateObject co = (InvokeRecord.CreateObject)record.detail;
                    long id = co.objectId;
                    String serverUrl = record.url;
                    String objectName = co.name;
                    Class model = co.model;
                    Class[] initArgTypes = co.argTypes;
                    Object[] initArgs = co.args;
                    os.writeLong(id);
                    os.writeObject("createRemoteObject(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)Lcom/kingdee/bos/orm/IORMModel;");
                    os.writeObject(serverUrl);
                    os.writeObject(objectName);
                    os.writeObject(model.getName());
                    int numArgs = initArgs == null ? 0 : initArgs.length;
                    os.writeInt(initArgs == null ? 0 : initArgs.length);
                    for (int i = 0; i < numArgs; ++i) {
                        os.writeObject(initArgTypes[i].getName());
                        os.writeObject(initArgs[i]);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.state = 0;
            this.closeObjectOutputStream();
        }
    }

    private synchronized void traceCreateObjectMethod(ObjectOutputStream os, RMISession session, String methodSig, InvokeResult result, InputBlock ibcode) throws IOException, ClassNotFoundException {
        if (result.state != 0) {
            return;
        }
        String serverUrl = (String)ibcode.in.readObject();
        serverUrl = session.getServiceSession().getConnection().getConnectionString();
        String objectName = (String)ibcode.in.readObject();
        Class model = (Class)ibcode.in.readObject();
        Class[] initArgTypes = (Class[])ibcode.in.readObject();
        Object[] initArgs = (Object[])ibcode.in.readObject();
        os.writeLong(((RemoteReference)result.value).id);
        os.writeObject(methodSig);
        os.writeObject(serverUrl);
        os.writeObject(objectName);
        os.writeObject(model.getName());
        os.writeInt(initArgs.length);
        for (int i = 0; i < initArgTypes.length; ++i) {
            os.writeObject(initArgTypes[i].getName());
            os.writeObject(initArgs[i]);
        }
    }

    private synchronized void traceCommonMethod(ObjectOutputStream os, String methodSig, InputBlock ibcode, RemoteReference rf) throws IOException, ClassNotFoundException {
        int index = methodSig.indexOf("(");
        String methodDes = methodSig.substring(index);
        os.writeLong(rf.id);
        os.writeObject(methodSig);
        String[] params = sc.methodParameters((String)methodDes);
        String javaType = null;
        for (int i = 0; i < params.length; ++i) {
            javaType = sc.javaType((String)params[i]);
            if (sc.isPrimitive((String)sc.classDescriptor((String)javaType))) {
                javaType = params[i];
                if (javaType.equalsIgnoreCase("B")) {
                    os.writeByte(ibcode.in.readByte());
                    continue;
                }
                if (javaType.equalsIgnoreCase("S")) {
                    os.writeShort(ibcode.in.readShort());
                    continue;
                }
                if (javaType.equalsIgnoreCase("I")) {
                    os.writeInt(ibcode.in.readInt());
                    continue;
                }
                if (javaType.equalsIgnoreCase("F")) {
                    os.writeFloat(ibcode.in.readFloat());
                    continue;
                }
                if (javaType.equalsIgnoreCase("Z")) {
                    os.writeBoolean(ibcode.in.readBoolean());
                    continue;
                }
                if (javaType.equalsIgnoreCase("D")) {
                    os.writeDouble(ibcode.in.readDouble());
                    continue;
                }
                if (javaType.equalsIgnoreCase("C")) {
                    os.writeChar(ibcode.in.readChar());
                    continue;
                }
                if (!javaType.equalsIgnoreCase("J")) continue;
                os.writeLong(ibcode.in.readLong());
                continue;
            }
            os.writeObject(ibcode.in.readObject());
        }
    }

    private synchronized void traceCommentMethod(ObjectOutputStream os, String comment) throws IOException {
        os.writeLong(-1L);
        os.writeObject(COMMENTMETHODSIG);
        os.writeObject(comment);
    }

    public synchronized String getName() {
        return this.name;
    }

    public int getPort() {
        return this.monitorPort;
    }

    public synchronized void setName(String name) {
        if (this.state != 0) {
            throw new IllegalStateException("Servier is running, cannot modify the name");
        }
        this.name = name;
    }

    public synchronized String getTraceLogSavePath() {
        return this.traceLogSavePath;
    }

    public int getState() {
        return this.state;
    }

    public synchronized void setTraceLogSavePath(String traceLogSavePath) {
        if (this.state != 0) {
            throw new IllegalStateException("Servier is running, cannot modify the name");
        }
        this.traceLogSavePath = traceLogSavePath;
    }

    synchronized ObjectOutputStream getObjectOutputStream() throws IOException {
        if (this.state == 1) {
            if (this._os != null) {
                return this._os;
            }
            File logFile = null;
            if (!StringUtils.isEmpty((String)this.getTraceLogSavePath())) {
                File root = new File(this.getTraceLogSavePath());
                if (!root.exists()) {
                    root.mkdirs();
                }
                logFile = new File(root, this.getName());
            } else {
                logFile = new File(this.getName());
            }
            if (!logFile.exists()) {
                logFile.createNewFile();
            }
            this._os = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(logFile)));
            return this._os;
        }
        return null;
    }

    synchronized void closeObjectOutputStream() {
        try {
            if (this._os != null) {
                this._os.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._os = null;
        this.state = 0;
    }

    static class CommandProcessThread
    extends Thread {
        private Socket socket = null;
        private final BufferedReader in;
        private final PrintWriter out;
        private final RMIMonitor monitor;

        public CommandProcessThread(Socket socket, RMIMonitor monitor) throws IOException {
            super("RMIMonitorCommandProcessThread");
            this.socket = socket;
            this.monitor = monitor;
            this.in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            this.out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())), true);
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String command = this.in.readLine();
                if ("END".equalsIgnoreCase(command)) {
                } else {
                    this.processCommand(command);
                    this.out.println("END");
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processCommand(String command) {
            RMIMonitor rMIMonitor = this.monitor;
            synchronized (rMIMonitor) {
                logger.info((Object)("RMIMonitor COMMAND:" + command));
                StringTokenizer token = new StringTokenizer(command, "$&$");
                String action = token.nextToken();
                if (RMIMonitor.START.equalsIgnoreCase(action)) {
                    if (this.monitor.getState() == 0 || this.monitor.getState() == 2) {
                        this.monitor.start();
                        this.out.println("The RMIMonitor has started!");
                    } else {
                        this.out.println("The RMIMonitor is running!");
                    }
                } else if (RMIMonitor.GETNAME.equalsIgnoreCase(action)) {
                    this.out.println(this.monitor.getName());
                } else if (RMIMonitor.GETSTATE.equalsIgnoreCase(action)) {
                    String strState = null;
                    if (this.monitor.getState() == 1) {
                        strState = "RUNNING";
                    } else if (this.monitor.getState() == 0) {
                        strState = "UNREADY";
                    } else if (this.monitor.getState() == 2) {
                        strState = "WAITING";
                    }
                    this.out.println("The RMIMonitor is " + strState);
                } else if (RMIMonitor.COMMENT.equalsIgnoreCase(action)) {
                    String comment = null;
                    if (token.hasMoreTokens()) {
                        comment = token.nextToken();
                    }
                    this.monitor.comment(comment);
                    this.out.println("COMMENT:" + comment);
                } else if (RMIMonitor.SETNAME.equalsIgnoreCase(action)) {
                    String name = null;
                    if (token.hasMoreTokens()) {
                        name = token.nextToken();
                    }
                    if (!StringUtils.isEmpty(name)) {
                        this.monitor.setName(name);
                    }
                    this.out.println("The RMIMonitor's trace name is set to \"" + name + "\"");
                } else if (RMIMonitor.SAVEPATH.equalsIgnoreCase(action)) {
                    this.out.println("The RMIMonitor's trace path is" + this.monitor.getTraceLogSavePath());
                } else if (RMIMonitor.PAUSE.equalsIgnoreCase(action)) {
                    this.monitor.pause();
                    this.out.println("The RMIMonitor is paused!");
                } else if (RMIMonitor.STOP.equalsIgnoreCase(action)) {
                    this.monitor.stop();
                    this.out.println("The RMIMonitor is stoped!");
                } else if (RMIMonitor.RESET.equalsIgnoreCase(action)) {
                    this.monitor.reset();
                    this.out.println("The RMIMonitor is reseted!");
                } else if (RMIMonitor.START_TIMER.equalsIgnoreCase(action)) {
                    this.monitor.startTimer();
                    this.out.println("The timer is started!");
                } else if (RMIMonitor.PAUSE_TIMER.equalsIgnoreCase(action)) {
                    this.monitor.pauseTimer();
                    this.out.println("The timer is paused!");
                } else if (RMIMonitor.STOP_TIMER.equalsIgnoreCase(action)) {
                    this.monitor.stopTimer();
                    this.out.println("The timer is stoped!");
                } else if (RMIMonitor.RESET_TIMER.equalsIgnoreCase(action)) {
                    this.monitor.resetTimer();
                    this.out.println("The timer is reseted!");
                } else if (RMIMonitor.GET_TIMER.equalsIgnoreCase(action)) {
                    this.out.println("The timer is [" + this.monitor.getTimer() + "]");
                } else {
                    this.out.println("Unprocesed action[" + action + "]");
                }
            }
        }
    }

    static class MonitorMgmtThread
    extends Thread {
        private boolean isStarted = false;
        private final RMIMonitor monitor;
        private final int port;
        ServerSocket serverSocket = null;

        MonitorMgmtThread(int port, RMIMonitor monitor) {
            super("RMIMonitorThread");
            this.port = port;
            this.monitor = monitor;
        }

        public boolean isStarted() {
            return this.isStarted;
        }

        @Override
        public void run() {
            try {
                this.serverSocket = new ServerSocket(this.port);
                logger.info((Object)("RMI-Monitor Management[port:" + this.port + "] Thread started!"));
                this.isStarted = true;
            }
            catch (IOException ioe) {
                if (this.serverSocket != null) {
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
                return;
            }
            Socket s = null;
            while (true) {
                try {
                    while (!this.serverSocket.isClosed()) {
                        s = this.serverSocket.accept();
                        new CommandProcessThread(s, this.monitor);
                    }
                }
                catch (IOException e) {
                    if (s == null) continue;
                    try {
                        s.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                break;
            }
        }
    }

    private static class JVMHook
    extends Thread {
        RMIMonitor monitor;

        private JVMHook(RMIMonitor monitor) {
            this.monitor = monitor;
        }

        @Override
        public void run() {
            this.monitor.closeObjectOutputStream();
            try {
                if (mgmtThread != null && RMIMonitor.mgmtThread.serverSocket != null) {
                    RMIMonitor.mgmtThread.serverSocket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

