/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.core.rmi;

import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.core.rmi.InvokeResult;
import com.kingdee.bos.orm.core.rmi.ObjectProxy;
import com.kingdee.bos.orm.core.rmi.RMIEngine;
import com.kingdee.bos.orm.core.rmi.RMISession;
import com.kingdee.bos.orm.core.rmi.RemoteReference;
import com.kingdee.bos.orm.rmi.IRMISession;
import com.kingdee.bos.orm.rmi.RMIException;
import com.kingdee.bos.orm.service.IService;
import com.kingdee.bos.orm.service.IServiceSession;
import com.kingdee.bos.orm.template.ORMObject;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import org.apache.log4j.Logger;

public class RMIService
extends ORMObject
implements IService {
    public static final int LIMIT_ERROR = 0x1E00000;
    public static final int LIMIT_LOG = 0xA00000;
    public static final String RMI_METHOD = "ORM_RMI_CALL";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.orm.core.rmi.RMIService");

    public RMIService() {
        this(null);
    }

    public RMIService(IORMModel owner) {
        super(owner);
        super.registerInterface(IService.class, this);
    }

    @Override
    public boolean accept(String method) {
        return method.equals(RMI_METHOD);
    }

    public void closeSession(IServiceSession session) {
        RMISession.getRMISession(session).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] service(IServiceSession session, String method, byte[] requestData) {
        IRMISession oldSession = RMIEngine.getCurrentSession();
        RMISession rmiSession = RMISession.getRMISession(session);
        RMIEngine.setCurrentSession(rmiSession);
        try {
            byte[] byArray;
            InvokeResult r;
            String methodsig = null;
            ObjectProxy proxy = null;
            try {
                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(requestData));
                RemoteReference ref = new RemoteReference(in.readLong());
                methodsig = rmiSession.readMethodSig(in);
                proxy = rmiSession.getObjectProxy(ref);
                if (proxy == null) {
                    if (methodsig.equals("finalize()V")) {
                        r = new InvokeResult(2, null);
                    } else {
                        logger.debug((Object)(session + "\t#" + ref.id + " not found."));
                        r = new InvokeResult(1, new RMIException(ref + " not found. method = " + methodsig));
                    }
                } else {
                    r = proxy.processInvoke(methodsig, in);
                    if (r == null) {
                        r = new InvokeResult(1, new RMIException("method not found " + methodsig + ", class=" + proxy.getClass().getName()));
                    }
                    if (r.state == 2) {
                        rmiSession.releaseObjectProxy(ref);
                        proxy.release();
                    }
                }
            }
            catch (Throwable e) {
                r = new InvokeResult(1, e);
            }
            try {
                byte[] bs = r.toByteArray();
                if (bs.length > 0x1E00000) {
                    logger.error((Object)("Object[" + proxy + "] Method[" + methodsig + "] return data[" + bs.length + "]"));
                    r = new InvokeResult(1, new RMIException("Method return data too long!"));
                    bs = r.toByteArray();
                } else if (bs.length > 0xA00000) {
                    logger.warn((Object)("Object[" + proxy + "] Method[" + methodsig + "] return data[" + bs.length + "]"));
                }
                byArray = bs;
                return byArray;
            }
            catch (Exception e) {
                logger.error((Object)e);
                byArray = null;
                RMIEngine.setCurrentSession(oldSession);
                return byArray;
            }
        }
        finally {
            RMIEngine.setCurrentSession(oldSession);
        }
    }
}

