/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.impl.io;

import com.kingdee.bos.orm.io.IConnection;
import com.kingdee.bos.orm.io.IConnectionDriver;
import com.kingdee.bos.orm.io.IConnectionHelper;
import com.kingdee.bos.orm.io.IConnectionManager;
import com.kingdee.bos.orm.io.IConnectionServiceManager;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.bos.util.EasyTool;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;

public class ConnectionManager
extends ORMObject
implements IConnectionManager {
    Vector drivers = new Vector();
    IConnectionServiceManager serviceManager;

    public ConnectionManager(IConnectionServiceManager _serviceManager) {
        super.registerInterface(IConnectionManager.class, this);
        this.serviceManager = _serviceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDriver(IConnectionDriver driver) {
        Vector vector = this.drivers;
        synchronized (vector) {
            this.drivers.insertElementAt(driver, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDriver(IConnectionDriver driver) {
        Vector vector = this.drivers;
        synchronized (vector) {
            this.drivers.removeElement(driver);
        }
    }

    @Override
    public IConnectionDriver[] getDrivers() {
        return (IConnectionDriver[])EasyTool.copyArray((Vector)this.drivers, IConnectionDriver.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IConnectionHelper directConnect(String url, Properties props) throws IOException {
        IConnectionDriver driver = null;
        Vector vector = this.drivers;
        synchronized (vector) {
            for (int i = 0; i < this.drivers.size(); ++i) {
                IConnectionDriver drv = (IConnectionDriver)this.drivers.elementAt(i);
                if (!drv.accept(url)) continue;
                driver = drv;
                break;
            }
        }
        if (driver == null) {
            throw new IOException("unknown protocol url " + url);
        }
        return driver.connect(url, props);
    }

    @Override
    public IConnection connect(String url, Properties props) throws IOException {
        IConnectionHelper helper = this.directConnect(url, props);
        return this.serviceManager.createConnection(helper, url, props);
    }

    @Override
    public IConnection connect(String url) throws IOException {
        return this.connect(url, new Properties());
    }
}

