/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.impl.io;

import com.kingdee.bos.orm.core.ORMEngine;
import com.kingdee.bos.orm.impl.io.Connection;
import com.kingdee.bos.orm.impl.service.SessionServer;
import com.kingdee.bos.orm.io.ConnectionConfigure;
import com.kingdee.bos.orm.io.ConnectionException;
import com.kingdee.bos.orm.io.DataBlock;
import com.kingdee.bos.orm.io.IConnection;
import com.kingdee.bos.orm.io.IConnectionHelper;
import com.kingdee.bos.orm.io.IConnectionServiceManager;
import com.kingdee.bos.orm.io.IConnectionSetting;
import com.kingdee.bos.orm.service.IServiceManager;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.bos.util.EasyTool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;

public class ConnectionServiceManager
extends ORMObject
implements IConnectionServiceManager {
    public final IServiceManager serviceManager;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.orm.impl.io.ConnectionServiceManager");
    IConnectionSetting setting = null;
    public static final String COMPRESS_SIZE = "Compress Size";
    public static final int COMPRESS_NONE = Integer.MAX_VALUE;
    public static final int COMPRESS_MIN = 512;
    public static final int COMPRESS_DEFAULT = Integer.MAX_VALUE;
    private static final int COMPRESSED = 1;

    public ConnectionServiceManager(IServiceManager _serviceManager) {
        super.registerInterface(IConnectionServiceManager.class, this);
        this.serviceManager = _serviceManager;
    }

    @Override
    public IConnectionSetting getConnectionSetting() {
        return this.setting;
    }

    @Override
    public void setConnectionSetting(IConnectionSetting _setting) {
        this.setting = _setting;
    }

    protected ConnectionConfigure getConnectionConfigure(String url, Properties props) {
        ConnectionConfigure config = null;
        if (this.setting != null) {
            config = this.setting.getConnectionConfig(url, props);
        }
        if (config == null) {
            config = new ConnectionConfigure();
        }
        return config;
    }

    @Override
    public IConnection createConnection(IConnectionHelper helper, String url, Properties props) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        ConnectionConfigure config = this.getConnectionConfigure(url, props);
        out.writeObject(config);
        out.flush();
        byte[] configData = bout.toByteArray();
        helper.sendBlock(configData, 0, configData.length);
        _Connection cn = new _Connection(helper, config);
        cn.put("_Connection_URL", url);
        SessionServer.startConnectionService(cn, this.serviceManager, false);
        return cn;
    }

    @Override
    public void receiveConnection(String url, IConnectionHelper helper) {
        _Connection cn = new _Connection(helper, null);
        cn.put("_Connection_URL", url);
        ORMEngine.startThread(cn);
    }

    static class _DataBlock
    extends DataBlock {
        byte[] orgData;

        _DataBlock(byte[] _orgData) {
            super(null, 0, 0);
            this.orgData = _orgData;
        }

        private int getFlag() {
            return this.orgData[0] & 0xFF;
        }

        private boolean isCompressed() {
            return (this.getFlag() & 1) != 0;
        }

        void initData() throws IOException {
            if (this.data != null) {
                return;
            }
            if (!this.isCompressed()) {
                this.data = this.orgData;
                this.offset = 1;
                this.length = this.data.length - 1;
            } else {
                GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(this.orgData, 1, this.orgData.length - 1));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                EasyTool.copyStream((InputStream)in, (OutputStream)out);
                this.data = out.toByteArray();
                this.offset = 0;
                this.length = this.data.length;
            }
        }

        @Override
        public int getLength() throws IOException {
            this.initData();
            return this.length;
        }

        @Override
        public byte[] getData() throws IOException {
            this.initData();
            return this.data;
        }

        @Override
        public int getOffset() throws IOException {
            this.initData();
            return this.offset;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.initData();
            return new ByteArrayInputStream(this.data, this.offset, this.length);
        }
    }

    class _Connection
    extends Connection
    implements Runnable {
        ConnectionConfigure config;
        Object sendMonitor;
        Object recvMonitor;

        _Connection(IConnectionHelper _helper, ConnectionConfigure _config) {
            super(_helper);
            this.sendMonitor = new Object();
            this.recvMonitor = new Object();
            this.config = _config;
        }

        @Override
        public String getConnectionString() {
            return (String)this.get("_Connection_URL");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendBlock(DataBlock data) throws IOException {
            try {
                Object object = this.sendMonitor;
                synchronized (object) {
                    int compressSize = this.config.getPropertyInt(ConnectionServiceManager.COMPRESS_SIZE, Integer.MAX_VALUE);
                    if (data instanceof _DataBlock) {
                        _DataBlock _data = (_DataBlock)data;
                        if (_data.isCompressed()) {
                            this.helper.sendBlock(_data.orgData, 0, _data.orgData.length);
                        } else if (data.getLength() >= 512 && data.getLength() >= compressSize) {
                            this.sendCompressData(data);
                        } else {
                            this.helper.sendBlock(_data.orgData, 0, _data.orgData.length);
                        }
                    } else if (data.getLength() >= 512 && data.getLength() >= compressSize) {
                        this.sendCompressData(data);
                    } else {
                        byte[] b = new byte[data.getLength() + 1];
                        b[0] = 0;
                        System.arraycopy(data.getData(), data.getOffset(), b, 1, data.getLength());
                        this.helper.sendBlock(b, 0, b.length);
                    }
                }
            }
            catch (IOException ioe) {
                throw new ConnectionException(ioe);
            }
        }

        private void sendCompressData(DataBlock data) throws IOException {
            InputStream in = data.getInputStream();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            bout.write(1);
            GZIPOutputStream out = new GZIPOutputStream(bout);
            EasyTool.copyStream((InputStream)in, (OutputStream)out);
            out.finish();
            byte[] b = bout.toByteArray();
            this.helper.sendBlock(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DataBlock recvBlock() throws IOException {
            try {
                Object object = this.recvMonitor;
                synchronized (object) {
                    byte[] orgData = this.helper.recvBlock();
                    if (orgData == null || orgData.length == 0) {
                        return null;
                    }
                    return new _DataBlock(orgData);
                }
            }
            catch (IOException ioe) {
                throw new ConnectionException(ioe);
            }
        }

        @Override
        public void run() {
            try {
                byte[] configData = this.helper.recvBlock();
                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(configData));
                this.config = (ConnectionConfigure)in.readObject();
                SessionServer.startConnectionService(this, ConnectionServiceManager.this.serviceManager, true);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }
}

