/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.impl.io;

import com.kingdee.bos.orm.IEventContainer;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.orm.io.IConnection;
import com.kingdee.bos.orm.io.IConnectionEvent;
import com.kingdee.bos.orm.io.IConnectionManager;
import com.kingdee.bos.orm.io.IConnectionSource;
import com.kingdee.bos.orm.template.ORMObject;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class ConnectionSource
extends ORMObject
implements IConnectionSource {
    IConnectionManager connectionManager;
    Hashtable connections = new Hashtable();

    public ConnectionSource(IConnectionManager _connectionManager) {
        this(_connectionManager, null);
    }

    public ConnectionSource(IConnectionManager _connectionManager, IORMModel owner) {
        super(owner);
        super.registerInterface(IConnectionSource.class, this);
        this.connectionManager = _connectionManager;
    }

    String getConnectionKey(String url, Properties props) {
        StringBuffer sb = new StringBuffer(url);
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = props.getProperty(name, "");
            sb.append("&");
            sb.append(name);
            sb.append("=");
            sb.append(value);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Vector getCachedConnections(String key) {
        Hashtable hashtable = this.connections;
        synchronized (hashtable) {
            Vector v = (Vector)this.connections.get(key);
            if (v == null) {
                v = new Vector();
                this.connections.put(key, v);
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IConnection getConnection(String url, Properties props) throws IOException {
        Vector v;
        String key = this.getConnectionKey(url, props);
        Vector vector = v = this.getCachedConnections(key);
        synchronized (vector) {
            if (v.size() > 0) {
                IConnection cn = (IConnection)v.remove(0);
                v.addElement(cn);
                return cn;
            }
            IConnection cn = this.connectionManager.connect(url, props);
            try {
                IEventContainer eventContainer = (IEventContainer)cn.queryInterface(IEventContainer.class);
                eventContainer.addEventListener(IConnectionEvent.class, new EventHandler(key, cn));
            }
            catch (ORMCoreException e) {
                e.printStackTrace();
            }
            v.addElement(cn);
            return cn;
        }
    }

    @Override
    public IConnection getConnection(String url) throws IOException {
        return this.getConnection(url, new Properties());
    }

    class EventHandler
    implements IConnectionEvent {
        String key;
        IConnection cn;

        EventHandler(String _key, IConnection _cn) {
            this.key = _key;
            this.cn = _cn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionClosed(IConnection _cn) {
            Vector v;
            Vector vector = v = ConnectionSource.this.getCachedConnections(this.key);
            synchronized (vector) {
                v.removeElement(this.cn);
            }
            try {
                IEventContainer eventContainer = (IEventContainer)this.cn.queryInterface(IEventContainer.class);
                eventContainer.removeEventListener(IConnectionEvent.class, this);
            }
            catch (ORMCoreException e) {
                e.printStackTrace();
            }
        }

        @Override
        public IORMModel queryInterface(Class type) throws ORMCoreException {
            if (type.equals(IORMModel.class) || type.equals(IConnectionEvent.class)) {
                return this;
            }
            return null;
        }
    }
}

