/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.impl.io;

import com.kingdee.bos.orm.impl.io.HttpConnectionDriver;
import com.kingdee.bos.orm.io.IConnectionHelper;
import com.kingdee.bos.orm.template.ObjectContext;
import com.kingdee.bos.util.EasyTool;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

public class HttpConnectionDriver1
extends HttpConnectionDriver {
    @Override
    protected IConnectionHelper createConnection(String httpUrl, String serverUrl, Properties props) throws IOException {
        return new _Connection(httpUrl, serverUrl, props);
    }

    class _Connection
    extends ObjectContext
    implements IConnectionHelper {
        URL url;
        long cnID;
        final Object sendMonitor = new Object();
        final Object recvMonitor = new Object();

        _Connection(String httpUrl, String serverUrl, Properties props) throws IOException {
            super.registerInterface(IConnectionHelper.class, this);
            this.url = new URL(httpUrl);
            URLConnection cn = this.createURLConnection();
            DataOutputStream out = new DataOutputStream(cn.getOutputStream());
            out.writeByte(1);
            EasyTool.writeLine((OutputStream)out, (String)serverUrl);
            props.store(out, "kingdee bos orm connection properties");
            out.flush();
            DataInputStream in = this.getResult(cn);
            this.cnID = in.readLong();
        }

        DataInputStream getResult(URLConnection cn) throws IOException {
            DataInputStream in = new DataInputStream(new BufferedInputStream(cn.getInputStream()));
            byte r = in.readByte();
            if (r == 0) {
                String line = EasyTool.readLine((InputStream)in);
                in.close();
                throw new IOException(line);
            }
            if (r == 1) {
                return in;
            }
            in.close();
            throw new IOException("bad response data.");
        }

        URLConnection createURLConnection() throws IOException {
            URLConnection cn = this.url.openConnection();
            cn.setDoOutput(true);
            cn.setDoInput(true);
            return cn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendBlock(byte[] data, int off, int len) throws IOException {
            Object object = this.sendMonitor;
            synchronized (object) {
                URLConnection cn = this.createURLConnection();
                DataOutputStream out = new DataOutputStream(cn.getOutputStream());
                out.writeByte(2);
                out.writeLong(this.cnID);
                if (data == null || len == -1) {
                    out.writeInt(-1);
                } else {
                    out.writeInt(len);
                    if (len > 0) {
                        out.write(data, off, len);
                    }
                }
                out.flush();
                DataInputStream in = this.getResult(cn);
                in.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] recvBlock() throws IOException {
            Object object = this.recvMonitor;
            synchronized (object) {
                URLConnection cn = this.createURLConnection();
                DataOutputStream out = new DataOutputStream(cn.getOutputStream());
                out.writeByte(3);
                out.writeLong(this.cnID);
                out.flush();
                DataInputStream in = this.getResult(cn);
                int length = in.readInt();
                byte[] data = null;
                if (length >= 0) {
                    data = new byte[length];
                }
                if (length > 0) {
                    in.readFully(data);
                }
                in.close();
                return data;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.sendMonitor;
            synchronized (object) {
                try {
                    URLConnection cn = this.createURLConnection();
                    DataOutputStream out = new DataOutputStream(cn.getOutputStream());
                    out.writeByte(4);
                    out.writeLong(this.cnID);
                    out.flush();
                    DataInputStream in = this.getResult(cn);
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            super.close();
        }
    }
}

