/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.impl.io;

import com.kingdee.bos.orm.impl.io.HttpConnectionDriver;
import com.kingdee.bos.orm.io.IConnectionHelper;
import com.kingdee.bos.orm.template.ObjectContext;
import com.kingdee.bos.util.EasyTool;
import com.kingdee.bos.util.HttpConnection;
import com.kingdee.bos.util.HttpRequest;
import com.kingdee.bos.util.HttpResponse;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class HttpConnectionDriver2
extends HttpConnectionDriver {
    public static final String ORMRPC_PROXYSERVER = "ormrpc.proxyserver";
    public static long CONNECTION_IDLE_TIME = 3000L;

    @Override
    protected IConnectionHelper createConnection(String httpUrl, String serverUrl, Properties props) throws IOException {
        return new _Connection(httpUrl, serverUrl, props);
    }

    class _Connection
    extends ObjectContext
    implements IConnectionHelper {
        String url;
        String server;
        String path;
        String serverUrl;
        long cnID;
        HttpConnection cnSend = null;
        HttpConnection cnRecv = null;
        private final Object sendMonitor = new Object();
        private IdleLoop loop;
        private final Object recvMonitor = new Object();

        _Connection(String httpUrl, String _serverUrl, Properties props) throws IOException {
            this.url = httpUrl;
            this.serverUrl = _serverUrl;
            String proxyServer = System.getProperty(HttpConnectionDriver2.ORMRPC_PROXYSERVER, null);
            this.server = HttpConnection.getServer((String)httpUrl);
            this.path = HttpConnection.getPath((String)httpUrl);
            try {
                this.cnSend = new HttpConnection(this.server, proxyServer);
                HttpRequest request = new HttpRequest(this.path);
                DataOutputStream out = new DataOutputStream(request.getOutputStream());
                out.writeByte(1);
                EasyTool.writeLine((OutputStream)out, (String)this.serverUrl);
                props.store(out, "");
                out.flush();
                DataInputStream in = this.getResult(this.cnSend, request);
                this.cnID = in.readLong();
                in.close();
                this.cnRecv = new HttpConnection(this.server, proxyServer);
            }
            catch (IOException e) {
                if (this.cnSend != null) {
                    this.cnSend.close();
                }
                if (this.cnRecv != null) {
                    this.cnRecv.close();
                }
                throw e;
            }
            this.loop = new IdleLoop(this);
            this.loop.start();
        }

        DataInputStream getResult(HttpConnection cn, HttpRequest request) throws IOException {
            HttpResponse response = cn.sendRequest(request);
            if (!response.getStatusCode().equals("200")) {
                throw new IOException(response.getStatusText());
            }
            DataInputStream in = new DataInputStream(new BufferedInputStream(response.getInputStream()));
            byte r = in.readByte();
            if (r == 0) {
                String err = EasyTool.readLine((InputStream)in);
                throw new IOException(err);
            }
            if (r != 1) {
                throw new IOException("bad response data.");
            }
            return in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendBlock(byte[] data, int off, int len) throws IOException {
            this.sendBlock1(data, off, len);
            IdleLoop idleLoop = this.loop;
            synchronized (idleLoop) {
                this.loop.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendBlock1(byte[] data, int off, int len) throws IOException {
            Object object = this.sendMonitor;
            synchronized (object) {
                HttpRequest request = new HttpRequest(this.path);
                DataOutputStream out = new DataOutputStream(request.getOutputStream());
                out.writeByte(2);
                out.writeLong(this.cnID);
                if (data == null || len < 0) {
                    out.writeInt(-1);
                } else {
                    out.writeInt(len);
                    if (len > 0) {
                        out.write(data, off, len);
                    }
                }
                out.flush();
                DataInputStream in = this.getResult(this.cnSend, request);
                in.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] recvBlock() throws IOException {
            Object object = this.recvMonitor;
            synchronized (object) {
                HttpRequest request = new HttpRequest(this.path);
                DataOutputStream out = new DataOutputStream(request.getOutputStream());
                out.writeByte(3);
                out.writeLong(this.cnID);
                out.flush();
                DataInputStream in = this.getResult(this.cnRecv, request);
                int length = in.readInt();
                byte[] data = null;
                if (length >= 0) {
                    data = new byte[length];
                }
                if (length > 0) {
                    in.readFully(data);
                }
                in.close();
                return data;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.sendMonitor;
            synchronized (object) {
                try {
                    HttpRequest request = new HttpRequest(this.path);
                    DataOutputStream out = new DataOutputStream(request.getOutputStream());
                    out.writeByte(4);
                    out.writeLong(this.cnID);
                    out.flush();
                    DataInputStream in = this.getResult(this.cnSend, request);
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.cnSend != null) {
                this.cnSend.close();
            }
            if (this.cnRecv != null) {
                this.cnRecv.close();
            }
            super.close();
        }
    }

    class IdleLoop
    extends Thread {
        _Connection cn;

        IdleLoop(_Connection _cn) {
            this.cn = _cn;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    IdleLoop idleLoop = this;
                    synchronized (idleLoop) {
                        long t0 = System.currentTimeMillis();
                        this.wait(CONNECTION_IDLE_TIME);
                        long t1 = System.currentTimeMillis();
                        if (t1 - t0 >= CONNECTION_IDLE_TIME) {
                            this.cn.sendBlock1(new byte[0], 0, 0);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                return;
            }
        }
    }
}

