/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.impl.io;

import com.kingdee.bos.orm.io.IConnectionHelper;
import com.kingdee.bos.orm.template.ObjectContext;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.util.EasyTool;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class StreamConnectionHelper
extends ObjectContext
implements IConnectionHelper {
    protected final Object owner;
    protected final DataInputStream in;
    protected final DataOutputStream out;
    protected final Object sendMonitor = new Object();
    protected final Object recvMonitor = new Object();

    public StreamConnectionHelper(Socket sock) throws IOException {
        this(sock, sock.getInputStream(), sock.getOutputStream());
    }

    public StreamConnectionHelper(Object _owner, InputStream _in, OutputStream _out) {
        this.owner = _owner;
        this.in = new DataInputStream(new BufferedInputStream(_in));
        this.out = new DataOutputStream(new BufferedOutputStream(_out, ServerManager.getConfig().bufferedOutSize));
        super.registerInterface(IConnectionHelper.class, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendBlock(byte[] data, int off, int len) throws IOException {
        Object object = this.sendMonitor;
        synchronized (object) {
            if (data == null || len == -1) {
                this.out.writeInt(-1);
            } else {
                this.out.writeInt(len);
                if (data.length > 0) {
                    this.out.write(data, off, len);
                }
            }
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] recvBlock() throws IOException {
        Object object = this.recvMonitor;
        synchronized (object) {
            byte[] data = null;
            int length = this.in.readInt();
            if (length >= 0) {
                data = new byte[length];
            }
            if (length > 0) {
                this.in.readFully(data);
            }
            return data;
        }
    }

    @Override
    public void close() {
        EasyTool.closeAny((Object)this.in);
        EasyTool.closeAny((Object)this.out);
        EasyTool.closeAny((Object)this.owner);
    }
}

