/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.impl.server;

import com.kingdee.bos.orm.core.ORMEngine;
import com.kingdee.bos.orm.impl.io.HttpConnectionDriver2;
import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.orm.io.IConnectionHelper;
import com.kingdee.bos.util.EasyTool;
import com.kingdee.bos.util.GC;
import com.kingdee.bos.util.GCMonitor;
import com.kingdee.bos.util.UniqueID;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class HttpServerImpl
implements GC {
    public static final int CONNECT = 1;
    public static final int SEND = 2;
    public static final int RECV = 3;
    public static final int CLOSE = 4;
    public static final int SUCCEEDED = 1;
    public static final int FAILED = 0;
    public static final long TIMEOUT = 30000L;
    public static int RECV_TIMEOUT = 3000;
    private UniqueID connSeq = new UniqueID(1001L);
    private Hashtable connections = new Hashtable();
    private static final String CONNECTION_TIMEOUT = "_Http_Connection_Timeout";
    private static final String CONNECTION_REFS = "_Http_Connection_Refs";
    private static final String CONNECTION_RECV = "_Http_Connection_Recv";

    public HttpServerImpl() {
        if (!ORMRPConfig.isLoaded()) {
            ORMRPConfig.loadConfig();
        }
        RECV_TIMEOUT = ORMRPConfig.getHttpIdleTimeout();
        HttpConnectionDriver2.CONNECTION_IDLE_TIME = ORMRPConfig.getHttpIdleTimeout();
        GCMonitor.add((GC)this);
    }

    private void doConnect(DataInputStream in, DataOutputStream out) throws IOException {
        String serverUrl = EasyTool.readLine((InputStream)in);
        Properties props = new Properties();
        props.load(in);
        IConnectionHelper cn = null;
        try {
            cn = this.createConnection(serverUrl, props);
            Receiver receiver = new Receiver(cn);
            receiver.start();
            cn.put(CONNECTION_RECV, receiver);
        }
        catch (Exception e) {
            this.doError(out, e);
            return;
        }
        long cnID = this.addConnection(cn);
        try {
            out.writeByte(1);
            out.writeLong(cnID);
            out.flush();
        }
        catch (IOException ioe) {
            this.removeConnection(cnID);
            throw ioe;
        }
    }

    private void connectionNotFound(DataOutputStream out, long cnID) throws IOException {
        this.doError(out, "Connection#" + cnID + " not found or closed.");
    }

    private void doRecv(DataInputStream in, DataOutputStream out) throws IOException {
        long cnID = in.readLong();
        IConnectionHelper cn = this.getConnection(cnID);
        if (cn == null) {
            this.connectionNotFound(out, cnID);
            return;
        }
        this.enterConnection(cn);
        byte[] data = null;
        try {
            data = this.recvConnection(cn);
        }
        catch (Exception e) {
            this.removeConnection(cnID);
            this.doError(out, e);
            return;
        }
        try {
            out.writeByte(1);
            if (data == null) {
                out.writeInt(-1);
            } else {
                out.writeInt(data.length);
                if (data.length > 0) {
                    out.write(data);
                }
            }
            out.flush();
            this.leaveConnection(cn);
        }
        catch (IOException ioe) {
            this.removeConnection(cnID);
            ioe.printStackTrace();
            throw ioe;
        }
    }

    private void doSend(DataInputStream in, DataOutputStream out) throws IOException {
        long cnID = in.readLong();
        IConnectionHelper cn = this.getConnection(cnID);
        if (cn == null) {
            this.connectionNotFound(out, cnID);
            return;
        }
        this.enterConnection(cn);
        int length = in.readInt();
        byte[] data = null;
        data = length >= 0 ? new byte[length] : new byte[]{};
        if (length > 0) {
            in.readFully(data);
        }
        try {
            cn.sendBlock(data, 0, data.length);
        }
        catch (Exception e) {
            this.removeConnection(cnID);
            this.doError(out, e);
            return;
        }
        try {
            out.writeByte(1);
            out.flush();
            this.leaveConnection(cn);
        }
        catch (IOException ioe) {
            this.removeConnection(cnID);
            ioe.printStackTrace();
            throw ioe;
        }
    }

    private void doClose(DataInputStream in, DataOutputStream out) throws IOException {
        long cnID = in.readLong();
        this.removeConnection(cnID);
        out.writeByte(1);
        out.flush();
    }

    private void doError(DataOutputStream out, Exception e) throws IOException {
        this.doError(out, e.getClass().getName() + ": " + e.getMessage());
    }

    private void doError(DataOutputStream out, String err) throws IOException {
        out.writeByte(0);
        EasyTool.writeLine((OutputStream)out, (String)err);
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(DataInputStream in, DataOutputStream out) throws IOException {
        byte command = in.readByte();
        switch (command) {
            case 1: {
                this.doConnect(in, out);
                break;
            }
            case 2: {
                this.doSend(in, out);
                break;
            }
            case 3: {
                this.doRecv(in, out);
                break;
            }
            case 4: {
                this.doClose(in, out);
                break;
            }
            default: {
                this.doError(out, "bad request command=" + command);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addConnection(IConnectionHelper cn) {
        Long key = this.connSeq.next();
        Hashtable hashtable = this.connections;
        synchronized (hashtable) {
            this.connections.put(key, cn);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IConnectionHelper getConnection(long cnID) {
        Hashtable hashtable = this.connections;
        synchronized (hashtable) {
            Long key = cnID;
            return (IConnectionHelper)this.connections.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnection(long cnID) {
        IConnectionHelper cn = null;
        Hashtable hashtable = this.connections;
        synchronized (hashtable) {
            Long key = cnID;
            cn = (IConnectionHelper)this.connections.remove(key);
        }
        if (cn != null) {
            cn.close();
        }
    }

    private IConnectionHelper createConnection(String url, Properties props) throws Exception {
        return ORMEngine.connectionManager.directConnect(url, props);
    }

    private byte[] recvConnection(IConnectionHelper cn) throws IOException {
        Receiver r = (Receiver)cn.get(CONNECTION_RECV);
        return r.recv();
    }

    private synchronized void enterConnection(IConnectionHelper cn) {
        Integer refs = (Integer)cn.get(CONNECTION_REFS);
        refs = refs == null ? Integer.valueOf(1) : Integer.valueOf(refs + 1);
        cn.put(CONNECTION_REFS, refs);
        this.setConnectionTimeout(cn, 0L);
    }

    private synchronized void leaveConnection(IConnectionHelper cn) {
        Integer refs = (Integer)cn.get(CONNECTION_REFS);
        if (refs != null) {
            refs = refs - 1;
            cn.put(CONNECTION_REFS, refs);
            if (refs == 0) {
                this.setConnectionTimeout(cn, System.currentTimeMillis());
            }
        }
    }

    private void setConnectionTimeout(IConnectionHelper cn, long tm) {
        cn.put(CONNECTION_TIMEOUT, tm);
    }

    private long getConnectionTimeout(IConnectionHelper cn) {
        Long v = (Long)cn.get(CONNECTION_TIMEOUT);
        if (v == null) {
            return 0L;
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() {
        boolean cont = true;
        while (cont) {
            cont = false;
            IConnectionHelper cn = null;
            Hashtable hashtable = this.connections;
            synchronized (hashtable) {
                Enumeration e = this.connections.keys();
                while (e.hasMoreElements()) {
                    Long cnKey = (Long)e.nextElement();
                    cn = (IConnectionHelper)this.connections.get(cnKey);
                    long timeout = this.getConnectionTimeout(cn);
                    if (timeout != 0L && System.currentTimeMillis() - timeout > 30000L) {
                        this.connections.remove(cnKey);
                        cn.close();
                        cont = true;
                        break;
                    }
                    cn = null;
                }
            }
            if (!cont || cn == null) continue;
            cn.close();
        }
    }

    private class Receiver
    extends Thread {
        IConnectionHelper cn;
        Vector recs = new Vector();
        IOException ioe = null;

        Receiver(IConnectionHelper _cn) {
            this.cn = _cn;
        }

        synchronized byte[] recv() throws IOException {
            if (this.recs.size() == 0) {
                try {
                    this.wait(RECV_TIMEOUT);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.recs.size() > 0) {
                return (byte[])this.recs.remove(0);
            }
            if (this.ioe != null) {
                this.ioe.printStackTrace();
                throw this.ioe;
            }
            return new byte[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    byte[] data = this.cn.recvBlock();
                    Receiver receiver = this;
                    synchronized (receiver) {
                        this.recs.addElement(data);
                        this.notify();
                    }
                }
            }
            catch (IOException e) {
                this.ioe = e;
                return;
            }
        }
    }
}

