/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.impl.server;

import com.kingdee.bos.orm.io.IConnectionHelper;
import com.kingdee.bos.orm.io.IConnectionServiceManager;
import com.kingdee.bos.orm.template.ObjectContext;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;

public class InternalServer {
    public final IConnectionServiceManager serviceManager;

    public InternalServer(IConnectionServiceManager _serviceManager) {
        this.serviceManager = _serviceManager;
    }

    public IConnectionHelper createConnection() throws IOException {
        _Connection cn1 = new _Connection();
        _Connection cn2 = new _Connection(cn1);
        this.serviceManager.receiveConnection("internal", cn1);
        return cn2;
    }

    class _Connection
    extends ObjectContext
    implements IConnectionHelper {
        boolean closed = false;
        private final ArrayList data = new ArrayList();
        _Connection cn2;

        _Connection() {
            super.registerInterface(IConnectionHelper.class, this);
        }

        _Connection(_Connection _cn2) {
            this();
            this.cn2 = _cn2;
            this.cn2.cn2 = this;
        }

        synchronized boolean isClosed() {
            return this.closed;
        }

        void checkClosed() throws IOException {
            if (this.isClosed()) {
                throw new IOException("Connection closed.");
            }
        }

        void checkPeerClosed() throws IOException {
            if (this.cn2.isClosed()) {
                throw new IOException("Connection reset by peer.");
            }
        }

        synchronized void putData(byte[] b) throws IOException {
            this.checkClosed();
            this.data.add(b);
            this.notify();
        }

        @Override
        public void sendBlock(byte[] data, int off, int len) throws IOException {
            byte[] b = new byte[len];
            System.arraycopy(data, off, b, 0, len);
            this.checkClosed();
            this.checkPeerClosed();
            this.cn2.putData(b);
        }

        @Override
        public synchronized byte[] recvBlock() throws IOException {
            try {
                do {
                    this.checkClosed();
                    if (this.data.size() != 0) continue;
                    this.wait();
                } while (this.data.size() <= 0);
                return (byte[])this.data.remove(0);
            }
            catch (InterruptedException e) {
                throw new EOFException(e.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            _Connection _Connection2 = this;
            synchronized (_Connection2) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                this.notify();
            }
            this.cn2.close();
        }
    }
}

