/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.impl.server;

import com.kingdee.bos.orm.core.ORMEngine;
import com.kingdee.bos.orm.impl.io.StreamConnectionHelper;
import com.kingdee.bos.orm.io.IConnectionServiceManager;
import com.kingdee.bos.orm.server.IServer;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.bos.util.EasyTool;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;

public class TCPServer
extends ORMObject
implements IServer {
    private static final Logger logger = Logger.getLogger(TCPServer.class);
    public static final int DEFAULT_PORT = 11034;
    private final ServerSocket serverSocket;
    private final IConnectionServiceManager serviceManager;
    final ServerThread serverThread = new ServerThread();

    public TCPServer(int bindport, int backlog, InetAddress bindAddr, IConnectionServiceManager _serviceManager) throws IOException {
        super(null);
        super.registerInterface(IServer.class, this);
        this.serviceManager = _serviceManager == null ? ORMEngine.connectionServiceManager : _serviceManager;
        this.serverSocket = bindAddr == null ? (backlog == 0 ? new ServerSocket(bindport) : new ServerSocket(bindport, backlog)) : new ServerSocket(bindport, backlog, bindAddr);
    }

    public TCPServer(int bindport) throws IOException {
        this(bindport, 0, null, null);
    }

    public TCPServer(int bindport, IConnectionServiceManager _serviceManager) throws IOException {
        this(bindport, 0, null, _serviceManager);
    }

    @Override
    public void start() {
        this.serverThread.start();
    }

    @Override
    public boolean isAlive() {
        return this.serverThread.isAlive();
    }

    private static void closeAny(Object x) {
        try {
            x.getClass().getMethod("close", new Class[0]).invoke(x, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void shutdown() {
        TCPServer.closeAny(this.serverSocket);
    }

    public static void main(String[] args) {
        try {
            int port = 11034;
            if (args.length > 0) {
                port = Integer.parseInt(args[0]);
            }
            new TCPServer(port).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class ServerThread
    extends Thread {
        ServerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: while (true) {
                try {
                    try {
                        while (true) {
                            Socket sock = TCPServer.this.serverSocket.accept();
                            try {
                                sock.setTcpNoDelay(true);
                                String url = "tcp://" + sock.getInetAddress().getHostAddress() + ":" + sock.getPort();
                                TCPServer.this.serviceManager.receiveConnection(url, new StreamConnectionHelper(sock));
                                continue block6;
                            }
                            catch (Exception e) {
                                EasyTool.closeAny((Object)sock);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable _) {
                        logger.error((Object)"TCPServer shutdown.", _);
                        TCPServer.closeAny(TCPServer.this.serverSocket);
                        break;
                    }
                }
                catch (Throwable throwable) {
                    TCPServer.closeAny(TCPServer.this.serverSocket);
                    throw throwable;
                }
            }
        }
    }
}

