/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.impl.service;

import com.kingdee.bos.orm.IEventContainer;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.orm.core.ORMEngine;
import com.kingdee.bos.orm.impl.service.SessionClosedException;
import com.kingdee.bos.orm.io.DataBlock;
import com.kingdee.bos.orm.io.IConnection;
import com.kingdee.bos.orm.service.IService;
import com.kingdee.bos.orm.service.IServiceManager;
import com.kingdee.bos.orm.service.IServiceSession;
import com.kingdee.bos.orm.service.IServiceSessionEvent;
import com.kingdee.bos.orm.template.ObjectContext;
import com.kingdee.bos.orm.util.EventManager;
import com.kingdee.bos.util.Counter;
import com.kingdee.bos.util.EasyTool;
import com.kingdee.bos.util.GC;
import com.kingdee.bos.util.GCMonitor;
import com.kingdee.bos.util.ResultQueue;
import com.kingdee.bos.util.UniqueID;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class SessionServer
implements Runnable,
GC {
    public static boolean connectionThreadInPool = false;
    IConnection cn;
    IServiceManager serviceManager;
    static final String SESSIONSERVER = "_SessionServer";
    boolean isServer;
    static UniqueID sessionSeq = new UniqueID();
    private volatile boolean closed = false;
    private static final int REQUEST = 1;
    private static final int RESPONSE = 2;
    Hashtable sessions = new Hashtable();
    static Counter counter = new Counter("RMI Invoke");
    private static int maxServiceCount = 50;
    private static int serviceCount = 0;
    private static Object serviceMonitor = new Object();
    static UniqueID invokeSeq = new UniqueID();
    long gcStartTime = System.currentTimeMillis();

    public static void startConnectionService(IConnection cn, boolean server) throws IOException {
        SessionServer.startConnectionService(cn, ORMEngine.serviceManager, server);
    }

    public static void startConnectionService(IConnection cn, IServiceManager serviceManager, boolean server) throws IOException {
        if (SessionServer.getSessionServer(cn) == null) {
            if (connectionThreadInPool) {
                ORMEngine.startThread(new SessionServer(cn, serviceManager, server));
            } else {
                new SessionServer(cn, serviceManager, server).startService();
            }
        }
    }

    private static SessionServer getSessionServer(IConnection cn) {
        return (SessionServer)cn.get(SESSIONSERVER);
    }

    public static IServiceSession createSession(IConnection cn, String method) throws Exception {
        return SessionServer.getSessionServer(cn).createSession(method);
    }

    SessionServer(IConnection _cn, IServiceManager _serviceManager, boolean server) {
        this.cn = _cn;
        this.serviceManager = _serviceManager;
        this.cn.put(SESSIONSERVER, this);
        this.isServer = server;
        if (!this.isServer) {
            GCMonitor.add((GC)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IServiceSession createSession(String method) {
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            long sessionID = sessionSeq.next();
            Session session = new Session(method, sessionID, true);
            this.sessions.put(sessionID, session);
            this.gcStartTime = 0L;
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            if (!this.isServer) {
                GCMonitor.remove((GC)this);
            }
            this.cn.close();
            Hashtable hashtable = this.sessions;
            synchronized (hashtable) {
                Enumeration e = this.sessions.elements();
                while (e.hasMoreElements()) {
                    Session session = (Session)e.nextElement();
                    EasyTool.closeAny((Object)session);
                }
                this.sessions.clear();
            }
        }
    }

    void sendBlock(String method, int type, long sessionID, long id, byte[] data) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(out);
        EasyTool.writeLine((OutputStream)dout, (String)method);
        dout.writeByte(type);
        dout.writeLong(sessionID);
        dout.writeLong(id);
        dout.writeInt(data.length);
        if (data.length > 0) {
            dout.write(data);
        }
        dout.flush();
        this.cn.sendBlock(new DataBlock(out.toByteArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMaxServiceCount(int count) {
        Object object = serviceMonitor;
        synchronized (object) {
            maxServiceCount = count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMaxServiceCount() {
        Object object = serviceMonitor;
        synchronized (object) {
            return maxServiceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enterService() throws InterruptedException {
        Object object = serviceMonitor;
        synchronized (object) {
            while (serviceCount >= maxServiceCount) {
                serviceMonitor.wait();
            }
            ++serviceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void leaveService() {
        Object object = serviceMonitor;
        synchronized (object) {
            --serviceCount;
            serviceMonitor.notify();
        }
    }

    private void startService() {
        Thread t = new Thread((Runnable)this, "ORMRPC-SessionServer");
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        if (connectionThreadInPool) {
            try {
                DataBlock block = null;
                while ((block = this.cn.recvBlock()) == null || block.getLength() <= 0) {
                }
                SessionServer.enterService();
                ORMEngine.startThread(this);
                DataInputStream in = new DataInputStream(block.getInputStream());
                String method = EasyTool.readLine((InputStream)in);
                byte type = in.readByte();
                long sessionID = in.readLong();
                Long sessionKey = sessionID;
                long invokeID = in.readLong();
                int length = in.readInt();
                byte[] data = new byte[length];
                if (length > 0) {
                    in.readFully(data);
                }
                IService service = this.serviceManager.accept(method);
                Session session = null;
                Hashtable hashtable = this.sessions;
                synchronized (hashtable) {
                    session = (Session)this.sessions.get(sessionKey);
                }
                if (type == 1) {
                    if (invokeID == -1L) {
                        if (session != null) {
                            session.close();
                        }
                        this.sendBlock(method, 2, sessionID, -1L, new byte[0]);
                        return;
                    }
                    hashtable = this.sessions;
                    synchronized (hashtable) {
                        if (session == null) {
                            session = new Session(method, sessionID, false);
                            this.sessions.put(sessionKey, session);
                            this.gcStartTime = 0L;
                        }
                    }
                    byte[] responseData = service.service(session, method, data);
                    this.sendBlock(method, 2, sessionID, invokeID, responseData);
                    if (!ORMEngine.debug) return;
                    counter.add();
                    return;
                }
                if (type == 2) {
                    if (session == null) {
                        return;
                    }
                    session.notifyResult(invokeID, data);
                    return;
                }
                System.out.println("Unknown Data Block: method=" + method + ", type=" + type);
                return;
            }
            catch (Exception e) {
                if (!(e instanceof IOException)) {
                    e.printStackTrace();
                }
                this.close();
                return;
            }
            finally {
                SessionServer.leaveService();
            }
        }
        try {
            while (true) {
                DataBlock block = null;
                while ((block = this.cn.recvBlock()) == null || block.getLength() <= 0) {
                }
                SessionServer.enterService();
                ORMEngine.startThread(new ServiceThread(block));
            }
        }
        catch (Throwable e) {
            if (!(e instanceof IOException)) {
                e.printStackTrace();
            }
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() {
        long t;
        long t0;
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            if (this.sessions.size() > 0) {
                this.gcStartTime = 0L;
            } else if (this.gcStartTime == 0L) {
                this.gcStartTime = System.currentTimeMillis();
            }
            t0 = this.gcStartTime;
        }
        if (t0 != 0L && (t = System.currentTimeMillis() - this.gcStartTime) >= 30000L) {
            System.out.println("Connection idle timeout,auto close connection.");
            this.close();
        }
    }

    public class Session
    extends ObjectContext
    implements IServiceSession {
        EventManager eventManager = new EventManager(this);
        long sessionID;
        ResultQueue results = new ResultQueue();
        String method;
        boolean client;
        volatile boolean closed = false;

        public Session(String _method, long _sessionID, boolean _client) {
            super.registerInterface(IServiceSession.class, this);
            super.registerInterface(IEventContainer.class, this.eventManager);
            this.method = _method;
            this.sessionID = _sessionID;
            this.client = _client;
        }

        @Override
        public IConnection getConnection() {
            return SessionServer.this.cn;
        }

        @Override
        public long getSessionID() {
            return this.sessionID;
        }

        public boolean isClosed() {
            return this.closed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            this.closed = true;
            IServiceSessionEvent[] ls = (IServiceSessionEvent[])this.eventManager.getEventListeners(IServiceSessionEvent.class);
            for (int i = 0; i < ls.length; ++i) {
                ls[i].sessionClosed(this);
            }
            if (this.client) {
                try {
                    SessionServer.this.sendBlock(this.method, 1, this.sessionID, -1L, new byte[0]);
                    this.results.waitFor((Object)-1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            super.close();
            this.results.close();
            Hashtable hashtable = SessionServer.this.sessions;
            synchronized (hashtable) {
                SessionServer.this.sessions.remove(this.sessionID);
                if (SessionServer.this.sessions.size() == 0) {
                    SessionServer.this.gcStartTime = System.currentTimeMillis();
                }
            }
        }

        @Override
        public byte[] invoke(String _method, byte[] requestData) throws ORMCoreException {
            if (this.closed) {
                throw new SessionClosedException("Session#" + this.sessionID + " has been closed.");
            }
            long id = invokeSeq.next();
            if (_method == null) {
                _method = this.method;
            }
            try {
                SessionServer.this.sendBlock(_method, 1, this.sessionID, id, requestData);
                return (byte[])this.results.waitFor((Object)id);
            }
            catch (Exception e) {
                throw ORMCoreException.create(e);
            }
        }

        void notifyResult(long id, byte[] result) {
            this.results.notifyResult((Object)id, (Object)result);
        }
    }

    private class ServiceThread
    implements Runnable {
        DataBlock block;

        ServiceThread(DataBlock _block) {
            this.block = _block;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block21: {
                try {
                    DataInputStream in = new DataInputStream(this.block.getInputStream());
                    String method = EasyTool.readLine((InputStream)in);
                    byte type = in.readByte();
                    long sessionID = in.readLong();
                    Long sessionKey = sessionID;
                    long invokeID = in.readLong();
                    int length = in.readInt();
                    byte[] data = new byte[length];
                    if (length > 0) {
                        in.readFully(data);
                    }
                    IService service = SessionServer.this.serviceManager.accept(method);
                    Session session = null;
                    Hashtable hashtable = SessionServer.this.sessions;
                    synchronized (hashtable) {
                        session = (Session)SessionServer.this.sessions.get(sessionKey);
                    }
                    if (type == 1) {
                        if (invokeID == -1L) {
                            if (session != null) {
                                session.close();
                            }
                            SessionServer.this.sendBlock(method, 2, sessionID, -1L, new byte[0]);
                            break block21;
                        }
                        hashtable = SessionServer.this.sessions;
                        synchronized (hashtable) {
                            if (session == null) {
                                session = new Session(method, sessionID, false);
                                SessionServer.this.sessions.put(sessionKey, session);
                                SessionServer.this.gcStartTime = 0L;
                            }
                        }
                        byte[] responseData = service.service(session, method, data);
                        SessionServer.this.sendBlock(method, 2, sessionID, invokeID, responseData);
                        if (ORMEngine.debug) {
                            counter.add();
                        }
                        break block21;
                    }
                    if (type == 2) {
                        if (session == null) {
                        } else {
                            session.notifyResult(invokeID, data);
                        }
                    } else {
                        System.out.println("Unknown Data Block: method=" + method + ", type=" + type);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    SessionServer.this.close();
                }
                finally {
                    SessionServer.leaveService();
                }
            }
        }
    }
}

