/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.util;

import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.orm.util.DynamicClassLoader;
import com.kingdee.bos.orm.util.EventFireObject;
import com.kingdee.bos.orm.util.EventManager;
import com.kingdee.bos.orm.util.EventManagerGenerator2;
import com.kingdee.bos.orm.util.JavaGenerator;
import com.kingdee.bos.util.ObjectCreator;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Method;

public class EventManagerGenerator {
    static ObjectCreator fireModels = new ObjectCreator();

    public static Class getEventFireModelClass(Class eventModel) throws Exception {
        Class cls = (Class)fireModels.queryLockObject((Object)eventModel);
        if (cls != null) {
            return cls;
        }
        try {
            cls = EventManagerGenerator2.createEventFireModel(eventModel);
            fireModels.finishCreate((Object)eventModel, (Object)cls);
        }
        catch (Exception e) {
            fireModels.cancelCreate((Object)eventModel);
            e.printStackTrace();
            throw e;
        }
        return cls;
    }

    static Class genFireModel(Class eventModel) throws Exception {
        String packageName;
        Class cls = null;
        String className = "Fire_" + eventModel.getName().replace('.', '_');
        File classFile = JavaGenerator.getClassFile(JavaGenerator.DEFAULT_CLASS_ROOT, className, packageName = "orm.event");
        if (classFile.exists()) {
            cls = new DynamicClassLoader(eventModel.getClassLoader()).loadClassFromFile(packageName + "." + className, classFile, eventModel);
        }
        if (cls == null) {
            JavaGenerator gen = new JavaGenerator(packageName, className, "EventFireObject");
            gen.registerImport(EventFireObject.class);
            gen.registerImport(EventManager.class);
            gen.addImplements(eventModel);
            gen.out.println("public " + className + "(EventManager _manager)");
            gen.out.println("{");
            gen.out.println("\tsuper(_manager);");
            gen.out.println("}");
            Method[] mds = eventModel.getMethods();
            for (int i = 0; i < mds.length; ++i) {
                if (mds[i].equals(JavaGenerator.queryInterfaceMethod)) continue;
                EventManagerGenerator.genFireMethod(gen, mds[i], eventModel);
            }
            gen.genModelDigest(eventModel);
            gen.compile();
            cls = new DynamicClassLoader(eventModel.getClassLoader()).loadClassFromFile(packageName + "." + className, classFile);
        }
        return cls;
    }

    static void genFireMethod(JavaGenerator gen, Method md, Class eventModel) throws Exception {
        PrintWriter out = gen.out;
        gen.genMethodDeclare(md);
        out.println();
        String modelName = gen.getTypeName(eventModel);
        Class<?>[] args = md.getParameterTypes();
        out.println("{");
        Class<?> rtype = md.getReturnType();
        boolean returned = false;
        if (!rtype.equals(Void.TYPE)) {
            returned = true;
            out.println("\t" + gen.getTypeName(rtype) + " r=" + JavaGenerator.getDefaultValue(rtype) + ";");
        }
        out.println("\t" + modelName + "[] listeners = (" + modelName + "[])manager.getEventListeners(" + modelName + ".class);");
        out.println("\tfor (int i=0;i<listeners.length;i++)");
        out.println("\t{");
        out.print("\t\t");
        if (returned) {
            out.print("r=");
        }
        out.print("listeners[i]." + md.getName() + "(");
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                out.print(", ");
            }
            out.print("p" + i);
        }
        out.println(");");
        out.println("\t}");
        if (returned) {
            out.println("\treturn r;");
        }
        out.println("}");
    }

    public static IORMModel createEventFireModel(EventManager manager, Class eventModel) throws ORMCoreException {
        try {
            Class cls = EventManagerGenerator.getEventFireModelClass(eventModel);
            Class[] types = new Class[1];
            Object[] args = new Object[1];
            types[0] = EventManager.class;
            args[0] = manager;
            return (IORMModel)cls.getConstructor(types).newInstance(args);
        }
        catch (Exception e) {
            throw ORMCoreException.create(e);
        }
    }
}

