/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.util;

import com.kingdee.bos.orm.IORMModel;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;

public class ModelGenerator {
    public static void generateModelOverlay(Class model, OutputStream out) throws Exception {
        ModelGenerator.generateModelOverlay(model, new PrintWriter(out));
    }

    public static void generateModelOverlay(Class model, PrintWriter out) throws Exception {
        Class<IORMModel> ormModel = IORMModel.class;
        Method mqi = ormModel.getMethods()[0];
        Method[] mds = model.getMethods();
        String typeName = ModelGenerator.getTypeName(model);
        out.println("class _" + typeName + " implements " + typeName);
        out.println("{");
        out.println("\t" + typeName + " impl;");
        out.println("\t_" + typeName + "(" + typeName + " _impl)");
        out.println("\t{");
        out.println("\t\timpl = _impl;");
        out.println("\t}");
        for (int i = 0; i < mds.length; ++i) {
            int j;
            Method md = mds[i];
            Class<?> rtype = md.getReturnType();
            String implName = "impl";
            if (md.equals(mqi)) {
                implName = "_this";
            }
            out.print("\tpublic " + ModelGenerator.getTypeName(rtype) + " " + md.getName() + "(");
            Class<?>[] args = md.getParameterTypes();
            for (int j2 = 0; j2 < args.length; ++j2) {
                if (j2 > 0) {
                    out.print(", ");
                }
                out.print(ModelGenerator.getTypeName(args[j2]) + " p" + (j2 + 1));
            }
            out.print(")");
            Class<?>[] exs = md.getExceptionTypes();
            for (j = 0; j < exs.length; ++j) {
                if (j == 0) {
                    out.print("throws ");
                } else {
                    out.print(", ");
                }
                out.print(ModelGenerator.getTypeName(exs[j]));
            }
            out.println();
            out.println("\t{");
            out.print("\t\t");
            if (!rtype.equals(Void.TYPE)) {
                out.print("return ");
            }
            out.print(implName + "." + md.getName() + "(");
            for (j = 0; j < args.length; ++j) {
                if (j > 0) {
                    out.print(", ");
                }
                out.print("p" + (j + 1));
            }
            out.println(");");
            out.println("\t}");
        }
        out.println("}");
        out.flush();
    }

    private static String getTypeName(Class type) {
        if (type.isArray()) {
            return ModelGenerator.getTypeName(type.getComponentType()) + "[]";
        }
        String name = type.getName();
        int i = name.lastIndexOf(46);
        if (i >= 0) {
            name = name.substring(i + 1);
        }
        return name;
    }
}

