/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.util;

import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.orm.util.DynamicClassLoader;
import com.kingdee.bos.orm.util.JavaGenerator;
import com.kingdee.bos.orm.util.ORMModelSupport;
import com.kingdee.bos.util.ObjectCreator;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Method;

public class ModelSupportGenerator {
    static ObjectCreator supports = new ObjectCreator();

    public static IORMModel createSupportObject(IORMModel owner, Class type, IORMModel impl) throws ORMCoreException {
        try {
            Class cls = ModelSupportGenerator.createSupportObjectClass(type);
            Class[] types = new Class[]{IORMModel.class, type};
            Object[] args = new Object[]{owner, impl.queryInterface(type)};
            return (IORMModel)cls.getConstructor(types).newInstance(args);
        }
        catch (Exception e) {
            throw ORMCoreException.create(e);
        }
    }

    public static Class createSupportObjectClass(Class type) throws Exception {
        Class cls = (Class)supports.queryLockObject((Object)type);
        if (cls != null) {
            return cls;
        }
        try {
            String className = "ModelSupport_" + type.getName().replace('.', '_');
            String packageName = "orm.modelsupport";
            File classFile = JavaGenerator.getClassFile(JavaGenerator.DEFAULT_CLASS_ROOT, className, packageName);
            if (classFile.exists()) {
                cls = new DynamicClassLoader(type.getClassLoader()).loadClassFromFile(packageName + "." + className, classFile, type);
            }
            if (cls == null) {
                JavaGenerator gen = new JavaGenerator(packageName, className, "ORMModelSupport");
                String typeName = gen.getTypeName(type);
                gen.registerImport(ORMModelSupport.class);
                gen.registerImport(IORMModel.class);
                gen.addImplements(type);
                gen.out.println("public final " + typeName + " impl;");
                gen.out.println("public " + className + "(IORMModel _owner," + typeName + " _impl)");
                gen.out.println("{");
                gen.out.println("\tsuper(_owner);");
                gen.out.println("\timpl = _impl;");
                gen.out.println("}");
                Method[] mds = type.getMethods();
                for (int i = 0; i < mds.length; ++i) {
                    if (mds[i].equals(JavaGenerator.queryInterfaceMethod)) continue;
                    ModelSupportGenerator.genSupportMethod(gen, mds[i], type);
                }
                gen.genModelDigest(type);
                gen.compile();
                cls = new DynamicClassLoader(type.getClassLoader()).loadClassFromFile(packageName + "." + className, classFile);
                supports.finishCreate((Object)type, (Object)cls);
            }
        }
        catch (Exception e) {
            supports.cancelCreate((Object)type);
            throw e;
        }
        return cls;
    }

    static void genSupportMethod(JavaGenerator gen, Method md, Class type) throws Exception {
        PrintWriter out = gen.out;
        gen.genMethodDeclare(md);
        out.println();
        out.println("{");
        out.print("\t");
        if (!md.getReturnType().equals(Void.TYPE)) {
            out.print("return ");
        }
        out.print("impl." + md.getName() + "(");
        for (int i = 0; i < md.getParameterTypes().length; ++i) {
            if (i > 0) {
                out.print(", ");
            }
            out.print("p" + i);
        }
        out.println(");");
        out.println("}");
    }
}

