/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc;

import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.rpc.ObjectFactory;
import com.kingdee.bos.rpc.RPCConfig;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.RPCProxySpec;
import com.kingdee.bos.rpc.RPCServerSession;
import com.kingdee.bos.rpc.RPCSession;
import com.kingdee.bos.rpc.ce.RPCConnectException;
import com.kingdee.bos.rpc.impl.ObjectProxy;
import com.kingdee.bos.rpc.impl.ObjectStub;
import com.kingdee.bos.rpc.impl.RPCSessionImpl;
import com.kingdee.bos.rpc.impl.SimplePool;
import com.kingdee.bos.rpc.impl.ThreadPool;
import com.kingdee.bos.rpc.impl.ThreadPool3;
import com.kingdee.bos.rpc.impl.UniqueID;
import com.kingdee.bos.rpc.io.Connector;
import com.kingdee.bos.rpc.io.driver.HttpConnectionDriver;
import com.kingdee.bos.rpc.io.driver.HttpsConnectionDriver;
import com.kingdee.bos.rpc.io.driver.InternalConnectionDriver;
import com.kingdee.bos.rpc.io.driver.PooledTCPConnectionDriver;
import com.kingdee.bos.rpc.io.driver.SSLTCPDriver;
import com.kingdee.bos.rpc.io.driver.ServerConnectionDriver;
import com.kingdee.bos.rpc.io.driver.TCPConnectionDriver;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.util.profile.ObjectProfileInterceptor;
import com.kingdee.util.profile.ProfileConfig;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Properties;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;

public class RPCEngine {
    private static final Logger logger = Logger.getLogger(RPCEngine.class);
    public static final String identity = UniqueID.next();
    private static long seqId;
    private static final Object seqMonitor;
    public static final String THREADPOOL_CLASS = "com.kingdee.bos.rpc.threadPool";
    public static final String THREADPOOL1 = "com.kingdee.bos.rpc.impl.ThreadPool1";
    public static final String THREADPOOL2 = "com.kingdee.bos.rpc.impl.ThreadPool2";
    private static ThreadPool threadPool;
    private static final ArrayList objectFactories;
    private static ObjectFactory[] facts;
    private static final WeakHashMap classLoaders;
    private static final Object classLoaderMonitor;
    public static final ClassLoader rpcClassLoader;
    public static final RPCProxySpec proxySpec;
    private static final SimplePool connectorPool;
    private static final SimplePool sessionPool;

    public static RPCSession getObjectSession(Object x) {
        return ((ObjectStub)x).ctx.session;
    }

    public static void releaseObjectStub(Object x) {
        ObjectStub stub = (ObjectStub)x;
        RPCSessionImpl.releaseObject(stub);
    }

    public static long getObjectReference(Object x) {
        return ((ObjectStub)x).ctx.ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long nextSequenceId() {
        Object object = seqMonitor;
        synchronized (object) {
            return seqId++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void synConfig2ThreadPool(RPCConfig config) {
        ThreadPool threadPool = RPCEngine.threadPool;
        synchronized (threadPool) {
            RPCEngine.threadPool.setParameters(config.threadPoolMinSize, config.threadPoolMaxSize, config.threadPoolIdleTimeout);
        }
    }

    public static void startThread(Runnable runner) {
        threadPool.startThread(runner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerObjectFactory(ObjectFactory fact) {
        ArrayList arrayList = objectFactories;
        synchronized (arrayList) {
            objectFactories.add(fact);
            facts = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterObjectFactory(ObjectFactory fact) {
        ArrayList arrayList = objectFactories;
        synchronized (arrayList) {
            objectFactories.remove(fact);
            facts = null;
        }
    }

    public static Object createObject(String name, Class model) throws Exception {
        return RPCEngine.createObject(name, model, null, null);
    }

    public static Object createObject(String name, Class model, Class[] argTypes, Object[] args) throws Exception {
        if (argTypes == null) {
            argTypes = new Class[]{};
        }
        if (args == null) {
            args = new Object[]{};
        }
        if (facts == null) {
            facts = objectFactories.toArray(new ObjectFactory[objectFactories.size()]);
        }
        ObjectFactory[] fs = facts;
        Object obj = null;
        for (int i = fs.length - 1; i >= 0 && (obj = fs[i].createObject(name, model, argTypes, args)) == null; --i) {
        }
        if (obj == null) {
            obj = RPCEngine.loadClass(name).getConstructor(argTypes).newInstance(args);
        }
        if (!model.isInstance(obj)) {
            throw new ClassCastException(model.toString());
        }
        if (ProfileConfig.getInstance().logRemoteObject) {
            return (IORMModel)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{model}, (InvocationHandler)new ObjectProfileInterceptor(obj));
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClassLoader(ClassLoader classLoader) {
        Object object = classLoaderMonitor;
        synchronized (object) {
            classLoaders.put(classLoader, classLoaderMonitor);
        }
    }

    public static Class loadClass(String name) throws ClassNotFoundException {
        return rpcClassLoader.loadClass(name);
    }

    public static Object getObjectModel(Object obj, Class model) {
        if (model == null) {
            return obj;
        }
        if (obj == null) {
            return null;
        }
        if (model.isInterface() && obj instanceof ObjectStub) {
            return RPCSessionImpl.getObjectModel((ObjectStub)obj, model);
        }
        if (!model.isInstance(obj)) {
            throw new ClassCastException(obj.getClass().getName() + " can't convert to " + model.getName());
        }
        return obj;
    }

    public static RPCServerSession getCurrentServerSession() {
        return RPCServerSession.getCurrentSession();
    }

    public static ObjectProxy getCurrentProxyReference() {
        return ObjectProxy.getCurrentProxy();
    }

    public static RPCSession createSession(String url, Properties props) {
        return RPCEngine.createSession(url, props, true);
    }

    public static RPCSession createSession(String url, Properties props, boolean stateable) {
        return RPCEngine.createSession(new Connector(url, props), stateable);
    }

    public static RPCSession createSession(Connector cn) {
        return RPCEngine.createSession(cn, true);
    }

    public static RPCSession createSession(Connector cn, boolean stateable) {
        try {
            return cn.createSession(stateable);
        }
        catch (Throwable e) {
            throw RPCException.createIt(e);
        }
    }

    public static RPCSession createSession(String url) {
        return RPCEngine.createSession(url, true);
    }

    public static RPCSession createSession(String url, boolean stateable) {
        try {
            return RPCEngine.createSession(new _Connector(url), stateable);
        }
        catch (Throwable e) {
            throw RPCException.createIt(e);
        }
    }

    public static Connector getDefaultConnector(String url) throws Exception {
        return (Connector)connectorPool.get(url);
    }

    public static RPCSession getDefaultSession(String url) {
        try {
            return (RPCSession)sessionPool.get(url);
        }
        catch (Throwable e) {
            throw RPCException.createIt(e);
        }
    }

    public static RPCSession getPooledSession(String url) {
        return RPCEngine.getDefaultSession(url);
    }

    public static Object createRemoteObject(String url, String name, Class model, Class[] argTypes, Object[] args) throws Exception {
        try {
            if (argTypes == null) {
                argTypes = new Class[]{};
            }
            if (args == null) {
                args = new Object[]{};
            }
            if (facts == null) {
                facts = objectFactories.toArray(new ObjectFactory[objectFactories.size()]);
            }
            ObjectFactory[] fs = facts;
            Object obj = null;
            for (int i = fs.length - 1; i >= 0 && (obj = fs[i].createRemoteObject(url, name, model, argTypes, args)) == null; --i) {
            }
            if (obj == null) {
                obj = RPCEngine.getDefaultSession(url).createObject(name, model, argTypes, args);
            }
            return obj;
        }
        catch (RPCException rpe) {
            if (RPCException.getErrorCode(rpe) == 1002) {
                logger.debug((Object)"createRemoteObject session not found", (Throwable)rpe);
                logger.warn((Object)("default session to " + url + " is not found,recreate session and retry!"));
                RPCEngine.getDefaultSession(url).close();
                sessionPool.remove(url);
                return RPCEngine.getDefaultSession(url).createObject(name, model, argTypes, args);
            }
            if (rpe instanceof RPCConnectException) {
                logger.debug((Object)"connection error!", (Throwable)rpe);
                sessionPool.remove(url);
                connectorPool.remove(url);
                return RPCEngine.getDefaultSession(url).createObject(name, model, argTypes, args);
            }
            throw rpe;
        }
    }

    public static Object createRemoteObject(String url, String name, Class model) throws Exception {
        return RPCEngine.createRemoteObject(url, name, model, null, null);
    }

    static {
        new InternalConnectionDriver();
        new TCPConnectionDriver();
        new HttpConnectionDriver();
        new ServerConnectionDriver();
        new PooledTCPConnectionDriver();
        new SSLTCPDriver();
        try {
            new HttpsConnectionDriver().initialize();
        }
        catch (Throwable e) {
            logger.error((Object)e);
        }
        seqId = 1L;
        seqMonitor = new Object();
        String tpClsName = System.getProperty(THREADPOOL_CLASS);
        if (tpClsName != null && tpClsName.length() > 0) {
            try {
                Class<?> tpCls = Class.forName(tpClsName);
                threadPool = (ThreadPool)tpCls.getConstructor(String.class).newInstance("RPC");
            }
            catch (Throwable e) {
                logger.warn((Object)(e.getMessage() + ", use default TheadPool."));
            }
        }
        if (threadPool == null) {
            threadPool = new ThreadPool3("RPC");
        }
        RPCEngine.synConfig2ThreadPool(ServerManager.getConfig());
        objectFactories = new ArrayList(2);
        facts = null;
        classLoaders = new WeakHashMap();
        classLoaderMonitor = new Object();
        rpcClassLoader = new ClassLoader(RPCEngine.class.getClassLoader()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Class findClass(String name) throws ClassNotFoundException {
                Object[] loaders;
                Object object = classLoaderMonitor;
                synchronized (object) {
                    loaders = classLoaders.keySet().toArray();
                }
                for (int i = 0; i < loaders.length; ++i) {
                    try {
                        return ((ClassLoader)loaders[i]).loadClass(name);
                    }
                    catch (Throwable _) {
                        continue;
                    }
                }
                return super.findClass(name);
            }
        };
        proxySpec = new RPCProxySpec();
        connectorPool = new SimplePool(){

            @Override
            protected Object createValue(final Object key) {
                return new Connector((String)key){

                    @Override
                    protected void onError(Throwable e) {
                        super.onError(e);
                        if (this.serverRestarted) {
                            sessionPool.remove((String)key);
                            connectorPool.remove((String)key);
                        }
                    }
                };
            }
        };
        sessionPool = new SimplePool(){

            @Override
            protected Object createValue(Object key) throws Exception {
                return RPCEngine.createSession(new _Connector((String)key), true);
            }
        };
        logger.info((Object)("RPC Engine(id=" + identity + ") initialized."));
    }

    private static class _Connector
    extends Connector {
        _Connector(String url) {
            super(url);
        }

        @Override
        protected void onError(Throwable e) {
            super.onError(e);
            if (this.serverRestarted) {
                sessionPool.remove(this.url);
            }
        }
    }
}

