/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc;

import com.kingdee.bos.rpc.io.RPCIOException;
import com.kingdee.bos.rpc.performance.InvokeRecord;

public class RPCException
extends RuntimeException {
    public static final int DEFAULT_ERROR_CODE = 500;
    public static final int SESSION_CLOSED = 1001;
    public static final int SESSION_NOTFOUND = 1002;
    public static final int OBJECT_NOTFOUND = 1003;
    public static final int NOT_INTERFACE = 1004;
    public static final int SERVER_RESTARTED = 1005;
    public static final int DATA_SIZE_TOO_LARGE = 1006;
    public static final int UNSUPPORTED_PROTOCOL = 2001;
    public static final int UNKNOWN_COMMAND = 2002;
    public static final int STREAM_CLOSED = 2003;
    public static final int CONNECTION_CLOSED = 2004;
    public static final int NO_SUITED_DRIVER = 2005;
    public static final int NOT_RPC_SERVER = 2006;
    public static final int SERVER_NOT_FOUND = 2007;
    public static final int PEER_CLOSED = 2008;
    public static final int INTERRUPTED = 3001;
    public static final int LOADBALANCE_NO_SERVER_AVAILABLE = 4001;
    public static final int NO_AVAILABLE_SERVER_FOUND = 5001;
    private transient boolean localException = true;
    private int errorCode = 500;

    public int getErrorCode() {
        return this.errorCode;
    }

    public boolean isRemote() {
        return !this.localException;
    }

    public RPCException(int code, String message) {
        super(message);
        this.errorCode = code;
    }

    public RPCException(String message, Throwable cause) {
        super(message, cause);
        this.errorCode = RPCException.getErrorCode(cause);
    }

    public RPCException(Throwable cause) {
        super(cause);
        this.errorCode = RPCException.getErrorCode(cause);
    }

    public RPCException(int code, Throwable cause) {
        super(cause);
        this.errorCode = code;
    }

    @Override
    public String toString() {
        String s = super.toString();
        s = "(errorCode:" + this.errorCode + ") " + s;
        if (!this.localException) {
            s = "(Remote) " + s;
        }
        return s;
    }

    public static RPCException createIt(Throwable e) {
        return RPCException.createIt(e, null);
    }

    public static RPCException createIt(Throwable e, InvokeRecord rec) {
        if (rec != null) {
            rec.err = e;
        }
        if (!(e instanceof RPCException)) {
            return new RPCException(e);
        }
        RPCException e1 = (RPCException)e;
        if (e1.localException) {
            return e1;
        }
        return new RPCException(e);
    }

    public static void throwIt(Throwable e) throws RPCException {
        throw RPCException.createIt(e);
    }

    public static int getErrorCode(Throwable e) {
        if (e == null) {
            return 500;
        }
        if (e instanceof RPCException) {
            return ((RPCException)e).errorCode;
        }
        if (e instanceof RPCIOException) {
            return ((RPCIOException)e).getErrorCode();
        }
        if (e instanceof InterruptedException) {
            return 3001;
        }
        if (e.getCause() != null) {
            return RPCException.getErrorCode(e.getCause());
        }
        return 500;
    }
}

