/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc;

import com.kingdee.bos.rpc.io.loadbalance.LBManage;
import com.kingdee.util.StringUtils;
import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.HtmlAdaptorServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.rmi.registry.LocateRegistry;
import java.util.ArrayList;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.JMRuntimeException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Logger;

public class RPCManagement {
    private static final Logger logger = Logger.getLogger(RPCManagement.class);
    private static final String CONFIG_FILE_NAME = "jmxconnector.properties";
    public static final int DEFAULT_RMI_PORT = 11020;
    private static final int DEFAULT_HTTP_MAX_ACTIVE_CLIENT_COUNT = 10;
    public static final MBeanServer MBEAN_SERVER;
    public static final ObjectName mbeanObjectName;
    private static boolean registered;

    public static void registerMBean() {
        if (registered) {
            logger.info((Object)"has registered LBManage!");
            return;
        }
        Properties props = RPCManagement.loadConfig();
        int rmiPort = RPCManagement.parseConfig(props, "rmi.port", 0);
        int httpPort = RPCManagement.parseConfig(props, "http.port", 0);
        int maxActiveClientCount = RPCManagement.parseConfig(props, "http.maxActiveClientCount", 10);
        logger.info((Object)("rmi.port is " + rmiPort));
        logger.info((Object)("http.port is " + httpPort));
        if (rmiPort > 0) {
            RPCManagement.startRMIAdaptor(rmiPort);
        }
        if (httpPort > 0) {
            RPCManagement.startHtmlAdaptor(httpPort, maxActiveClientCount, props);
        }
        MBeanServer mbs = MBEAN_SERVER;
        String domain = mbs.getDefaultDomain();
        try {
            ObjectName mbeanObjectName = new ObjectName(domain + ":type=LBManage");
            mbs.createMBean(LBManage.class.getName(), mbeanObjectName);
            registered = true;
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private static Properties loadConfig() {
        Properties props = new Properties();
        try {
            String fileName = System.getProperty(CONFIG_FILE_NAME, CONFIG_FILE_NAME);
            File configFile = new File(fileName);
            if (configFile.exists()) {
                props.load(new FileInputStream(configFile));
            } else {
                logger.error((Object)("Jmx config " + fileName + " not exists!"));
            }
        }
        catch (IOException ioe) {
            logger.error((Object)ioe.getMessage(), (Throwable)ioe);
        }
        return props;
    }

    private static int parseConfig(Properties props, String key, int defaultValue) {
        String str = props.getProperty(key);
        if (StringUtils.isEmpty((String)str)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException _ex) {
            logger.info((Object)("invalid config of jmxconnector.properties#" + key + ", using defualt config value."));
            return defaultValue;
        }
    }

    public static void startRMIAdaptor(int rmiPort) throws JMRuntimeException {
        try {
            LocateRegistry.createRegistry(rmiPort);
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + rmiPort + "/bos");
            JMXConnectorServer cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, MBEAN_SERVER);
            cs.start();
            logger.info((Object)("startRMIAdaptor success at port " + rmiPort));
        }
        catch (IOException ioe) {
            logger.error((Object)ioe.getMessage(), (Throwable)ioe);
            throw new JMRuntimeException(ioe.getMessage());
        }
    }

    private static void startHtmlAdaptor(int httpPort, int maxActiveClientCount, Properties props) throws JMRuntimeException {
        try {
            MBeanServer mbs = MBEAN_SERVER;
            ObjectName objName = new ObjectName("Adaptor:type=html");
            HtmlAdaptorServer server = new HtmlAdaptorServer();
            String user = props.getProperty("user", "admin");
            String password = props.getProperty("password", "admin");
            server.addUserAuthenticationInfo(new AuthInfo(user, password));
            mbs.registerMBean(server, objName);
            mbs.setAttribute(objName, new Attribute("MaxActiveClientCount", maxActiveClientCount));
            mbs.setAttribute(objName, new Attribute("Port", httpPort));
            mbs.invoke(objName, "start", null, null);
            logger.info((Object)("startHtmlAdaptor success at port " + httpPort));
        }
        catch (Exception e) {
            if (e instanceof ReflectionException) {
                logger.error((Object)((ReflectionException)e).getTargetException());
            }
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new JMRuntimeException("CannotCreateMBean : " + e.getMessage());
        }
    }

    static {
        registered = false;
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        MBEAN_SERVER = servers != null && servers.size() > 0 ? (MBeanServer)servers.get(0) : MBeanServerFactory.createMBeanServer();
        String domain = MBEAN_SERVER.getDefaultDomain();
        ObjectName name = null;
        try {
            name = new ObjectName(domain + ":type=LBManage");
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        mbeanObjectName = name;
    }
}

