/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc;

import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.impl.ContainerBase;
import com.kingdee.bos.rpc.io.Connector;
import com.kingdee.bos.rpc.io.server.ServerManager;
import org.apache.log4j.Logger;

public abstract class RPCSession
extends ContainerBase {
    private static final Logger logger = Logger.getLogger(RPCSession.class);
    public final long sessionId;
    protected final Connector cn;
    protected boolean stateable;

    protected RPCSession(long sessionId, Connector cn, boolean stateable) {
        this.sessionId = sessionId;
        this.cn = cn;
        this.stateable = stateable;
        cn.addRef();
    }

    @Override
    protected void finalClose() throws Throwable {
        this.cn.closeConnection();
    }

    public boolean isStateable() {
        return this.stateable;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public abstract Object createObject(String var1, Class var2, Class[] var3, Object[] var4) throws RPCException;

    public Object createObject(String name, Class model) throws RPCException {
        return this.createObject(name, model, null, null);
    }

    public String toString() {
        return "RPCSession#" + this.sessionId;
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        if (ServerManager.getConfig().logSessionFinalize) {
            logger.info((Object)("RPCSession#" + this.getSessionId() + " finalized."));
        }
        this.close();
    }

    public String getClientIp() {
        return this.cn.getClientIp();
    }

    public Connector getConnector() {
        return this.cn;
    }
}

