/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.impl;

import com.kingdee.bos.rpc.RPCEngine;
import java.util.ArrayList;

public abstract class BatchUpdater {
    private final ArrayList ar = new ArrayList();
    private Worker worker = null;
    private long delayInterval = 0L;

    public synchronized void add(Object val, int maxSize, long delayInterval) {
        this.ar.add(val);
        if (this.ar.size() >= maxSize) {
            delayInterval = 0L;
        }
        this.delayInterval = delayInterval;
        if (this.worker == null) {
            if (delayInterval > 0L) {
                this.worker = new Worker();
            } else {
                this.update();
            }
        } else if (delayInterval <= 0L) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        Object[] values = null;
        BatchUpdater batchUpdater = this;
        synchronized (batchUpdater) {
            if (this.delayInterval > 0L) {
                try {
                    this.wait(this.delayInterval);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.worker = null;
            values = this.ar.toArray();
            this.ar.clear();
        }
        if (values != null && values.length > 0) {
            this.update(values);
        }
    }

    protected abstract void update(Object[] var1);

    private class Worker
    implements Runnable {
        Worker() {
            RPCEngine.startThread(this);
        }

        @Override
        public void run() {
            BatchUpdater.this.update();
        }
    }
}

