/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.impl;

import com.kingdee.bos.rpc.Event;
import com.kingdee.bos.rpc.EventContainer;
import com.kingdee.bos.rpc.EventListener;
import com.kingdee.bos.rpc.ObjectWithContext;
import com.kingdee.bos.rpc.event.CloseEvent;
import com.kingdee.bos.rpc.impl.CounterObject;
import com.kingdee.bos.rpc.impl.EventManager;
import com.kingdee.bos.rpc.performance.IntValue;
import com.kingdee.bos.rpc.performance.PerformanceManager;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class ContainerBase
extends CounterObject
implements ObjectWithContext,
EventContainer {
    private static final Logger logger = Logger.getLogger(ContainerBase.class);
    protected final EventManager eventManager = new EventManager();
    protected final HashMap contexts = new HashMap();
    private final Object contextMonitor = new Object();
    private IntValue counter = null;
    protected boolean closed = false;

    public synchronized void setCounter(String parent, String name) {
        if (this.isClosed()) {
            return;
        }
        if (this.counter == null) {
            this.counter = PerformanceManager.getIntValue(parent, parent + "." + name);
            this.counter.append(1);
        }
    }

    @Override
    public Object getContextMonitor() {
        return this.contextMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getContext(Object key) {
        Object object = this.contextMonitor;
        synchronized (object) {
            return this.contexts.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getContext(Object key, Object defaultValue) {
        Object object = this.contextMonitor;
        synchronized (object) {
            if (this.contexts.containsKey(key)) {
                return this.contexts.get(key);
            }
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putContext(Object key, Object value) {
        Object object = this.contextMonitor;
        synchronized (object) {
            this.contexts.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object removeContext(Object key) {
        Object object = this.contextMonitor;
        synchronized (object) {
            return this.contexts.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] contextKeys() {
        Object object = this.contextMonitor;
        synchronized (object) {
            return this.contexts.keySet().toArray();
        }
    }

    @Override
    public void addEventListener(Class eventType, EventListener listener) {
        this.eventManager.addEventListener(eventType, listener);
    }

    @Override
    public void removeEventListener(Class eventType, EventListener listener) {
        this.eventManager.removeEventListener(eventType, listener);
    }

    protected void fireEvent(Class eventType, Event event) {
        this.eventManager.fireEvent(eventType, event);
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    protected abstract void finalClose() throws Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        ContainerBase containerBase = this;
        synchronized (containerBase) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        if (this.counter != null) {
            this.counter.append(-1);
        }
        this.fireEvent(CloseEvent.class, new CloseEvent(this));
        try {
            this.finalClose();
        }
        catch (Throwable e) {
            logger.debug((Object)e, e);
        }
        super.releaseCounter();
    }

    @Override
    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

