/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.impl;

import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.ce.ObjectArgs;
import com.kingdee.bos.rpc.ce.RPCConnectException;
import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.impl.InvokeResult;
import com.kingdee.bos.rpc.impl.PrimitiveHold;
import com.kingdee.bos.rpc.impl.RPCRequest;
import com.kingdee.bos.rpc.impl.RPCSessionImpl;
import com.kingdee.bos.rpc.io.InvokeHelper;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.transaction.TransactionInfo;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.net.SocketException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DirectInvokeXML {
    private RPCRequest request;
    private RPCSessionImpl session;
    private InvokeHelper helper;
    private ObjectOutput out = null;
    private boolean createObject = true;
    private int invokeMode = -20;
    private static Map objectStubCache = Collections.synchronizedMap(new HashMap());

    public DirectInvokeXML(RPCRequest request, RPCSessionImpl session, int invokeMode) {
        this.request = request;
        this.session = session;
        this.invokeMode = invokeMode;
    }

    private static Object createKey(RPCRequest request) {
        return new ObjectArgs(request.className, request.model, request.argTypes, request.args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke() {
        this.startInvoke();
        InvokeResult invokeResult = null;
        this.writeArgs();
        try {
            invokeResult = this.finishInvoke();
            Object object = invokeResult.value;
            return object;
        }
        catch (Throwable e) {
            Throwable throwable = e;
            return throwable;
        }
        finally {
            this.close();
        }
    }

    private void writeArgs() {
        for (int i = 0; i < this.request.methodArgs.length; ++i) {
            Object arg = this.request.methodArgs[i];
            this.write(arg);
        }
    }

    private void write(Object arg) {
        try {
            if (arg instanceof PrimitiveHold.Holdable) {
                if (arg instanceof PrimitiveHold.IntHold) {
                    this.out.writeInt(((PrimitiveHold.IntHold)arg).value);
                } else if (arg instanceof PrimitiveHold.ShortHold) {
                    this.out.writeShort(((PrimitiveHold.ShortHold)arg).value);
                } else if (arg instanceof PrimitiveHold.LongHold) {
                    this.out.writeLong(((PrimitiveHold.LongHold)arg).value);
                } else if (arg instanceof PrimitiveHold.FloatHold) {
                    this.out.writeFloat(((PrimitiveHold.FloatHold)arg).value);
                } else if (arg instanceof PrimitiveHold.DoubleHold) {
                    this.out.writeDouble(((PrimitiveHold.DoubleHold)arg).value);
                } else if (arg instanceof PrimitiveHold.CharHold) {
                    this.out.writeChar(((PrimitiveHold.CharHold)arg).value);
                } else if (arg instanceof PrimitiveHold.ByteHold) {
                    this.out.writeByte(((PrimitiveHold.ByteHold)arg).value);
                } else if (arg instanceof PrimitiveHold.BooleanHold) {
                    this.out.writeBoolean(((PrimitiveHold.BooleanHold)arg).value);
                }
            } else {
                this.out.writeObject(arg);
            }
        }
        catch (IOException e) {
            throw RPCException.createIt(e);
        }
    }

    public void startInvoke() {
        try {
            if (this.session.getConnector().url.toLowerCase().startsWith("tcps")) {
                ServerManager.setCurrentServer("ssl");
            }
            this.helper = this.session.newInvokeHelper();
            DataOutputStream dout = new DataOutputStream(this.helper.getOutputStream());
            Object key = DirectInvokeXML.createKey(this.request);
            Long ref = (Long)objectStubCache.get(key);
            boolean bl = this.createObject = ref == null;
            if (this.createObject) {
                dout.writeByte(20);
                dout.writeLong(this.session.getSessionId());
                ObjectOutput out2 = this.session.createOutputStream(dout);
                out2.writeObject(this.request.className);
                out2.writeObject(this.request.model);
                out2.writeObject(this.request.argTypes);
                out2.writeObject(this.request.args);
                out2.flush();
            } else {
                dout.writeByte(0);
                dout.writeLong(this.session.getSessionId());
                dout.writeLong(ref);
            }
            TransactionInfo.writeNULL(dout);
            dout.writeInt(this.invokeMode);
            this.out = this.session.createOutputStream(dout);
            this.out.writeInt(this.request.methodCode);
            if (this.request.methodCode == 0) {
                this.out.writeObject(this.request.methodName);
            }
        }
        catch (Throwable e) {
            throw RPCException.createIt(e);
        }
    }

    public InvokeResult finishInvoke() throws IOException {
        try {
            byte type;
            try {
                this.out.close();
            }
            catch (SocketException se) {
                throw new RPCConnectException(se, 6002);
            }
            Throwable err = null;
            ObjectInput in = null;
            try {
                in = this.session.createInputStream(this.helper.getInputStream(), this.request.model);
            }
            catch (Exception e) {
                if (e instanceof EOFException || e instanceof StreamCorruptedException) {
                    throw new RPCConnectException(e, 6002);
                }
                throw e;
            }
            if (this.createObject) {
                type = in.readByte();
                if (type == 0) {
                    long ref = in.readLong();
                    Object key = DirectInvokeXML.createKey(this.request);
                    objectStubCache.put(key, ref);
                } else {
                    err = (Throwable)in.readObject();
                }
            }
            if (err == null) {
                type = in.readByte();
                Object value = RPCSessionImpl.readObject(in);
                InvokeResult invokeResult = new InvokeResult(type, value);
                return invokeResult;
            }
            throw err;
        }
        catch (Throwable e) {
            throw RPCException.createIt(e);
        }
    }

    public void close() {
        if (this.helper != null) {
            IOUtil.close(this.helper);
        }
    }
}

