/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.impl;

import com.kingdee.bos.rpc.Event;
import com.kingdee.bos.rpc.EventContainer;
import com.kingdee.bos.rpc.EventListener;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class EventManager
implements EventContainer {
    private static final Logger logger = Logger.getLogger(EventManager.class);
    private final HashMap listeners = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getListenerList(Class eventType) {
        HashMap hashMap = this.listeners;
        synchronized (hashMap) {
            List list = (List)this.listeners.get(eventType);
            if (list == null) {
                list = new List();
                this.listeners.put(eventType, list);
            }
            return list;
        }
    }

    @Override
    public void addEventListener(Class eventType, EventListener listener) {
        this.getListenerList(eventType).add(listener);
    }

    @Override
    public void removeEventListener(Class eventType, EventListener listener) {
        this.getListenerList(eventType).remove(listener);
    }

    public void fireEvent(Class eventType, Event event) {
        EventListener[] ls = this.getListenerList(eventType).list();
        for (int i = 0; i < ls.length; ++i) {
            try {
                ls[i].onEvent(event);
                continue;
            }
            catch (Throwable e) {
                logger.error((Object)"Error occured when fireEvent", e);
            }
        }
    }

    public void fireEvent(Event event) {
        this.fireEvent(event.getClass(), event);
    }

    private static class List {
        private final ArrayList ls = new ArrayList();
        private EventListener[] ar = null;

        private List() {
        }

        synchronized void add(EventListener l) {
            this.ls.add(l);
            this.ar = null;
        }

        synchronized void remove(EventListener l) {
            this.ls.remove(l);
            this.ar = null;
        }

        synchronized EventListener[] list() {
            if (this.ar == null) {
                this.ar = this.ls.toArray(new EventListener[this.ls.size()]);
            }
            return this.ar;
        }
    }
}

