/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.impl;

import com.tool.classfile.sc;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.WeakHashMap;

public class GenerateMethod {
    int code;
    String desc;
    Method md;
    boolean codeRepeated = false;
    private static final WeakHashMap models = new WeakHashMap();

    public static String parametersName(Class[] types) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(GenerateMethod.shortName(types[i]));
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public static String methodName(Method md) {
        if (md == null) {
            return null;
        }
        return GenerateMethod.shortName(md.getReturnType()) + " " + md.getName() + GenerateMethod.parametersName(md.getParameterTypes());
    }

    public static String shortName(Class type) {
        if (type.isArray()) {
            return GenerateMethod.shortName(type.getComponentType()) + "[]";
        }
        String name = type.getName();
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            name = name.substring(index + 1);
        }
        return name.replace('$', '.');
    }

    public static String fullName(Class type) {
        if (type.isArray()) {
            return GenerateMethod.fullName(type.getComponentType()) + "[]";
        }
        Package pack = type.getPackage();
        if (pack != null && pack.getName().equals("java.lang")) {
            return type.getName().substring(10).replace('$', '.');
        }
        return type.getName().replace('$', '.');
    }

    GenerateMethod(Method md) {
        this.md = md;
        this.desc = md.getName() + sc.methodDescriptor((Method)md);
        this.code = this.desc.hashCode();
    }

    static GenerateMethod[] getMethods(Class cls) {
        Method[] mds = cls.getMethods();
        HashMap<Integer, GenerateMethod> codes = new HashMap<Integer, GenerateMethod>();
        HashMap<String, GenerateMethod> names = new HashMap<String, GenerateMethod>();
        for (int i = 0; i < mds.length; ++i) {
            GenerateMethod md = new GenerateMethod(mds[i]);
            if (names.containsKey(md.desc)) continue;
            names.put(md.desc, md);
            Integer codeKey = md.code;
            GenerateMethod md0 = (GenerateMethod)codes.get(codeKey);
            if (md0 == null) {
                codes.put(codeKey, md);
                continue;
            }
            md0.codeRepeated = true;
            md.codeRepeated = true;
        }
        return names.values().toArray(new GenerateMethod[names.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Method getMethod(Class model, int code, String name) {
        HashMap<Object, GenerateMethod> map;
        WeakHashMap weakHashMap = models;
        synchronized (weakHashMap) {
            map = (HashMap<Object, GenerateMethod>)models.get(model);
            if (map == null) {
                map = new HashMap<Object, GenerateMethod>();
                GenerateMethod[] ms = GenerateMethod.getMethods(model);
                for (int i = 0; i < ms.length; ++i) {
                    GenerateMethod gm = ms[i];
                    if (gm.code != 0) {
                        map.put(gm.code, gm);
                    }
                    map.put(gm.desc, gm);
                }
                models.put(model, map);
            }
        }
        GenerateMethod gm = null;
        if (name != null) {
            gm = (GenerateMethod)map.get(name);
        }
        if (gm == null) {
            gm = (GenerateMethod)map.get(code);
        }
        if (gm == null) {
            return null;
        }
        return gm.md;
    }
}

