/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.impl;

public abstract class IdleTimeoutMonitor
implements Runnable {
    private final long timeout;
    private long lastTime;
    private int refs = 0;

    public IdleTimeoutMonitor(long timeout) {
        this.timeout = timeout;
        this.reset();
    }

    public synchronized void reset() {
        this.lastTime = System.currentTimeMillis();
    }

    public synchronized void enter() {
        ++this.refs;
        this.reset();
    }

    public synchronized void leave() {
        --this.refs;
        this.reset();
    }

    public synchronized boolean isTimeout() {
        if (this.refs == 0 && System.currentTimeMillis() - this.lastTime >= this.timeout) {
            this.reset();
            return true;
        }
        return false;
    }

    protected abstract void onIdleTimeout();

    @Override
    public void run() {
        if (this.isTimeout()) {
            this.onIdleTimeout();
        }
    }
}

