/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.impl;

import com.kingdee.bos.rpc.RPCConfig;
import com.kingdee.bos.rpc.impl.GenerateMethod;
import com.kingdee.bos.rpc.impl.InvokeResult;
import com.kingdee.bos.rpc.impl.ProxyContext;
import com.kingdee.bos.rpc.impl.ThreadContext;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.performance.InvokeMonitor;
import com.kingdee.bos.rpc.performance.InvokeRecord;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class ObjectProxy {
    private static final Logger logger = Logger.getLogger(ObjectProxy.class);
    private HashMap errors = null;
    public final ProxyContext ctx;
    private static final ThreadContext threadProxy = new ThreadContext();

    public ObjectProxy(ProxyContext ctx) {
        this.ctx = ctx;
        if (ServerManager.getConfig().logObjectCreate) {
            logger.info((Object)(this.toString() + " created."));
        }
    }

    protected void finalize() throws Throwable {
        if (ServerManager.getConfig().logObjectFinalize) {
            logger.info((Object)(this.toString() + " finalized."));
        }
    }

    public Object getObject() {
        return this.ctx.obj;
    }

    public long getRef() {
        return this.ctx.ref;
    }

    public String toString() {
        return "ObjectProxy#" + this.ctx.ref;
    }

    public Class getModel() {
        return this.ctx.model;
    }

    synchronized Throwable getError(int resultId) {
        if (this.errors == null) {
            return null;
        }
        return (Throwable)this.errors.remove(resultId);
    }

    synchronized void setError(int resultId, Throwable e) {
        if (this.errors == null) {
            this.errors = new HashMap();
        }
        this.errors.put(resultId, e);
    }

    protected boolean _Z(int index, ObjectInput in, InvokeRecord rec) throws IOException {
        boolean v = in.readBoolean();
        if (rec != null) {
            rec.finishRequestTime = System.currentTimeMillis();
            ((InvokeRecord.MethodInvoke)rec.detail).args[index] = v;
        }
        return v;
    }

    protected byte _B(int index, ObjectInput in, InvokeRecord rec) throws IOException {
        byte v = in.readByte();
        if (rec != null) {
            rec.finishRequestTime = System.currentTimeMillis();
            ((InvokeRecord.MethodInvoke)rec.detail).args[index] = v;
        }
        return v;
    }

    protected char _C(int index, ObjectInput in, InvokeRecord rec) throws IOException {
        char v = in.readChar();
        if (rec != null) {
            rec.finishRequestTime = System.currentTimeMillis();
            ((InvokeRecord.MethodInvoke)rec.detail).args[index] = Character.valueOf(v);
        }
        return v;
    }

    protected short _S(int index, ObjectInput in, InvokeRecord rec) throws IOException {
        short v = in.readShort();
        if (rec != null) {
            rec.finishRequestTime = System.currentTimeMillis();
            ((InvokeRecord.MethodInvoke)rec.detail).args[index] = v;
        }
        return v;
    }

    protected int _I(int index, ObjectInput in, InvokeRecord rec) throws IOException {
        int v = in.readInt();
        if (rec != null) {
            rec.finishRequestTime = System.currentTimeMillis();
            ((InvokeRecord.MethodInvoke)rec.detail).args[index] = v;
        }
        return v;
    }

    protected long _J(int index, ObjectInput in, InvokeRecord rec) throws IOException {
        long v = in.readLong();
        if (rec != null) {
            rec.finishRequestTime = System.currentTimeMillis();
            ((InvokeRecord.MethodInvoke)rec.detail).args[index] = v;
        }
        return v;
    }

    protected float _F(int index, ObjectInput in, InvokeRecord rec) throws IOException {
        float v = in.readFloat();
        if (rec != null) {
            rec.finishRequestTime = System.currentTimeMillis();
            ((InvokeRecord.MethodInvoke)rec.detail).args[index] = Float.valueOf(v);
        }
        return v;
    }

    protected double _D(int index, ObjectInput in, InvokeRecord rec) throws IOException {
        double v = in.readDouble();
        if (rec != null) {
            rec.finishRequestTime = System.currentTimeMillis();
            ((InvokeRecord.MethodInvoke)rec.detail).args[index] = v;
        }
        return v;
    }

    protected Object _L(int index, ObjectInput in, InvokeRecord rec) throws IOException, ClassNotFoundException {
        Object v = in.readObject();
        if (rec != null) {
            rec.finishRequestTime = System.currentTimeMillis();
            ((InvokeRecord.MethodInvoke)rec.detail).args[index] = v;
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InvokeResult processInvoke(ObjectInput in, InvokeRecord rec) throws Throwable {
        ObjectProxy oldProxy = ObjectProxy.setCurrentProxy(this);
        try {
            InvokeRecord.MethodInvoke detail;
            InvokeRecord.MethodInvoke methodInvoke = detail = rec == null ? null : (InvokeRecord.MethodInvoke)rec.detail;
            if (detail != null) {
                detail.model = this.ctx.model;
            }
            int methodCode = in.readInt();
            String methodName = null;
            if (methodCode == 0) {
                methodName = (String)in.readObject();
            }
            if (detail != null) {
                detail.method = GenerateMethod.getMethod(this.ctx.model, methodCode, methodName);
                detail.args = new Object[detail.method == null ? 0 : detail.method.getParameterTypes().length];
            }
            if (rec != null) {
                rec.finishRequestTime = System.currentTimeMillis();
            }
            InvokeMonitor[] invokeMonitors = RPCConfig.invokeMonitors;
            for (int i = 0; i < invokeMonitors.length; ++i) {
                if (!invokeMonitors[i].recordServer() || !invokeMonitors[i].recordInvokeStart()) continue;
                invokeMonitors[i].invokeStart(methodName, rec);
            }
            InvokeResult ir = this.processInvoke(methodCode, methodName, in, rec);
            if (ir == null) {
                ir = new InvokeResult(1, new NoSuchMethodError());
            }
            for (int i = 0; i < invokeMonitors.length; ++i) {
                if (!invokeMonitors[i].recordServer() || !invokeMonitors[i].recordInvokeEnd()) continue;
                invokeMonitors[i].invokeEnd(methodName, rec);
            }
            InvokeResult invokeResult = ir;
            return invokeResult;
        }
        finally {
            ObjectProxy.setCurrentProxy(oldProxy);
        }
    }

    protected abstract InvokeResult processInvoke(int var1, String var2, ObjectInput var3, InvokeRecord var4) throws Throwable;

    public static ObjectProxy getCurrentProxy() {
        return (ObjectProxy)threadProxy.get();
    }

    private static ObjectProxy setCurrentProxy(ObjectProxy newProxy) {
        return (ObjectProxy)threadProxy.set(newProxy);
    }
}

