/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.impl;

import com.kingdee.bos.RemoteBOSObjectFactory;
import com.kingdee.bos.rpc.InvokeIntercepter;
import com.kingdee.bos.rpc.RPCConfig;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.RPCUtil;
import com.kingdee.bos.rpc.analysis.AnalysisResult;
import com.kingdee.bos.rpc.ce.MethodArgs;
import com.kingdee.bos.rpc.ce.ObjectArgs;
import com.kingdee.bos.rpc.ce.RPCConnectException;
import com.kingdee.bos.rpc.impl.GenerateMethod;
import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.impl.InvokeResult;
import com.kingdee.bos.rpc.impl.ObjectStub;
import com.kingdee.bos.rpc.impl.PrimitiveHold;
import com.kingdee.bos.rpc.impl.RPCObjectInputStream;
import com.kingdee.bos.rpc.impl.RPCRecordStatus;
import com.kingdee.bos.rpc.impl.RPCRequest;
import com.kingdee.bos.rpc.impl.RPCSessionImpl;
import com.kingdee.bos.rpc.impl.StubContext;
import com.kingdee.bos.rpc.impl.StubFinalizer;
import com.kingdee.bos.rpc.io.ConnectionMonitor;
import com.kingdee.bos.rpc.io.Connector;
import com.kingdee.bos.rpc.io.InvokeHelper;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.netty.ResponseCallback;
import com.kingdee.bos.rpc.netty.RpcContext;
import com.kingdee.bos.rpc.netty.RpcNettyConstant;
import com.kingdee.bos.rpc.performance.CounterValue;
import com.kingdee.bos.rpc.performance.InvokeMonitor;
import com.kingdee.bos.rpc.performance.InvokeRecord;
import com.kingdee.bos.rpc.performance.PerformanceManager;
import com.kingdee.bos.rpc.recordSlowReq.RecordSlowReqSwitch;
import com.kingdee.bos.rpc.transaction.TransactionInfo;
import com.kingdee.bos.rpc.transaction.TransactionManager;
import com.kingdee.util.Uuid;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StreamCorruptedException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class RPCInvoke {
    private static final Logger logger = Logger.getLogger(RPCInvoke.class);
    private InvokeHelper helper = null;
    private ObjectOutput out = null;
    private ObjectStub stub;
    private StubContext ctx;
    private Invoke rec;
    private int invoke_id = Math.abs(Uuid.create().hashCode());
    private InvokeRecord ir;
    private InvokeRecord.MethodInvoke detail;
    private boolean createObject;
    private RPCRequest rpcRequest;
    private static final ExecutorService es = Executors.newCachedThreadPool();
    private static volatile Thread uiThread = null;
    private static String logDir = null;
    private static CounterValue invokeCount = null;

    public RPCInvoke(ObjectStub stub) {
        this.stub = stub;
        this.ctx = stub.ctx;
        this.rec = new Invoke(this.ctx.session.getConnector(), 0);
        this.ir = this.rec.rec;
        this.detail = (InvokeRecord.MethodInvoke)this.rec.detail;
        if (this.detail != null) {
            this.detail.sessionId = this.ctx.session.getSessionId();
            this.detail.objectId = this.ctx.ref;
            this.detail.invokeId = this.invoke_id;
            this.detail.model = this.ctx.model;
        }
        this.ctx.session.enterService();
    }

    public void close() {
        if (this.helper != null) {
            this.ctx.session.leaveService();
            this.rec.close(this.helper);
            this.rec.finish();
            this.helper = null;
            if (this.ctx.session.getConnector().url.toLowerCase().startsWith("tcps")) {
                ServerManager.setCurrentServer(null);
            }
        }
    }

    public void startInvoke(int methodCode, String methodName) {
        TransactionInfo tinfo = TransactionManager.getCurrentTransactionInfo();
        if (this.detail != null) {
            this.detail.methodCode = methodCode;
            this.detail.method = GenerateMethod.getMethod(this.ctx.model, methodCode, methodName);
            if (this.detail.method != null) {
                this.detail.args = new Object[this.detail.method.getParameterTypes().length];
            }
            this.detail.transactionName = tinfo.name;
            this.detail.transactionId = tinfo.id;
            this.detail.user = tinfo.user;
        }
        if (RPCRecordStatus.isOnThread()) {
            this.rpcRequest = RPCRecordStatus.createRPCRequest();
            this.invoke_id = RecordSlowReqSwitch.getActionRecord() == null ? -5 : -40;
            if (this.detail != null) {
                this.detail.invokeId = this.invoke_id;
                this.rpcRequest.methodArgTypes = this.detail.method.getParameterTypes();
                this.rpcRequest.methodArgs = new Object[this.detail.method.getParameterTypes().length];
            } else {
                Method method = GenerateMethod.getMethod(this.ctx.model, methodCode, methodName);
                this.rpcRequest.methodArgTypes = method.getParameterTypes();
                this.rpcRequest.methodArgs = new Object[method.getParameterTypes().length];
            }
        }
        try {
            if (this.ctx.session.getConnector().url.toLowerCase().startsWith("tcps")) {
                ServerManager.setCurrentServer("ssl");
            }
            this.helper = this.ctx.session.newInvokeHelper();
            DataOutputStream dout = new DataOutputStream(this.helper.getOutputStream());
            if (this.ctx.ref == -1L) {
                this.createObject = true;
                dout.writeByte(20);
                dout.writeLong(this.ctx.session.getSessionId());
                ObjectOutput out2 = this.ctx.session.createOutputStream(dout);
                out2.writeObject(this.ctx.objectArgs.className);
                out2.writeObject(this.ctx.objectArgs.model);
                out2.writeObject(this.ctx.objectArgs.argTypes);
                out2.writeObject(this.ctx.objectArgs.args);
                out2.flush();
            } else {
                dout.writeByte(0);
                dout.writeLong(this.ctx.session.getSessionId());
                dout.writeLong(this.ctx.ref);
            }
            if (this.rpcRequest != null) {
                this.rpcRequest.rpcCommand = 20;
                this.rpcRequest.className = this.ctx.objectArgs.className;
                this.rpcRequest.model = this.ctx.objectArgs.model;
                this.rpcRequest.argTypes = this.ctx.objectArgs.argTypes;
                this.rpcRequest.args = this.ctx.objectArgs.args;
            }
            TransactionInfo.write(dout, tinfo);
            dout.writeInt(this.invoke_id);
            this.out = this.ctx.session.createOutputStream(dout);
            if (this.rpcRequest != null) {
                ObjectOutputStream oos = new ObjectOutputStream(this.rpcRequest.baos);
                this.out = IOUtil.createBothObjectOutput(this.out, oos);
            }
            this.out.writeInt(methodCode);
            if (methodCode == 0) {
                this.out.writeObject(methodName);
            }
            if (this.rpcRequest != null) {
                this.rpcRequest.methodCode = methodCode;
                this.rpcRequest.methodName = methodName;
            }
        }
        catch (Throwable e) {
            if (e instanceof SocketException || e instanceof RPCConnectException) {
                RemoteBOSObjectFactory.getInstance((String)this.ctx.session.getConnector().url).clearSession();
            }
            throw RPCException.createIt(e, this.ir);
        }
    }

    public void _Z(int index, boolean v) throws IOException {
        if (this.detail != null) {
            this.detail.args[index] = v;
        }
        if (this.rpcRequest != null) {
            this.rpcRequest.methodArgs[index] = new PrimitiveHold.BooleanHold(v);
        }
        this.out.writeBoolean(v);
    }

    public void _B(int index, byte v) throws IOException {
        if (this.detail != null) {
            this.detail.args[index] = v;
        }
        if (this.rpcRequest != null) {
            this.rpcRequest.methodArgs[index] = new PrimitiveHold.ByteHold(v);
        }
        this.out.writeByte(v);
    }

    public void _C(int index, char v) throws IOException {
        if (this.detail != null) {
            this.detail.args[index] = Character.valueOf(v);
        }
        if (this.rpcRequest != null) {
            this.rpcRequest.methodArgs[index] = new PrimitiveHold.CharHold(v);
        }
        this.out.writeChar(v);
    }

    public void _S(int index, short v) throws IOException {
        if (this.detail != null) {
            this.detail.args[index] = v;
        }
        if (this.rpcRequest != null) {
            this.rpcRequest.methodArgs[index] = new PrimitiveHold.ShortHold(v);
        }
        this.out.writeShort(v);
    }

    public void _I(int index, int v) throws IOException {
        if (this.detail != null) {
            this.detail.args[index] = v;
        }
        if (this.rpcRequest != null) {
            this.rpcRequest.methodArgs[index] = new PrimitiveHold.IntHold(v);
        }
        this.out.writeInt(v);
    }

    public void _J(int index, long v) throws IOException {
        if (this.detail != null) {
            this.detail.args[index] = v;
        }
        if (this.rpcRequest != null) {
            this.rpcRequest.methodArgs[index] = new PrimitiveHold.LongHold(v);
        }
        this.out.writeLong(v);
    }

    public void _F(int index, float v) throws IOException {
        if (this.detail != null) {
            this.detail.args[index] = Float.valueOf(v);
        }
        if (this.rpcRequest != null) {
            this.rpcRequest.methodArgs[index] = new PrimitiveHold.FloatHold(v);
        }
        this.out.writeFloat(v);
    }

    public void _D(int index, double v) throws IOException {
        if (this.detail != null) {
            this.detail.args[index] = v;
        }
        if (this.rpcRequest != null) {
            this.rpcRequest.methodArgs[index] = new PrimitiveHold.DoubleHold(v);
        }
        this.out.writeDouble(v);
    }

    public void _L(int index, Object v) throws IOException {
        if (this.detail != null) {
            this.detail.args[index] = v;
        }
        if (this.rpcRequest != null) {
            this.rpcRequest.methodArgs[index] = v;
        }
        try {
            this.out.writeObject(v);
        }
        catch (SocketException se) {
            throw new RPCConnectException(se, 6002);
        }
    }

    public static void beginTrace(String logDir) {
        RPCInvoke.logDir = logDir;
        uiThread = Thread.currentThread();
    }

    public static void endTrace() {
        uiThread = null;
    }

    public InvokeResult finishInvoke() throws IOException {
        Object ps;
        if (uiThread != null && uiThread == Thread.currentThread()) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ps = new PrintStream((OutputStream)bos, true, "UTF-8");
                ((PrintStream)ps).append("\n\n\n");
                new Exception("RPC-INVOKE-STACK").printStackTrace((PrintStream)ps);
                ((PrintStream)ps).append("\n\n\n");
                ((PrintStream)ps).close();
                String dir = logDir == null ? "W:\\etc\\" : logDir;
                FileOutputStream fos = new FileOutputStream(dir + "\\rpc-invoke-log-" + System.currentTimeMillis() + ".txt", true);
                fos.write(bos.toByteArray());
                fos.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        RpcContext.getContext().setRpcInvoke(this);
        RpcContext.getContext().setFuture(null);
        try {
            try {
                this.out.close();
            }
            catch (SocketException se) {
                throw new RPCConnectException(se, 6002);
            }
            if (this.ir != null) {
                this.ir.finishRequestTime = System.currentTimeMillis();
            }
            if (RpcContext.getContext().isAsync()) {
                this.handleAsync();
                InvokeResult se = RpcNettyConstant.RS_NULL;
                return se;
            }
            InputStream helperIn = this.helper.getInputStream();
            ps = this._finishInvoke(helperIn);
            return ps;
        }
        catch (Throwable e) {
            if (e instanceof RPCConnectException) {
                throw (RPCConnectException)e;
            }
            if (e instanceof ConnectException || e instanceof SocketException) {
                RPCConnectException ce = new RPCConnectException(e, 6001);
                ce.oa = this.ctx.session.oa;
                if (this.detail != null) {
                    ce.ma = new MethodArgs(this.detail.method.getName(), this.detail.method.getParameterTypes(), this.detail.args);
                }
                throw ce;
            }
            throw RPCException.createIt(e, this.ir);
        }
        finally {
            RpcContext.getContext().setRpcInvoke(null);
        }
    }

    public InvokeResult _finishInvoke(InputStream helperIn) throws Throwable {
        Throwable err;
        block18: {
            err = null;
            ObjectInput in = null;
            try {
                byte type;
                try {
                    in = this.ctx.session.createInputStream(helperIn, this.ctx.model);
                }
                catch (Exception e) {
                    if (e instanceof EOFException || e instanceof StreamCorruptedException) {
                        logger.error((Object)e);
                        throw new RPCConnectException(e, 6002);
                    }
                    throw e;
                }
                if (this.createObject) {
                    type = in.readByte();
                    if (type == 0) {
                        long ref;
                        this.ctx.ref = ref = in.readLong();
                    } else {
                        err = (Throwable)in.readObject();
                    }
                }
                if (err == null) {
                    InvokeIntercepter[] invokeIntercepters;
                    type = in.readByte();
                    Object value = RPCSessionImpl.readObject(in);
                    AnalysisResult analysisResult = null;
                    if (this.rpcRequest != null) {
                        analysisResult = (AnalysisResult)RPCSessionImpl.readObject(in);
                    }
                    InvokeResult invokeResult = new InvokeResult(type, value);
                    if (this.rpcRequest != null) {
                        this.finishedInvokeForRecord(invokeResult, analysisResult);
                    }
                    if ((invokeIntercepters = RPCConfig.invokeIntercepters).length > 0) {
                        for (int i = 0; i < invokeIntercepters.length; ++i) {
                            invokeIntercepters[i].finishInvoke(this.ctx.session, in, type, value, this.detail);
                        }
                    }
                    if (this.ir != null) {
                        if (type == 1) {
                            this.rec.setError(value);
                            if (value instanceof RPCException && (((RPCException)value).getErrorCode() == 1002 || ((RPCException)value).getErrorCode() == 1003)) {
                                RemoteBOSObjectFactory.getInstance((String)this.ctx.session.getConnector().url).clearSession();
                            }
                        } else {
                            this.detail.result = value;
                        }
                    }
                    return invokeResult;
                }
            }
            catch (Throwable e) {
                err = RPCInvoke.getError(this.stub, this.invoke_id);
                if (err == null) {
                    err = e;
                }
                if (!(err instanceof RPCConnectException)) break block18;
                ((RPCConnectException)err).oa = this.ctx.session.oa;
                if (this.detail == null) break block18;
                ((RPCConnectException)err).ma = new MethodArgs(this.detail.method.getName(), this.detail.method.getParameterTypes(), this.detail.args);
            }
        }
        throw err;
    }

    private void finishedInvokeForRecord(InvokeResult invokeResult, AnalysisResult analysisResult) {
        this.rpcRequest.finished(invokeResult, analysisResult);
    }

    public static byte[] ping(InvokeHelper helper, byte[] data) throws IOException {
        return RPCInvoke.ping(null, helper, data);
    }

    public static byte[] ping(Connector cn, byte[] data) throws IOException {
        return RPCInvoke.ping(cn, cn.newInvokeHelper(), data);
    }

    private static byte[] ping(Connector cn, InvokeHelper helper, byte[] data) throws IOException {
        Invoke rec = new Invoke(cn, helper.getConnection().getConnectionUrl(), 9);
        InvokeRecord ir = rec.rec;
        InvokeRecord.Ping detail = (InvokeRecord.Ping)rec.detail;
        if (detail != null) {
            detail.request = data;
        }
        try {
            DataOutputStream out = new DataOutputStream(helper.getOutputStream());
            out.writeByte(9);
            if (data == null) {
                out.writeInt(-1);
            } else {
                out.writeInt(data.length);
                out.write(data);
            }
            out.close();
            if (ir != null) {
                ir.finishRequestTime = System.currentTimeMillis();
            }
            DataInputStream in = new DataInputStream(helper.getInputStream());
            byte[] response = null;
            int len = in.readInt();
            if (len >= 0) {
                response = new byte[len];
                in.readFully(response);
            }
            if (detail != null) {
                detail.response = response;
            }
            byte[] byArray = response;
            return byArray;
        }
        catch (IOException e) {
            rec.setError(e);
            throw e;
        }
        finally {
            rec.close(helper);
            rec.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void keepAlive(RPCSessionImpl session) throws IOException {
        if (session.isClosed()) {
            return;
        }
        session.enterService();
        try {
            InvokeHelper helper = session.getConnector().newInvokeHelper();
            Invoke rec = new Invoke(session.getConnector(), 7);
            InvokeRecord ir = rec.rec;
            InvokeRecord.KeepAlive detail = (InvokeRecord.KeepAlive)rec.detail;
            if (detail != null) {
                detail.sessionId = session.getSessionId();
            }
            try {
                InvokeIntercepter[] invokeIntercepters;
                DataOutputStream out = new DataOutputStream(helper.getOutputStream());
                out.writeByte(7);
                out.writeLong(session.getSessionId());
                out.close();
                if (ir != null) {
                    ir.finishRequestTime = System.currentTimeMillis();
                }
                if ((invokeIntercepters = RPCConfig.invokeIntercepters).length > 0) {
                    for (int i = 0; i < invokeIntercepters.length; ++i) {
                        ObjectInputStream in = new ObjectInputStream(helper.getInputStream());
                        invokeIntercepters[i].keepAlive(session, in);
                    }
                }
                helper.getInputStream().read();
            }
            finally {
                rec.close(helper);
                rec.finish();
            }
        }
        finally {
            session.leaveService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeSession(Connector cn, InvokeHelper helper, long[] ids) {
        if (cn.url.toLowerCase().startsWith("tcps")) {
            ServerManager.setCurrentServer("ssl");
        }
        Invoke rec = new Invoke(cn, 2);
        InvokeRecord ir = rec.rec;
        InvokeRecord.CloseSession detail = (InvokeRecord.CloseSession)rec.detail;
        if (detail != null) {
            detail.sessions = ids;
        }
        try {
            DataOutputStream out = new DataOutputStream(helper.getOutputStream());
            out.writeByte(2);
            out.writeInt(ids.length);
            for (int i = 0; i < ids.length; ++i) {
                out.writeLong(ids[i]);
            }
            out.close();
            if (ir != null) {
                ir.finishRequestTime = System.currentTimeMillis();
            }
            helper.getInputStream().read();
        }
        catch (Throwable e) {
        }
        finally {
            rec.close(helper);
            rec.finish();
            if (cn.url.toLowerCase().startsWith("tcps")) {
                ServerManager.setCurrentServer(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseObject(StubFinalizer finalizer) {
        RPCSessionImpl session = finalizer.session;
        if (session.isClosed()) {
            return;
        }
        Invoke rec = new Invoke(session.getConnector(), 4);
        InvokeRecord ir = rec.rec;
        InvokeRecord.ReleaseObject detail = (InvokeRecord.ReleaseObject)rec.detail;
        if (detail != null) {
            detail.sessionId = session.getSessionId();
        }
        session.enterService();
        try {
            InvokeHelper helper = session.getConnector().newInvokeHelper();
            try {
                DataOutputStream out = new DataOutputStream(helper.getOutputStream());
                out.writeByte(4);
                out.writeLong(session.getSessionId());
                long[] refs = finalizer.getStubs();
                if (detail != null) {
                    detail.objectIds = refs;
                }
                out.writeInt(refs.length);
                for (int i = 0; i < refs.length; ++i) {
                    out.writeLong(refs[i]);
                }
                out.close();
                if (ir != null) {
                    ir.finishRequestTime = System.currentTimeMillis();
                }
                helper.getInputStream().read();
            }
            finally {
                rec.close(helper);
            }
        }
        catch (Throwable e) {
        }
        finally {
            session.leaveService();
            rec.finish();
        }
    }

    public static Object createObject(RPCSessionImpl session, String name, Class model, Class[] argTypes, Object[] args) {
        ObjectArgs oa = new ObjectArgs(name, model, argTypes, args);
        ObjectStub stub = (ObjectStub)session.createObjectStub(model, -1L);
        stub.ctx.objectArgs = oa;
        return stub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object createObjectImpl(RPCSessionImpl session, String name, Class model, Class[] argTypes, Object[] args) {
        if (session.getConnector().url.toLowerCase().startsWith("tcps")) {
            ServerManager.setCurrentServer("ssl");
        }
        session.oa = new ObjectArgs(name, model, argTypes, args);
        TransactionInfo tinfo = TransactionManager.getCurrentTransactionInfo();
        Invoke rec = new Invoke(session.getConnector(), 3);
        InvokeRecord ir = rec.rec;
        InvokeRecord.CreateObject detail = (InvokeRecord.CreateObject)rec.detail;
        if (detail != null) {
            detail.sessionId = session.getSessionId();
            detail.name = name;
            detail.model = model;
            detail.argTypes = argTypes;
            detail.args = args;
            detail.transactionName = tinfo.name;
            detail.transactionId = tinfo.id;
            detail.user = tinfo.user;
        }
        session.enterService();
        Throwable err = null;
        try {
            InvokeHelper helper = session.newInvokeHelper();
            try {
                RPCObjectInputStream in;
                DataOutputStream out = new DataOutputStream(helper.getOutputStream());
                out.writeByte(3);
                out.writeLong(session.getSessionId());
                TransactionInfo.write(out, tinfo);
                ObjectOutput out2 = session.createOutputStream(out);
                out2.writeObject(name);
                out2.writeObject(model);
                out2.writeObject(argTypes);
                out2.writeObject(args);
                out2.flush();
                out2.close();
                if (ir != null) {
                    ir.finishRequestTime = System.currentTimeMillis();
                }
                try {
                    in = new RPCObjectInputStream(helper.getInputStream());
                }
                catch (EOFException e) {
                    throw new RPCConnectException(e);
                }
                byte type = in.readByte();
                if (type == 0) {
                    Object stub;
                    long ref = in.readLong();
                    if (detail != null) {
                        detail.objectId = ref;
                    }
                    Object object = stub = session.createObjectStub(model, ref);
                    return object;
                }
                err = (Throwable)in.readObject();
                rec.setError(err);
            }
            finally {
                rec.close(helper);
            }
        }
        catch (Throwable e) {
            if (e instanceof ConnectException || e instanceof SocketException) {
                throw new RPCConnectException(1005, e);
            }
            throw RPCException.createIt(e, ir);
        }
        finally {
            session.leaveService();
            rec.finish();
            if (session.getConnector().url.toLowerCase().startsWith("tcps")) {
                ServerManager.setCurrentServer(null);
            }
        }
        throw RPCException.createIt(err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RPCSessionImpl createSession(Connector cn, boolean stateable) {
        Throwable err = null;
        if (cn.url.toLowerCase().startsWith("tcps")) {
            ServerManager.setCurrentServer("ssl");
        }
        Invoke rec = new Invoke(cn, 1);
        InvokeRecord ir = rec.rec;
        InvokeRecord.CreateSession detail = (InvokeRecord.CreateSession)rec.detail;
        try {
            InvokeHelper helper = cn.newInvokeHelper();
            try {
                DataInputStream in;
                long sessionId;
                DataOutputStream out = new DataOutputStream(helper.getOutputStream());
                out.writeByte(1);
                String ip = cn.getClientIp();
                out.writeShort(ip.length());
                out.writeBytes(ip);
                RPCUtil.setClientIp(ip);
                ip = cn.getServerIp();
                out.writeShort(ip.length());
                out.writeBytes(ip);
                out.close();
                if (ir != null) {
                    ir.finishRequestTime = System.currentTimeMillis();
                }
                if ((sessionId = (in = new DataInputStream(helper.getInputStream())).readLong()) != -1L) {
                    RPCSessionImpl session;
                    if (detail != null) {
                        detail.sessionId = sessionId;
                    }
                    RPCSessionImpl rPCSessionImpl = session = new RPCSessionImpl(sessionId, cn, stateable);
                    return rPCSessionImpl;
                }
                RPCObjectInputStream errIn = new RPCObjectInputStream(in);
                err = (Throwable)errIn.readObject();
                rec.setError(err);
            }
            finally {
                rec.close(helper);
            }
        }
        catch (Throwable e) {
            if (e instanceof ConnectException || e instanceof SocketException) {
                throw new RPCConnectException(1005, e);
            }
            throw RPCException.createIt(e, ir);
        }
        finally {
            rec.finish();
            if (cn.url.toLowerCase().startsWith("tcps")) {
                ServerManager.setCurrentServer(null);
            }
        }
        throw RPCException.createIt(err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Throwable getError(ObjectStub stub, int resultId) {
        StubContext ctx = stub.ctx;
        Invoke rec = new Invoke(ctx.session.getConnector(), 5);
        InvokeRecord ir = rec.rec;
        InvokeRecord.GetError detail = (InvokeRecord.GetError)rec.detail;
        if (detail != null) {
            detail.sessionId = ctx.session.getSessionId();
            detail.objectId = ctx.ref;
            detail.invokeId = resultId;
        }
        try {
            InvokeHelper helper = ctx.session.newInvokeHelper();
            try {
                DataOutputStream out = new DataOutputStream(helper.getOutputStream());
                out.writeByte(5);
                out.writeLong(ctx.session.getSessionId());
                out.writeLong(ctx.ref);
                out.writeInt(resultId);
                out.close();
                if (ir != null) {
                    ir.finishRequestTime = System.currentTimeMillis();
                }
                RPCObjectInputStream in = new RPCObjectInputStream(helper.getInputStream());
                Throwable err = (Throwable)in.readObject();
                if (detail != null) {
                    detail.result = err;
                }
                Throwable throwable = err;
                rec.close(helper);
                return throwable;
            }
            catch (Throwable throwable) {
                try {
                    rec.close(helper);
                    throw throwable;
                }
                catch (Throwable e) {
                    IOUtil.logIOError(logger, e);
                    if (e instanceof RPCConnectException) {
                        Throwable throwable2 = e;
                        return throwable2;
                    }
                    Throwable throwable3 = null;
                    return throwable3;
                }
            }
        }
        finally {
            rec.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObjectModel(ObjectStub stub, Class model) {
        StubContext ctx = stub.ctx;
        Invoke rec = new Invoke(ctx.session.getConnector(), 6);
        InvokeRecord ir = rec.rec;
        InvokeRecord.GetModel detail = (InvokeRecord.GetModel)rec.detail;
        if (detail != null) {
            detail.sessionId = ctx.session.getSessionId();
            detail.objectId = ctx.ref;
            detail.model = model;
        }
        ctx.session.enterService();
        try {
            InvokeHelper helper = ctx.session.newInvokeHelper();
            try {
                Object obj;
                ObjectInput in;
                byte r;
                DataOutputStream out = new DataOutputStream(helper.getOutputStream());
                out.writeByte(6);
                out.writeLong(ctx.session.getSessionId());
                out.writeLong(ctx.ref);
                ObjectOutput out1 = ctx.session.createOutputStream(out);
                out1.writeObject(model);
                out1.close();
                if (ir != null) {
                    ir.finishRequestTime = System.currentTimeMillis();
                }
                if ((r = (in = ctx.session.createInputStream(helper.getInputStream(), model)).readByte()) == 1) {
                    throw (Throwable)in.readObject();
                }
                long ref = in.readLong();
                if (detail != null) {
                    detail.newObjectId = ref;
                }
                Object object = obj = ctx.session.createObjectStub(model, ref);
                rec.close(helper);
                return object;
            }
            catch (Throwable throwable) {
                try {
                    rec.close(helper);
                    throw throwable;
                }
                catch (Throwable e) {
                    throw RPCException.createIt(e, ir);
                }
            }
        }
        finally {
            ctx.session.leaveService();
            rec.finish();
        }
    }

    private void handleAsync() {
        if (this.equals(RpcContext.getContext().getRpcInvoke()) && RpcContext.getContext().getFuture() == null) {
            Throwable ex = null;
            DefaultFutureAdapter dfa = null;
            try {
                dfa = new DefaultFutureAdapter(this.helper.getInputStream());
            }
            catch (Throwable e) {
                ex = e;
            }
            RpcContext.getContext().setFuture(dfa);
            final ResponseCallback c = RpcContext.getContext().getCallback();
            if (c != null) {
                final InvokeResult fir = dfa.getIr();
                final Throwable fex = fir != null && fir.type == 1 ? (Throwable)fir.value : ex;
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        if (fex == null) {
                            c.done(fir.value);
                        } else {
                            c.caught(fex);
                        }
                    }
                };
                es.submit(r);
            }
        }
    }

    public class DefaultFutureAdapter<V>
    implements Future<V> {
        private InvokeResult ir = null;

        public DefaultFutureAdapter(InputStream helperIn) {
            try {
                this.ir = RPCInvoke.this._finishInvoke(helperIn);
            }
            catch (Throwable t) {
                throw RPCException.createIt(t);
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.ir != null;
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            try {
                return (V)this.ir.value;
            }
            catch (Throwable t) {
                throw RPCException.createIt(t);
            }
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
            try {
                return (V)this.ir.value;
            }
            catch (Throwable t) {
                throw RPCException.createIt(t);
            }
        }

        public InvokeResult getIr() {
            return this.ir;
        }
    }

    private static class Invoke {
        InvokeRecord rec = null;
        InvokeRecord old = null;
        InvokeMonitor[] invokeMonitors;
        Connector cn;
        InvokeRecord.Detail detail = null;

        Invoke(Connector cn, String url, int command) {
            this.cn = cn;
            this.invokeMonitors = RPCConfig.invokeMonitors;
            if (this.invokeMonitors.length > 0) {
                this.rec = InvokeRecord.createClient(command, url);
                if (this.rec != null) {
                    this.rec.startRequestTime = System.currentTimeMillis();
                    this.detail = this.rec.detail;
                }
            }
            this.old = InvokeRecord.setCurrent(this.rec);
        }

        Invoke(Connector cn, int command) {
            this(cn, cn.url, command);
        }

        Invoke(String url, int command) {
            this(null, url, command);
        }

        void setError(Object err) {
            if (this.rec != null) {
                this.rec.err = err;
            }
        }

        void finish() {
            if (invokeCount == null) {
                invokeCount = PerformanceManager.getCounterValue("Client.invokeCount");
            }
            invokeCount.append();
            InvokeRecord.setCurrent(this.old);
            if (this.rec != null) {
                this.rec.finishInvoke();
                for (int i = 0; i < this.invokeMonitors.length; ++i) {
                    if (!this.invokeMonitors[i].recordClient()) continue;
                    this.invokeMonitors[i].invokePerformed(this.rec);
                }
            }
        }

        void close(InvokeHelper helper) {
            ConnectionMonitor monitor;
            IOUtil.close(helper);
            if (this.cn != null && (monitor = ServerManager.getConfig().connectionMonitor) != null) {
                monitor.afterInvoke(this.cn, helper);
            }
        }
    }
}

