/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.impl;

import com.kingdee.bos.rpc.io.server.ServerManager;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;

public class RPCMonitor
extends Thread {
    private static final Logger logger = Logger.getLogger(RPCMonitor.class);
    private boolean isDeath = false;
    private static RPCMonitor _monitor = new RPCMonitor();
    private static Object monitor = new Object();
    private static WeakHashMap workers = new WeakHashMap();

    private RPCMonitor() {
        super("RPCMonitor");
        this.setDaemon(true);
    }

    public static void addMonitor(Runnable worker) {
        RPCMonitor.addMonitor(worker, 0L, false);
    }

    public static void addMonitor(Runnable worker, long intervalTime) {
        RPCMonitor.addMonitor(worker, intervalTime, false);
    }

    public static void addWeakMonitor(Runnable worker) {
        RPCMonitor.addMonitor(worker, 0L, true);
    }

    public static void addWeakMonitor(Runnable worker, long intervalTime) {
        RPCMonitor.addMonitor(worker, intervalTime, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addMonitor(Runnable worker, long intervalTime, boolean weak) {
        Object object = monitor;
        synchronized (object) {
            if (RPCMonitor._monitor.isDeath) {
                _monitor = new RPCMonitor();
                if (workers != null) {
                    workers.clear();
                }
                workers = new WeakHashMap();
            }
            if (!_monitor.isAlive()) {
                _monitor.start();
            }
        }
        object = workers;
        synchronized (object) {
            workers.put(worker, new MonitorWorker(worker, intervalTime, weak));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMonitor(Runnable worker) {
        WeakHashMap weakHashMap = workers;
        synchronized (weakHashMap) {
            workers.remove(worker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                block9: while (true) {
                    Object[] ar;
                    Thread.sleep(ServerManager.getConfig().monitorIntervalTime);
                    WeakHashMap weakHashMap = workers;
                    synchronized (weakHashMap) {
                        ar = workers.values().toArray();
                    }
                    int i = 0;
                    while (true) {
                        if (i >= ar.length) continue block9;
                        try {
                            ((MonitorWorker)ar[i]).checkWork(System.currentTimeMillis());
                        }
                        catch (Throwable e) {
                            logger.debug((Object)e, e);
                        }
                        ++i;
                    }
                    break;
                }
            }
            catch (InterruptedException _) {
                logger.debug((Object)"", (Throwable)_);
                this.isDeath = true;
            }
        }
        catch (Throwable throwable) {
            this.isDeath = true;
            throw throwable;
        }
    }

    private static class MonitorWorker {
        Object worker;
        long intervalTime;
        long lastTime = System.currentTimeMillis();

        MonitorWorker(Runnable worker, long intervalTime, boolean weak) {
            this.worker = weak ? new WeakReference<Runnable>(worker) : worker;
            this.intervalTime = intervalTime;
        }

        Runnable getWorker() {
            if (this.worker instanceof WeakReference) {
                return (Runnable)((WeakReference)this.worker).get();
            }
            return (Runnable)this.worker;
        }

        void checkWork(long currentTime) {
            if (currentTime - this.lastTime >= this.intervalTime) {
                this.lastTime = currentTime;
                Runnable worker = this.getWorker();
                if (worker != null) {
                    worker.run();
                }
            }
        }
    }
}

