/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.impl;

import com.kingdee.bos.rpc.analysis.AnalysisResult;
import com.kingdee.bos.rpc.impl.InvokeResult;
import com.kingdee.bos.rpc.impl.RPCResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class RPCRequest
implements Serializable {
    private static final long serialVersionUID = -609153437886154759L;
    public long startTime;
    public long endTime;
    public String className;
    public Class model;
    public Class[] argTypes;
    public Object[] args;
    public int rpcCommand;
    public int methodCode;
    public String methodName;
    public Class[] methodArgTypes;
    public Object[] methodArgs;
    public transient RPCResult rpcResult;
    public byte[] methodRequestData;
    public transient ByteArrayOutputStream baos = new ByteArrayOutputStream();
    public transient String threadName;
    public transient EventInfo eventInfo;
    public RPCRequest next;
    public RPCRequest parent;

    public RPCRequest() {
        this.startTime = System.currentTimeMillis();
    }

    public boolean isParent() {
        return this.parent == null;
    }

    public boolean isChild() {
        return this.parent != null;
    }

    public void finished(InvokeResult invokeResult) {
        this.finished(invokeResult, null);
    }

    public void finished(InvokeResult invokeResult, AnalysisResult analysisResult) {
        if (this.methodRequestData == null) {
            try {
                this.baos.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.methodRequestData = this.baos.toByteArray();
            this.baos = null;
        }
        this.endTime = System.currentTimeMillis();
        this.rpcResult = new RPCResult(this.startTime, this.endTime, invokeResult.type == 1, invokeResult.type == 1 ? (Throwable)invokeResult.value : null, invokeResult.value);
        this.rpcResult.analysisResult = analysisResult;
    }

    public RPCRequest cloneDebugOne() {
        RPCRequest another = new RPCRequest();
        another.className = this.className;
        another.model = this.model;
        another.args = this.args;
        another.argTypes = this.argTypes;
        another.methodArgs = this.methodArgs;
        another.methodArgTypes = this.methodArgTypes;
        another.methodCode = this.methodCode;
        another.methodName = this.methodName;
        another.rpcCommand = this.rpcCommand;
        another.methodRequestData = this.methodRequestData;
        another.threadName = "Copy of " + this.threadName;
        if (this.eventInfo != null) {
            another.eventInfo = this.eventInfo.cloneDebugOne();
        }
        RPCRequest last = this;
        while (last.next != null) {
            last = last.next;
        }
        last.next = another;
        another.parent = this.parent != null ? this.parent : this;
        return another;
    }

    public static class EventInfo
    implements Serializable {
        public final String type;
        public final int id;

        public EventInfo(String type, int id) {
            this.type = type;
            this.id = id;
        }

        public EventInfo cloneDebugOne() {
            return new EventInfo("Child", 0);
        }
    }
}

