/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.impl;

import com.kingdee.bos.rpc.InvokeIntercepter;
import com.kingdee.bos.rpc.ObjectMarshaler;
import com.kingdee.bos.rpc.RPCConfig;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.RPCServerSession;
import com.kingdee.bos.rpc.analysis.Analyser;
import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.impl.InvokeMode;
import com.kingdee.bos.rpc.impl.InvokeResult;
import com.kingdee.bos.rpc.impl.ObjectProxy;
import com.kingdee.bos.rpc.impl.ServerSessionImpl;
import com.kingdee.bos.rpc.io.ConnectionBase;
import com.kingdee.bos.rpc.io.InvokeHelper;
import com.kingdee.bos.rpc.io.RPCIOException;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.NIOServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.io.server.TCPServer;
import com.kingdee.bos.rpc.performance.IntValue;
import com.kingdee.bos.rpc.performance.InvokeMonitor;
import com.kingdee.bos.rpc.performance.InvokeRecord;
import com.kingdee.bos.rpc.performance.MaxIntValue;
import com.kingdee.bos.rpc.performance.PerformanceManager;
import com.kingdee.bos.rpc.transaction.TransactionInfo;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class RPCService {
    private static final Logger logger = Logger.getLogger(RPCService.class);
    public static final ThreadLocal inServiceInvoke = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ServerSessionImpl createSession(IServer server, String clientIp) {
        Map sessions;
        ServerSessionImpl session = new ServerSessionImpl(server, clientIp);
        Map map = sessions = server.getSessions();
        synchronized (map) {
            sessions.put(session.getSessionId(), session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeSession(long sessionId, IServer server) {
        Map sessions;
        ServerSessionImpl session = null;
        Map map = sessions = server.getSessions();
        synchronized (map) {
            session = (ServerSessionImpl)sessions.remove(sessionId);
        }
        if (session != null) {
            session.close();
        }
    }

    static ServerSessionImpl getSession(long sessionId, IServer server) {
        return (ServerSessionImpl)server.getSessions().get(sessionId);
    }

    private static ServerSessionImpl getSession(long sessionId, InvokeRecord rec, IServer server) {
        ServerSessionImpl session;
        if (rec != null && rec.detail != null) {
            ((InvokeRecord.SessionDetail)rec.detail).sessionId = sessionId;
        }
        if ((session = RPCService.getSession(sessionId, server)) != null) {
            session.enterService();
            RPCServerSession.setCurrentSession(session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void service(InvokeHelper helper) {
        InvokeMonitor[] invokeMonitors = RPCConfig.invokeMonitors;
        RPCServerSession oldSession = RPCServerSession.setCurrentSession(null);
        InvokeRecord rec = InvokeRecord.createServer(helper.getConnection().getConnectionUrl());
        InvokeRecord oldRec = InvokeRecord.setCurrent(rec);
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(RPCService.class.getClassLoader());
            DataInputStream in = new DataInputStream(helper.getInputStream());
            DataOutputStream out = new DataOutputStream(helper.getOutputStream());
            IServer server = ((ConnectionBase)helper.getConnection()).getServer();
            ServerManager.setCurrentServer(server.getServerName());
            RPCService.requestStart(rec);
            byte command = in.readByte();
            if (rec != null) {
                rec.setCommand(command);
            }
            switch (command) {
                case 1: {
                    RPCService.serviceCreateSession(in, out, rec, server, helper);
                    break;
                }
                case 2: {
                    RPCService.serviceCloseSession(in, out, rec, server);
                    break;
                }
                case 7: {
                    RPCService.serviceKeepAlive(in, out, rec, server);
                    break;
                }
                case 3: {
                    RPCService.serviceCreateObject(in, out, rec, server);
                    break;
                }
                case 4: {
                    RPCService.serviceReleaseObject(in, out, rec, server);
                    break;
                }
                case 20: {
                    long t1 = System.currentTimeMillis();
                    RPCService.serviceCreateObjectAndInvoke(in, out, rec, server);
                    t1 = System.currentTimeMillis() - t1;
                    IntValue intValue = PerformanceManager.getIntValue("RPC.Invoke.AccumulatedCount");
                    intValue.append(1);
                    intValue = PerformanceManager.getIntValue("RPC.Invoke.AccumulatedTime");
                    intValue.append((int)t1);
                    MaxIntValue maxIntValue = PerformanceManager.getMaxIntValue("RPC.Invoke.MaxTime");
                    maxIntValue.append((int)t1);
                    break;
                }
                case 0: {
                    long t1 = System.currentTimeMillis();
                    RPCService.serviceInvoke(in, out, rec, server);
                    t1 = System.currentTimeMillis() - t1;
                    IntValue intValue = PerformanceManager.getIntValue("RPC.Invoke.AccumulatedCount");
                    intValue.append(1);
                    intValue = PerformanceManager.getIntValue("RPC.Invoke.AccumulatedTime");
                    intValue.append((int)t1);
                    MaxIntValue maxIntValue = PerformanceManager.getMaxIntValue("RPC.Invoke.MaxTime");
                    maxIntValue.append((int)t1);
                    break;
                }
                case 5: {
                    RPCService.serviceGetError(in, out, rec, server);
                    break;
                }
                case 6: {
                    RPCService.serviceGetModel(in, out, rec, server);
                    break;
                }
                case 9: {
                    RPCService.servicePing(in, out, rec);
                    break;
                }
                default: {
                    throw new RPCIOException(2002, "unknown command '" + command + "'");
                }
            }
            IOUtil.close(out);
            IOUtil.close(in);
        }
        catch (Throwable e) {
            if (rec != null) {
                rec.err = e;
                logger.error((Object)"rpcinvoke err stack : ", e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldcl);
        }
        IOUtil.close(helper);
        try {
            InvokeRecord.setCurrent(oldRec);
            if (rec != null) {
                rec.finishInvoke();
                for (int i = 0; i < invokeMonitors.length; ++i) {
                    if (!invokeMonitors[i].recordServer()) continue;
                    invokeMonitors[i].invokePerformed(rec);
                }
                RPCService.responseFinish(rec);
            }
        }
        catch (Throwable e) {
            logger.error((Object)("perform err invokerecord : " + rec));
            logger.error((Object)e, e);
        }
        ServerSessionImpl session = (ServerSessionImpl)RPCServerSession.setCurrentSession(oldSession);
        if (session != null) {
            session.leaveService();
        }
        ServerManager.setCurrentServer(null);
    }

    private static void serviceCreateSession(DataInputStream in, DataOutputStream out, InvokeRecord rec, IServer server, InvokeHelper helper) throws Throwable {
        ServerSessionImpl session = null;
        if (rec != null) {
            rec.finishRequestTime = System.currentTimeMillis();
        }
        try {
            short length = in.readShort();
            byte[] b = new byte[length];
            in.readFully(b);
            RPCService.requestFinish(rec);
            session = RPCService.createSession(server, new String(b));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("clientIp : " + session.getClientIp()));
            }
            length = in.readShort();
            b = new byte[length];
            in.readFully(b);
            Properties prop = helper.getConnection().getConnectionProps();
            if (prop != null) {
                session.setServerIp(prop.getProperty("serverIp"));
            }
            if (rec != null) {
                ((InvokeRecord.SessionDetail)rec.detail).sessionId = session.getSessionId();
            }
        }
        catch (Throwable e) {
            if (rec != null) {
                rec.startResponseTime = System.currentTimeMillis();
                rec.err = e;
            }
            RPCService.responseStart(rec);
            out.writeLong(-1L);
            ObjectOutputStream out1 = new ObjectOutputStream(out);
            out1.writeObject(e);
            out1.flush();
            return;
        }
        try {
            if (rec != null) {
                ((InvokeRecord.CreateSession)rec.detail).sessionId = session.getSessionId();
                rec.startResponseTime = System.currentTimeMillis();
            }
            RPCService.responseStart(rec);
            out.writeLong(session.getSessionId());
        }
        catch (Throwable e) {
            if (rec != null) {
                rec.err = e;
            }
            RPCService.closeSession(session.getSessionId(), server);
            throw e;
        }
    }

    private static void serviceCloseSession(DataInputStream in, DataOutputStream out, InvokeRecord rec, IServer server) throws Throwable {
        int i;
        int count = in.readInt();
        long[] sessions = new long[count];
        if (rec != null) {
            ((InvokeRecord.CloseSession)rec.detail).sessions = sessions;
        }
        for (i = 0; i < count; ++i) {
            long sessionId;
            sessions[i] = sessionId = in.readLong();
        }
        if (rec != null) {
            rec.finishRequestTime = System.currentTimeMillis();
        }
        RPCService.requestFinish(rec);
        for (i = 0; i < count; ++i) {
            try {
                RPCService.closeSession(sessions[i], server);
                continue;
            }
            catch (Throwable _) {
                // empty catch block
            }
        }
        if (rec != null) {
            rec.startResponseTime = System.currentTimeMillis();
        }
        RPCService.responseStart(rec);
    }

    private static void serviceKeepAlive(DataInputStream in, DataOutputStream out, InvokeRecord rec, IServer server) throws Throwable {
        long sessionId = in.readLong();
        if (rec != null) {
            rec.finishRequestTime = System.currentTimeMillis();
        }
        RPCService.requestFinish(rec);
        ServerSessionImpl session = RPCService.getSession(sessionId, rec, server);
        if (ServerManager.getConfig().logSessionKeepAlive) {
            if (session == null) {
                logger.info((Object)("ServerSession#" + sessionId + " keep alive, but not exists."));
            } else {
                logger.info((Object)(session.toString() + " keep alive."));
            }
        }
        if (rec != null) {
            rec.startResponseTime = System.currentTimeMillis();
        }
        RPCService.responseStart(rec);
        InvokeIntercepter[] invokeIntercepters = RPCConfig.invokeIntercepters;
        if (invokeIntercepters.length > 0) {
            for (int i = 0; i < invokeIntercepters.length; ++i) {
                invokeIntercepters[i].serviceKeepAlive(session, new ObjectOutputStream(out));
            }
        }
    }

    static RPCException sessionNotFound(long sessionId) {
        return new RPCException(1002, "Session#" + sessionId + " not found.");
    }

    private static void serviceCreateObject(DataInputStream in, DataOutputStream out, InvokeRecord rec, IServer server) throws Throwable {
        long ref;
        InvokeRecord.CreateObject detail = rec == null ? null : (InvokeRecord.CreateObject)rec.detail;
        long sessionId = in.readLong();
        RPCService.requestFinish(rec);
        ServerSessionImpl session = RPCService.getSession(sessionId, rec, server);
        if (session == null) {
            if (rec != null) {
                rec.finishRequestTime = rec.startResponseTime = System.currentTimeMillis();
            }
            RPCService.responseStart(rec);
            ObjectOutputStream out1 = new ObjectOutputStream(out);
            out1.writeByte(1);
            out1.writeObject(RPCService.sessionNotFound(sessionId));
            out1.flush();
            return;
        }
        RPCServerSession.setCurrentSession(session);
        TransactionInfo tinfo = new TransactionInfo(null, null);
        TransactionInfo.read(in, tinfo);
        if (detail != null) {
            detail.transactionName = tinfo.name;
            detail.transactionId = tinfo.id;
            detail.user = tinfo.user;
        }
        ObjectInput in1 = session.createInputStream(in);
        try {
            Object[] args;
            String name = (String)in1.readObject();
            Class model = (Class)in1.readObject();
            Class[] argTypes = (Class[])in1.readObject();
            if (argTypes == null) {
                argTypes = new Class[]{};
            }
            if ((args = (Object[])in1.readObject()) == null) {
                args = new Object[]{};
            }
            if (rec != null) {
                rec.finishRequestTime = System.currentTimeMillis();
                detail.name = name;
                detail.model = model;
                detail.argTypes = argTypes;
                detail.args = args;
            }
            ObjectProxy proxy = session.createObjectProxy(name, model, argTypes, args);
            ref = proxy.getRef();
            if (detail != null) {
                detail.objectId = ref;
            }
        }
        catch (Throwable e) {
            if (rec != null) {
                rec.startResponseTime = System.currentTimeMillis();
                rec.err = e;
            }
            RPCService.responseStart(rec);
            ObjectOutputStream out1 = new ObjectOutputStream(out);
            out1.writeByte(1);
            out1.writeObject(e);
            out1.flush();
            return;
        }
        if (rec != null) {
            rec.startResponseTime = System.currentTimeMillis();
        }
        RPCService.responseStart(rec);
        ObjectOutputStream out1 = new ObjectOutputStream(out);
        out1.writeByte(0);
        out1.writeLong(ref);
        out1.flush();
    }

    private static void serviceReleaseObject(DataInputStream in, DataOutputStream out, InvokeRecord rec, IServer server) throws Throwable {
        InvokeRecord.ReleaseObject detail = rec == null ? null : (InvokeRecord.ReleaseObject)rec.detail;
        long sessionId = in.readLong();
        if (detail != null) {
            detail.sessionId = sessionId;
        }
        int count = in.readInt();
        long[] refs = new long[count];
        for (int i = 0; i < count; ++i) {
            long ref;
            refs[i] = ref = in.readLong();
        }
        if (rec != null) {
            rec.finishRequestTime = System.currentTimeMillis();
            detail.objectIds = refs;
        }
        RPCService.requestFinish(rec);
        ServerSessionImpl session = RPCService.getSession(sessionId, rec, server);
        if (session != null) {
            RPCServerSession.setCurrentSession(session);
            for (int i = 0; i < count; ++i) {
                session.releaseObjectProxy(refs[i]);
            }
        }
        if (rec != null) {
            rec.startResponseTime = System.currentTimeMillis();
        }
        RPCService.responseStart(rec);
        if (ServerManager.getConfig().logObjectRelease) {
            StringBuffer sb = new StringBuffer();
            sb.append("ObjectProxy released ");
            for (int i = 0; i < refs.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("#" + refs[i]);
            }
            logger.info((Object)sb.toString());
        }
    }

    private static void servicePing(DataInputStream in, DataOutputStream out, InvokeRecord rec) throws Throwable {
        InvokeRecord.Ping detail = rec == null ? null : (InvokeRecord.Ping)rec.detail;
        byte[] request = null;
        int len = in.readInt();
        if (len > 0) {
            request = new byte[len];
            in.readFully(request);
        }
        if (rec != null) {
            rec.finishRequestTime = System.currentTimeMillis();
            detail.request = request;
        }
        RPCService.requestFinish(rec);
        byte[] response = request;
        if (rec != null) {
            rec.startResponseTime = System.currentTimeMillis();
            detail.response = response;
        }
        RPCService.responseStart(rec);
        if (response == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(response.length);
            out.write(response);
        }
    }

    private static RPCException objectNotFound(long sessionId, long ref) {
        return new RPCException(1003, "Object(session#" + sessionId + ", ref=" + ref + ") not found.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void serviceCreateObjectAndInvoke(DataInputStream in, DataOutputStream out, InvokeRecord rec, IServer server) throws Throwable {
        InvokeResult r;
        ObjectProxy proxy;
        int invokeId;
        ObjectOutput out1;
        ServerSessionImpl session;
        block43: {
            long ref;
            if (ProfileConfig.getInstance().logRPCInvoke) {
                ThreadProfileContext.getInstance().enter(RPCService.class.getName(), "serviceCreateObjectInvoke", null);
            }
            InvokeRecord.MethodInvoke detail = rec == null ? null : (InvokeRecord.MethodInvoke)rec.detail;
            long sessionId = in.readLong();
            RPCService.requestFinish(rec);
            session = RPCService.getSession(sessionId, rec, server);
            if (session == null) {
                if (rec != null) {
                    rec.finishRequestTime = rec.startResponseTime = System.currentTimeMillis();
                }
                RPCService.responseStart(rec);
                ObjectOutput out12 = new ObjectOutputStream(out);
                ObjectMarshaler objectMarshaler = ServerManager.getConfig().objectMarshaler;
                if (objectMarshaler != null) {
                    out12 = objectMarshaler.createOutput(out12);
                }
                out12.writeByte(1);
                out12.writeObject(RPCService.sessionNotFound(sessionId));
                out12.flush();
                return;
            }
            RPCServerSession.setCurrentSession(session);
            ObjectInput in1 = session.createInputStream(in);
            try {
                Object[] args;
                String name = (String)in1.readObject();
                Class model = (Class)in1.readObject();
                Class[] argTypes = (Class[])in1.readObject();
                if (argTypes == null) {
                    argTypes = new Class[]{};
                }
                if ((args = (Object[])in1.readObject()) == null) {
                    args = new Object[]{};
                }
                ObjectProxy proxy2 = session.createObjectProxy(name, model, argTypes, args);
                ref = proxy2.getRef();
            }
            catch (Throwable e) {
                if (rec != null) {
                    rec.startResponseTime = System.currentTimeMillis();
                    rec.err = e;
                }
                RPCService.responseStart(rec);
                ObjectOutput out13 = session.createOutputStream(out);
                out13.writeByte(1);
                out13.writeObject(e);
                out13.flush();
                return;
            }
            if (rec != null) {
                rec.startResponseTime = System.currentTimeMillis();
            }
            RPCService.responseStart(rec);
            out1 = session.createOutputStream(out);
            out1.writeByte(0);
            out1.writeLong(ref);
            out1.flush();
            TransactionInfo tinfo = new TransactionInfo(null, null);
            TransactionInfo.read(in, tinfo);
            invokeId = in.readInt();
            if (rec != null && detail != null) {
                detail.sessionId = sessionId;
                detail.objectId = ref;
                detail.invokeId = invokeId;
                detail.transactionName = tinfo.name;
                detail.transactionId = tinfo.id;
                detail.user = tinfo.user;
            }
            proxy = session.getObjectProxy(ref, rec);
            try {
                inServiceInvoke.set(server.getName());
                if (InvokeMode.isCloudRecording(invokeId)) {
                    RPCService.openAnalysis(true);
                } else if (InvokeMode.isRecordingInvoke(invokeId)) {
                    RPCService.openAnalysis(false);
                }
                if (-10 == invokeId) {
                    ObjectInput oi = session.createInputStream(in);
                    byte[] bytes = (byte[])oi.readObject();
                    in = new DataInputStream(new ByteArrayInputStream(bytes));
                    r = proxy.processInvoke(new ObjectInputStream(in), rec);
                } else {
                    r = proxy.processInvoke(session.createInputStream(in), rec);
                }
                inServiceInvoke.set(null);
            }
            catch (Throwable e) {
                try {
                    if (rec != null) {
                        rec.startResponseTime = System.currentTimeMillis();
                        if (rec.finishRequestTime == 0L) {
                            rec.finishRequestTime = rec.startResponseTime;
                        }
                        rec.err = e;
                    }
                    RPCService.responseStart(rec);
                    boolean isOutofmemory = false;
                    int times = 0;
                    for (Throwable t = e; t != null && times++ < 10; t = t.getCause()) {
                        if (!(t instanceof OutOfMemoryError)) continue;
                        isOutofmemory = true;
                        break;
                    }
                    if (isOutofmemory) {
                        logger.error((Object)e, e);
                        IServer[] s = ServerManager.listServers();
                        for (int i = 0; i < s.length; ++i) {
                            IServer is = s[i];
                            if (!(is instanceof TCPServer) && !(is instanceof NIOServer)) continue;
                        }
                    }
                    if (e instanceof RPCIOException) {
                        throw e;
                    }
                    out1.writeByte(1);
                    out1.writeObject(e);
                    out1.flush();
                    if (!ProfileConfig.getInstance().logRPCInvoke) return;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    inServiceInvoke.set(null);
                }
                ThreadProfileContext.getInstance().exit();
                return;
            }
            if (rec == null) break block43;
            rec.startResponseTime = System.currentTimeMillis();
        }
        if (rec != null) {
            if (r.type == 1) {
                rec.err = r.value;
            } else {
                detail.result = r.value;
            }
        }
        RPCService.responseStart(rec);
        ServerSessionImpl.setInvokeResult(r, out1);
        out1.writeByte(r.type);
        try {
            InvokeIntercepter[] invokeIntercepters;
            out1.writeObject(r.value);
            if (InvokeMode.isRecordingInvoke(invokeId) || InvokeMode.isCloudRecording(invokeId)) {
                out1.writeObject(RPCService.endAnalysis());
            }
            if ((invokeIntercepters = RPCConfig.invokeIntercepters).length > 0) {
                for (int i = 0; i < invokeIntercepters.length; ++i) {
                    invokeIntercepters[i].serviceInvoke(session, out1);
                }
            }
            out1.flush();
            IOUtil.close(out1);
            return;
        }
        catch (Throwable e) {
            if (rec != null) {
                rec.err = e;
            }
            if (e instanceof RPCIOException) {
                throw e;
            }
            proxy.setError(invokeId, e);
            if (!ProfileConfig.getInstance().logRPCInvoke) return;
            ThreadProfileContext.getInstance().exit();
            return;
        }
        finally {
            if (ProfileConfig.getInstance().logRPCInvoke) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void serviceInvoke(DataInputStream in, DataOutputStream out, InvokeRecord rec, IServer server) throws Throwable {
        InvokeResult r;
        ObjectOutput out1;
        ObjectProxy proxy;
        ServerSessionImpl session;
        int invokeId;
        block44: {
            if (ProfileConfig.getInstance().logRPCInvoke) {
                ThreadProfileContext.getInstance().enter(RPCService.class.getName(), "serviceInvoke", null);
            }
            InvokeRecord.MethodInvoke detail = rec == null ? null : (InvokeRecord.MethodInvoke)rec.detail;
            long sessionId = in.readLong();
            long ref = in.readLong();
            TransactionInfo tinfo = new TransactionInfo(null, null);
            TransactionInfo.read(in, tinfo);
            invokeId = in.readInt();
            if (rec != null) {
                detail.sessionId = sessionId;
                detail.objectId = ref;
                detail.invokeId = invokeId;
                detail.transactionName = tinfo.name;
                detail.transactionId = tinfo.id;
                detail.user = tinfo.user;
            }
            if ((session = RPCService.getSession(sessionId, rec, server)) == null) {
                RPCException err = RPCService.sessionNotFound(sessionId);
                if (rec != null) {
                    rec.finishRequestTime = rec.startResponseTime = System.currentTimeMillis();
                    rec.err = err;
                }
                RPCService.requestFinish(rec);
                RPCService.responseStart(rec);
                ObjectOutput out12 = new ObjectOutputStream(out);
                ObjectMarshaler objectMarshaler = ServerManager.getConfig().objectMarshaler;
                if (objectMarshaler != null) {
                    out12 = objectMarshaler.createOutput(out12);
                }
                out12.writeByte(1);
                out12.writeObject(err);
                out12.flush();
                return;
            }
            RPCServerSession.setCurrentSession(session);
            proxy = session.getObjectProxy(ref, rec);
            if (proxy == null) {
                if (rec != null) {
                    rec.finishRequestTime = rec.startResponseTime = System.currentTimeMillis();
                }
                RPCService.requestFinish(rec);
                RPCService.responseStart(rec);
                ObjectOutput out13 = new ObjectOutputStream(out);
                ObjectMarshaler objectMarshaler = ServerManager.getConfig().objectMarshaler;
                if (objectMarshaler != null) {
                    out13 = objectMarshaler.createOutput(out13);
                }
                out13.writeByte(1);
                RPCException err = RPCService.objectNotFound(sessionId, ref);
                if (rec != null) {
                    rec.err = rec;
                }
                out13.writeObject(err);
                out13.flush();
                return;
            }
            out1 = null;
            try {
                inServiceInvoke.set(server.getName());
                if (InvokeMode.isCloudRecording(invokeId)) {
                    RPCService.openAnalysis(true);
                } else if (InvokeMode.isRecordingInvoke(invokeId)) {
                    RPCService.openAnalysis(false);
                }
                if (-10 == invokeId) {
                    ObjectInput oi = session.createInputStream(in);
                    byte[] bytes = (byte[])oi.readObject();
                    in = new DataInputStream(new ByteArrayInputStream(bytes));
                    r = proxy.processInvoke(new ObjectInputStream(in), rec);
                } else {
                    r = proxy.processInvoke(session.createInputStream(in), rec);
                }
                inServiceInvoke.set(null);
            }
            catch (Throwable e) {
                try {
                    if (rec != null) {
                        rec.startResponseTime = System.currentTimeMillis();
                        if (rec.finishRequestTime == 0L) {
                            rec.finishRequestTime = rec.startResponseTime;
                        }
                        rec.err = e;
                    }
                    RPCService.responseStart(rec);
                    boolean isOutofmemory = false;
                    int times = 0;
                    for (Throwable t = e; t != null && times++ < 10; t = t.getCause()) {
                        if (!(t instanceof OutOfMemoryError)) continue;
                        isOutofmemory = true;
                        break;
                    }
                    if (isOutofmemory) {
                        logger.error((Object)e, e);
                        IServer[] s = ServerManager.listServers();
                        for (int i = 0; i < s.length; ++i) {
                            IServer is = s[i];
                            if (!(is instanceof TCPServer) && !(is instanceof NIOServer)) continue;
                        }
                    }
                    if (e instanceof RPCIOException) {
                        throw e;
                    }
                    out1 = session.createOutputStream(out);
                    out1.writeByte(1);
                    out1.writeObject(e);
                    if (InvokeMode.isRecordingInvoke(invokeId) || InvokeMode.isCloudRecording(invokeId)) {
                        out1.writeObject(RPCService.endAnalysis());
                    }
                    out1.flush();
                    if (!ProfileConfig.getInstance().logRPCInvoke) return;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    inServiceInvoke.set(null);
                }
                ThreadProfileContext.getInstance().exit();
                return;
            }
            if (rec == null) break block44;
            rec.startResponseTime = System.currentTimeMillis();
        }
        if (rec != null) {
            if (r.type == 1) {
                rec.err = r.value;
            } else {
                detail.result = r.value;
            }
        }
        RPCService.responseStart(rec);
        out1 = session.createOutputStream(out);
        ServerSessionImpl.setInvokeResult(r, out1);
        out1.writeByte(r.type);
        try {
            InvokeIntercepter[] invokeIntercepters;
            out1.writeObject(r.value);
            if ((InvokeMode.isRecordingInvoke(invokeId) || InvokeMode.isCloudRecording(invokeId)) && r.type != 1) {
                out1.writeObject(RPCService.endAnalysis());
            }
            if ((invokeIntercepters = RPCConfig.invokeIntercepters).length > 0) {
                for (int i = 0; i < invokeIntercepters.length; ++i) {
                    invokeIntercepters[i].serviceInvoke(session, out1);
                }
            }
            out1.flush();
            IOUtil.close(out1);
            return;
        }
        catch (Throwable e) {
            if (rec != null) {
                rec.err = e;
            }
            if (e instanceof RPCIOException) {
                throw e;
            }
            proxy.setError(invokeId, e);
            if (!ProfileConfig.getInstance().logRPCInvoke) return;
            ThreadProfileContext.getInstance().exit();
            return;
        }
        finally {
            if (ProfileConfig.getInstance().logRPCInvoke) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    private static void serviceGetError(DataInputStream in, DataOutputStream out, InvokeRecord rec, IServer server) throws Throwable {
        InvokeRecord.GetError detail = rec == null ? null : (InvokeRecord.GetError)rec.detail;
        long sessionId = in.readLong();
        long ref = in.readLong();
        int invokeId = in.readInt();
        if (rec != null) {
            detail.sessionId = sessionId;
            detail.objectId = ref;
            detail.invokeId = invokeId;
            rec.startResponseTime = rec.finishRequestTime = System.currentTimeMillis();
        }
        RPCService.requestFinish(rec);
        RPCService.responseStart(rec);
        ObjectOutputStream out1 = new ObjectOutputStream(out);
        Throwable err = null;
        ServerSessionImpl session = RPCService.getSession(sessionId, rec, server);
        if (session != null) {
            RPCServerSession.setCurrentSession(session);
            ObjectProxy proxy = session.getObjectProxy(ref, rec);
            if (proxy != null) {
                err = proxy.getError(invokeId);
            }
        }
        out1.writeObject(err);
        out1.flush();
    }

    private static void serviceGetModel(DataInputStream in, DataOutputStream out, InvokeRecord rec, IServer server) throws Throwable {
        ServerSessionImpl session;
        InvokeRecord.GetModel detail = rec == null ? null : (InvokeRecord.GetModel)rec.detail;
        long sessionId = in.readLong();
        long ref = in.readLong();
        if (detail != null) {
            detail.sessionId = sessionId;
            detail.objectId = ref;
        }
        if ((session = RPCService.getSession(sessionId, rec, server)) == null) {
            RPCException err = RPCService.sessionNotFound(sessionId);
            if (rec != null) {
                rec.err = err;
                rec.finishRequestTime = rec.startResponseTime = System.currentTimeMillis();
            }
            RPCService.requestFinish(rec);
            RPCService.responseStart(rec);
            ObjectOutputStream out1 = new ObjectOutputStream(out);
            out1.writeByte(1);
            out1.writeObject(err);
            out1.flush();
            return;
        }
        RPCServerSession.setCurrentSession(session);
        ObjectInput in1 = session.createInputStream(in);
        Class model = (Class)in1.readObject();
        if (rec != null) {
            detail.model = model;
            rec.finishRequestTime = System.currentTimeMillis();
        }
        RPCService.requestFinish(rec);
        ObjectProxy proxy = session.getObjectProxy(ref, rec);
        if (proxy == null) {
            RPCException err = RPCService.objectNotFound(sessionId, ref);
            if (rec != null) {
                rec.err = err;
                rec.startResponseTime = System.currentTimeMillis();
            }
            RPCService.responseStart(rec);
            ObjectOutputStream out1 = new ObjectOutputStream(out);
            out1.writeByte(1);
            out1.writeObject(err);
            out1.flush();
            return;
        }
        Throwable err = null;
        try {
            proxy = session.createObjectProxy(proxy.getObject(), model);
            if (rec != null) {
                detail.newObjectId = proxy.getRef();
            }
        }
        catch (Throwable e) {
            if (rec != null) {
                rec.err = e;
            }
            err = e;
        }
        if (rec != null) {
            rec.startResponseTime = System.currentTimeMillis();
        }
        RPCService.responseStart(rec);
        ObjectOutput out1 = session.createOutputStream(out);
        if (err == null) {
            out1.writeByte(0);
            out1.writeLong(proxy.getRef());
        } else {
            out1.writeByte(1);
            out1.writeObject(err);
        }
        out1.flush();
    }

    private static void requestStart(InvokeRecord rec) {
        for (int i = 0; i < RPCConfig.invokeListeners.length; ++i) {
            RPCConfig.invokeListeners[i].requestStart(rec);
        }
    }

    private static void requestFinish(InvokeRecord rec) {
        for (int i = 0; i < RPCConfig.invokeListeners.length; ++i) {
            RPCConfig.invokeListeners[i].requestFinish(rec);
        }
    }

    private static void responseStart(InvokeRecord rec) {
        for (int i = 0; i < RPCConfig.invokeListeners.length; ++i) {
            RPCConfig.invokeListeners[i].responseStart(rec);
        }
    }

    private static void responseFinish(InvokeRecord rec) {
        for (int i = 0; i < RPCConfig.invokeListeners.length; ++i) {
            RPCConfig.invokeListeners[i].responseFinish(rec);
        }
    }

    private static void openAnalysis(boolean isCloudRecording) {
        Analyser.openAnalysis(isCloudRecording);
    }

    private static Object endAnalysis() {
        return Analyser.endAnalysis();
    }
}

