/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.impl;

import com.kingdee.bos.rpc.ObjectMarshaler;
import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.RPCModel;
import com.kingdee.bos.rpc.RPCServerSession;
import com.kingdee.bos.rpc.impl.Generator;
import com.kingdee.bos.rpc.impl.IdleTimeoutMonitor;
import com.kingdee.bos.rpc.impl.InvokeResult;
import com.kingdee.bos.rpc.impl.LocalReference;
import com.kingdee.bos.rpc.impl.ObjectProxy;
import com.kingdee.bos.rpc.impl.ProxyContext;
import com.kingdee.bos.rpc.impl.RPCMonitor;
import com.kingdee.bos.rpc.impl.RPCObjectInputStream;
import com.kingdee.bos.rpc.impl.RPCService;
import com.kingdee.bos.rpc.impl.RemoteArrayReference;
import com.kingdee.bos.rpc.impl.RemoteReference;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.performance.InvokeRecord;
import com.kingdee.bos.rpc.performance.PerformanceManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ServerSessionImpl
extends RPCServerSession {
    private static final Logger logger = Logger.getLogger(ServerSessionImpl.class);
    private final HashMap proxys;
    private final HashMap objects = new HashMap();
    private final IdleTimeoutMonitor timeoutMonitor;
    private IServer server;

    ServerSessionImpl(IServer server, String clientIp) {
        super(clientIp);
        this.server = server;
        this.proxys = PerformanceManager.createHashMap("ServerSession.proxyCount");
        this.timeoutMonitor = new IdleTimeoutMonitor(ServerManager.getConfig().sessionTimeout){

            @Override
            protected void onIdleTimeout() {
                ServerSessionImpl.this.onTimeout();
            }
        };
        RPCMonitor.addMonitor(this.timeoutMonitor);
        if (ServerManager.getConfig().logSessionCreate) {
            logger.info((Object)(this.toString() + " created."));
        }
    }

    void enterService() {
        this.timeoutMonitor.enter();
    }

    void leaveService() {
        this.timeoutMonitor.leave();
    }

    void onTimeout() {
        if (!this.isClosed()) {
            if (ServerManager.getConfig().logSessionTimeout) {
                logger.info((Object)(this.toString() + " timeout."));
            }
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finalClose() throws Throwable {
        try {
            RPCMonitor.removeMonitor(this.timeoutMonitor);
            RPCService.closeSession(this.sessionId, this.server);
            HashMap hashMap = this.proxys;
            synchronized (hashMap) {
                this.proxys.clear();
                this.objects.clear();
            }
        }
        finally {
            if (ServerManager.getConfig().logSessionClose) {
                logger.info((Object)(this.toString() + " closed."));
            }
        }
    }

    ObjectProxy createObjectProxy(String name, Class model, Class[] argTypes, Object[] args) throws Exception {
        this.validate();
        Object obj = RPCEngine.createObject(name, model, argTypes, args);
        return this.createObjectProxy(obj, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseObjectProxy(long ref) {
        HashMap hashMap = this.proxys;
        synchronized (hashMap) {
            ObjectProxy proxy = (ObjectProxy)this.proxys.remove(ref);
            if (proxy != null) {
                this.objects.remove(proxy.ctx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ObjectProxy createObjectProxy(Object obj, Class model) throws Exception {
        if (obj == null) {
            return null;
        }
        if (!model.equals(RPCModel.class)) {
            obj = RPCEngine.getObjectModel(obj, model);
        }
        ProxyContext ctx = new ProxyContext(this, obj, model);
        Class cls = Generator.getProxyClass(model);
        HashMap hashMap = this.proxys;
        synchronized (hashMap) {
            if (this.objects.containsKey(ctx)) {
                return (ObjectProxy)this.objects.get(ctx);
            }
            ObjectProxy proxy = (ObjectProxy)cls.getConstructor(ProxyContext.class).newInstance(ctx);
            this.proxys.put(proxy.getRef(), proxy);
            this.objects.put(proxy.ctx, proxy);
            return proxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ObjectProxy getObjectProxy(long ref) {
        HashMap hashMap = this.proxys;
        synchronized (hashMap) {
            return (ObjectProxy)this.proxys.get(ref);
        }
    }

    ObjectProxy getObjectProxy(long ref, InvokeRecord rec) {
        if (rec != null) {
            ((InvokeRecord.ObjectDetail)rec.detail).objectId = ref;
        }
        ObjectProxy proxy = this.getObjectProxy(ref);
        return proxy;
    }

    ObjectOutput createOutputStream(OutputStream out) throws IOException {
        ObjectOutput out1 = new Output(this, out);
        ObjectMarshaler objectMarshaler = ServerManager.getConfig().objectMarshaler;
        if (objectMarshaler != null) {
            out1 = objectMarshaler.createOutput(out1);
        }
        return out1;
    }

    ObjectInput createInputStream(InputStream in) throws IOException {
        ObjectInput in1 = new Input(this, in);
        ObjectMarshaler objectMarshaler = ServerManager.getConfig().objectMarshaler;
        if (objectMarshaler != null) {
            in1 = objectMarshaler.createInput(in1);
        }
        return in1;
    }

    static void setInvokeResult(InvokeResult r, ObjectOutput out) throws IOException {
        Output output = (Output)((ObjectMarshaler.Delegater)((Object)out)).getDelegater();
        output.setInvokeResult(r);
    }

    private static Class componentType(Class type) {
        if (type.isArray()) {
            return type.getComponentType();
        }
        return type;
    }

    private static boolean isRPCModel(Class type) {
        if (!type.isInterface()) {
            return false;
        }
        if (RPCModel.class.isAssignableFrom(type)) {
            return true;
        }
        Class cls = RPCEngine.proxySpec.classIORMModel;
        return cls != null && cls.isAssignableFrom(type);
    }

    private static Class getRPCModel(Object obj) {
        Class cls = RPCEngine.proxySpec.classIORMModel;
        if (cls != null && cls.isInstance(obj)) {
            return cls;
        }
        if (obj instanceof RPCModel) {
            return RPCModel.class;
        }
        return null;
    }

    Object getRemoteObject(Object obj, Class model, HashMap map) throws Throwable {
        ProxyContext ctx;
        RemoteReference ref;
        if (obj == null) {
            return null;
        }
        if (model == null) {
            model = obj.getClass();
            if (model.isArray()) {
                Class cType = ServerSessionImpl.componentType(model);
                if (!ServerSessionImpl.isRPCModel(cType)) {
                    return obj;
                }
            } else {
                if (obj instanceof Serializable) {
                    return obj;
                }
                if (RPCEngine.proxySpec.classIORMModel != null && RPCEngine.proxySpec.classIORMModel.isAssignableFrom(model)) {
                    model = RPCEngine.proxySpec.classIORMModel;
                } else if (RPCModel.class.isAssignableFrom(model)) {
                    model = RPCModel.class;
                } else {
                    return obj;
                }
            }
        }
        if (!model.isInstance(obj)) {
            return obj;
        }
        if (model.isArray()) {
            model = model.getComponentType();
            Object[] ar = (Object[])obj;
            if (ar.length == 0) {
                return obj;
            }
            Integer key = System.identityHashCode(obj);
            if (map.containsKey(key)) {
                return map.get(key);
            }
            Object[] values = new Object[ar.length];
            RemoteArrayReference ref2 = new RemoteArrayReference(model, values);
            map.put(key, ref2);
            for (int i = 0; i < ar.length; ++i) {
                values[i] = this.getRemoteObject(ar[i], model, map);
            }
            map.put(System.identityHashCode(ref2.items), ref2.items);
            return ref2;
        }
        if (model.equals(Object.class)) {
            if (obj instanceof Serializable) {
                return obj;
            }
            model = ServerSessionImpl.getRPCModel(obj);
            if (model == null) {
                return obj;
            }
        }
        if ((ref = (RemoteReference)map.get(ctx = this.createObjectProxy((Object)obj, model).ctx)) == null) {
            ref = new RemoteReference(ctx.model, ctx.ref);
            map.put(ctx, ref);
        }
        return ref;
    }

    @Override
    public String getCounterName() {
        return "ClientSessionCount";
    }

    private static class Output
    extends ObjectOutputStream
    implements ObjectMarshaler.Delegater {
        final ServerSessionImpl session;
        private InvokeResult ir = null;
        private final HashMap map = new HashMap();

        @Override
        public Object getDelegater() {
            return this;
        }

        void setInvokeResult(InvokeResult r) {
            if (r.type == 0 && r.model != null) {
                this.ir = r;
            }
        }

        Output(ServerSessionImpl session, OutputStream out) throws IOException {
            super(out);
            this.session = session;
            this.enableReplaceObject(true);
        }

        @Override
        public void flush() throws IOException {
            this.map.clear();
            this.ir = null;
            super.flush();
        }

        @Override
        protected Object replaceObject(Object obj) throws IOException {
            if (obj == null) {
                return null;
            }
            Class model = null;
            if (this.ir != null && this.ir.value == obj) {
                model = this.ir.model;
            }
            try {
                return this.session.getRemoteObject(obj, model, this.map);
            }
            catch (Throwable e) {
                throw RPCException.createIt(e);
            }
        }
    }

    private static class Input
    extends RPCObjectInputStream
    implements ObjectMarshaler.Delegater {
        final ServerSessionImpl session;

        @Override
        public Object getDelegater() {
            return this;
        }

        Input(ServerSessionImpl session, InputStream in) throws IOException {
            super(in);
            this.session = session;
            this.enableResolveObject(true);
        }

        @Override
        protected Object resolveObject(Object obj) throws IOException {
            if (obj != null && obj instanceof LocalReference) {
                LocalReference ref = (LocalReference)obj;
                ObjectProxy proxy = this.session.getObjectProxy(ref.id);
                if (proxy == null) {
                    return null;
                }
                return proxy.getObject();
            }
            return obj;
        }
    }
}

