/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.impl;

import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.impl.RPCMonitor;
import com.kingdee.bos.rpc.impl.RPCService;
import com.kingdee.bos.rpc.io.InvokeHelper;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.performance.CounterValue;
import com.kingdee.bos.rpc.performance.IntValue;
import com.kingdee.bos.rpc.performance.PerformanceManager;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class ServiceDispatcher
implements Runnable {
    private static final Logger logger = Logger.getLogger(ServiceDispatcher.class);
    private String serverName;
    private IntValue serviceThreadCount;
    private IntValue serviceProcessingCount;
    private CounterValue serviceProcessedCount;
    private boolean running = true;
    private Runnable monitor;
    private final LinkedList queue;
    private int threadCount = 0;
    private int waitThreadCount = 0;
    private static ServiceDispatcher dispatcher;

    public void startService(InvokeHelper helper) {
        if (helper == null) {
            logger.error((Object)"null InvokeHelper", (Throwable)new NullPointerException("null InvokeHelper"));
            return;
        }
        this.addService(helper);
    }

    public ServiceDispatcher(String serverName) {
        logger.debug((Object)"RPC ServiceDispatcher start.");
        this.serverName = serverName;
        this.serviceThreadCount = PerformanceManager.getIntValue(serverName + "." + "Service.threadCount");
        this.serviceProcessingCount = PerformanceManager.getIntValue(serverName + "." + "Service.processingCount");
        this.serviceProcessedCount = PerformanceManager.getCounterValue(serverName + "." + "Service.processedCount");
        this.queue = PerformanceManager.createLinkedList(serverName + "." + "Service.waitingCount");
        for (int i = 0; i < ServerManager.getConfig().minServiceThreadCount; ++i) {
            this.startDispatchThread();
        }
        this.monitor = new Runnable(){

            @Override
            public void run() {
                ServiceDispatcher.this.checkServiceThread();
            }
        };
        RPCMonitor.addMonitor(this.monitor);
    }

    private synchronized void checkServiceThread() {
        if (this.running && this.waitThreadCount == 0 && this.threadCount < ServerManager.getConfig().maxServiceThreadCount) {
            logger.error((Object)"dispatch thread is terminated by unknown error,start a new dispatch thread again.");
            this.startDispatchThread();
        }
    }

    private synchronized void addService(InvokeHelper helper) {
        this.checkServiceThread();
        this.queue.addFirst(helper);
        this.notify();
    }

    private synchronized int getServiceThreadCount() {
        return this.threadCount;
    }

    private synchronized void enterService() {
        ++this.threadCount;
        ++this.waitThreadCount;
        this.serviceThreadCount.append(1);
    }

    private synchronized void leaveService() {
        --this.threadCount;
        this.serviceThreadCount.append(-1);
        this.notify();
    }

    private void startDispatchThread() {
        this.enterService();
        try {
            RPCEngine.startThread(this);
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
            this.leaveService();
        }
    }

    private synchronized int getQueueSize() {
        return this.queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized InvokeHelper getService() {
        try {
            InvokeHelper helper = this.getService0();
            if (helper != null) {
                this.startDispatchThread();
            }
            InvokeHelper invokeHelper = helper;
            return invokeHelper;
        }
        finally {
            --this.waitThreadCount;
        }
    }

    private InvokeHelper getService0() {
        while (this.running && (this.queue.size() == 0 || this.threadCount - this.waitThreadCount > ServerManager.getConfig().maxServiceThreadCount)) {
            if (this.queue.size() == 0 && this.waitThreadCount > ServerManager.getConfig().minServiceThreadCount) {
                return null;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                logger.debug((Object)e);
                return null;
            }
        }
        return (InvokeHelper)this.queue.removeLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block7: {
            try {
                InvokeHelper helper = this.getService();
                if (helper == null) break block7;
                this.serviceProcessingCount.append(1);
                try {
                    RPCService.service(helper);
                }
                catch (Throwable ex) {
                    logger.error((Object)ex, ex);
                }
                finally {
                    this.serviceProcessingCount.append(-1);
                    this.serviceProcessedCount.append();
                }
            }
            catch (Throwable e) {
                logger.error((Object)e, e);
            }
        }
        this.leaveService();
    }

    public synchronized void shutdown() {
        if (this.running) {
            this.running = false;
            RPCMonitor.removeMonitor(this.monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceDispatcher getDefault() {
        if (dispatcher != null) return dispatcher;
        Class<ServiceDispatcher> clazz = ServiceDispatcher.class;
        synchronized (ServiceDispatcher.class) {
            if (dispatcher != null) return dispatcher;
            dispatcher = new ServiceDispatcher("DefaultDispatcher");
            // ** MonitorExit[var0] (shouldn't be in output)
            return dispatcher;
        }
    }
}

