/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.impl;

import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.impl.ThreadJob;
import com.kingdee.bos.rpc.impl.ThreadPool;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ThreadPool1
extends ThreadPool {
    static final Logger logger = Logger.getLogger(ThreadPool1.class);
    private final ArrayList pool = new ArrayList();

    public ThreadPool1(String name) {
        this(name, 0, 30, 60000L);
    }

    public ThreadPool1(String name, int minSize, int maxSize, long idleTimeout) {
        super(name, minSize, maxSize, idleTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startThread(Runnable runner) {
        if (runner == null) {
            throw new NullPointerException("runner is null.");
        }
        runner = new ThreadJob(runner);
        try {
            Worker worker;
            do {
                ThreadPool1 threadPool1 = this;
                synchronized (threadPool1) {
                    if (this.pool.size() == 0) {
                        new Worker(this.nextName(), runner).start();
                        break;
                    }
                    worker = (Worker)this.pool.remove(this.pool.size() - 1);
                    this.freeCount.setValue(this.pool.size());
                }
            } while (!worker.startWork(runner));
        }
        catch (Throwable e) {
            logger.error((Object)"can't start thread.", e);
            throw RPCException.createIt(e);
        }
    }

    synchronized boolean notifyFree(Worker worker) {
        if (this.pool.size() >= this.maxSize) {
            return true;
        }
        this.pool.add(worker);
        this.freeCount.setValue(this.pool.size());
        return false;
    }

    synchronized boolean notifyTimeout(Worker worker) {
        if (this.pool.size() <= this.minSize) {
            return false;
        }
        this.removeWorker(worker);
        return true;
    }

    synchronized void removeWorker(Worker worker) {
        this.pool.remove(worker);
        this.freeCount.setValue(this.pool.size());
    }

    private class Worker
    extends Thread {
        private final Object monitor;
        Runnable runner;
        boolean interrupted;

        Worker(String name, Runnable runner) {
            super(name);
            this.monitor = new Object();
            this.interrupted = false;
            this.setDaemon(true);
            this.runner = runner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: while (this.runner != null) {
                ThreadPool1.this.activeCount.append(1);
                try {
                    this.runner.run();
                }
                catch (Throwable e) {
                    this.runner = null;
                    logger.error((Object)e, e);
                    break;
                }
                finally {
                    ThreadPool1.this.activeCount.append(-1);
                }
                this.runner = null;
                if (ThreadPool1.this.notifyFree(this)) break;
                while (true) {
                    Object object = this.monitor;
                    synchronized (object) {
                        block16: {
                            try {
                                if (this.runner == null) {
                                    this.monitor.wait(ThreadPool1.this.getIdleTimeout());
                                }
                                if (this.runner != null) {
                                    continue block10;
                                }
                                if (ThreadPool1.this.notifyTimeout(this)) {
                                }
                                break block16;
                            }
                            catch (Throwable e) {
                                this.interrupted = true;
                                this.runner = null;
                                ThreadPool1.this.removeWorker(this);
                                logger.debug((Object)e, e);
                            }
                            continue block10;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean startWork(Runnable runner) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.interrupted) {
                    return false;
                }
                this.runner = runner;
                this.monitor.notify();
                return true;
            }
        }
    }
}

