/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.impl;

import com.kingdee.bos.rpc.ThreadListenerManager;
import com.kingdee.bos.rpc.impl.ThreadJob;
import com.kingdee.bos.rpc.impl.ThreadPool;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class ThreadPool2
extends ThreadPool {
    private static final Logger logger = Logger.getLogger(ThreadPool2.class);
    private final LinkedList<Worker> pool = new LinkedList();

    public ThreadPool2(String name) {
        this(name, 0, 30, 60000L);
    }

    public ThreadPool2(String name, int minSize, int maxSize, long idleTimeout) {
        super(name, minSize, maxSize, idleTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startThread(Runnable runner) {
        Worker worker;
        if (runner == null) {
            throw new NullPointerException("runner is null.");
        }
        ThreadJob job = new ThreadJob(runner);
        do {
            ThreadPool2 threadPool2 = this;
            synchronized (threadPool2) {
                if (this.pool.size() == 0) {
                    new Worker(this.nextName(), job).start();
                    break;
                }
                worker = this.pool.removeFirst();
                this.freeCount.append(-1);
            }
        } while (!worker.startWork(job));
    }

    synchronized boolean workerFree(Worker worker) {
        if (this.pool.size() >= this.maxSize) {
            return true;
        }
        this.pool.addLast(worker);
        this.freeCount.append(1);
        ThreadListenerManager.fireRecycledEvent(worker);
        return false;
    }

    synchronized boolean workerTimeout(Worker worker) {
        if (this.pool.size() <= this.minSize) {
            return false;
        }
        if (this.pool.remove(worker)) {
            this.freeCount.append(-1);
            ThreadListenerManager.fireRemovedEvent(worker);
        }
        return true;
    }

    synchronized void workerStop(Worker worker) {
        if (this.pool.remove(worker)) {
            this.freeCount.append(-1);
            ThreadListenerManager.fireRemovedEvent(worker);
        }
    }

    private class Worker
    extends Thread {
        private final Object monitor;
        private Runnable runner;
        private boolean willStop;

        Worker(String name, Runnable runner) {
            super(name);
            this.monitor = new Object();
            this.willStop = false;
            this.setDaemon(true);
            this.runner = runner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean startWork(Runnable runner) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.runner != null) {
                    logger.error((Object)"should not execute here.", (Throwable)new Exception());
                    return false;
                }
                if (this.willStop || !this.isAlive() || this.isInterrupted()) {
                    return false;
                }
                this.runner = runner;
                this.monitor.notify();
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Runnable r;
            while ((r = this.getWork()) != null) {
                try {
                    ThreadPool2.this.activeCount.append(1);
                    try {
                        this.setContextClassLoader();
                        ThreadListenerManager.fireStartedEvent(this);
                        r.run();
                        ThreadListenerManager.fireFinishedEvent(this);
                    }
                    finally {
                        ThreadPool2.this.activeCount.append(-1);
                    }
                }
                catch (Throwable e) {
                    logger.error((Object)"Thread should not throw error.", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Runnable getWork() {
            Object object = this.monitor;
            synchronized (object) {
                try {
                    Runnable r = this.getWork0();
                    if (r != null) {
                        return r;
                    }
                }
                catch (Throwable e) {
                    logger.error((Object)e, e);
                }
                ThreadPool2.this.workerStop(this);
                this.runner = null;
                this.willStop = true;
                return null;
            }
        }

        private Runnable getRunner() {
            Runnable r = this.runner;
            this.runner = null;
            return r;
        }

        private Runnable getWork0() throws InterruptedException {
            if (this.runner != null) {
                return this.getRunner();
            }
            if (ThreadPool2.this.workerFree(this)) {
                return null;
            }
            do {
                this.monitor.wait(ThreadPool2.this.getIdleTimeout());
                if (this.runner == null) continue;
                return this.getRunner();
            } while (!ThreadPool2.this.workerTimeout(this));
            return null;
        }

        @Override
        public void setContextClassLoader(ClassLoader cl) {
            if (cl == null) {
                logger.error((Object)"someone set ContextClassLoader be null", (Throwable)new RuntimeException("someone set ContextClassLoader be null"));
            }
            super.setContextClassLoader(cl);
        }

        public void setContextClassLoader() {
            this.setContextClassLoader(ThreadPool2.class.getClassLoader());
        }
    }
}

