/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io;

import com.kingdee.bos.rpc.Event;
import com.kingdee.bos.rpc.EventListener;
import com.kingdee.bos.rpc.event.CloseEvent;
import com.kingdee.bos.rpc.impl.ContainerBase;
import com.kingdee.bos.rpc.impl.RPCInvoke;
import com.kingdee.bos.rpc.io.ConnectionHelper;
import com.kingdee.bos.rpc.io.IOManager;
import com.kingdee.bos.rpc.io.InvokeHelper;
import com.kingdee.bos.rpc.io.RPCIOException;
import com.kingdee.bos.rpc.io.server.IServer;
import java.io.IOException;
import java.util.Properties;

public abstract class ConnectionBase
extends ContainerBase
implements ConnectionHelper {
    protected String url;
    protected final Properties props;
    protected ConnectionHelper redirect = null;
    protected String client;
    protected IServer server;

    protected ConnectionBase(String url, Properties props) {
        this.url = url;
        this.props = props == null ? new Properties() : props;
    }

    public void setRedirect(final ConnectionHelper redirect) {
        this.redirect = redirect;
        if (redirect != null) {
            redirect.addEventListener(CloseEvent.class, new EventListener(){

                @Override
                public void onEvent(Event ent) {
                    redirect.removeEventListener(CloseEvent.class, this);
                    ConnectionBase.this.close();
                }
            });
        }
    }

    protected void startService(InvokeHelper helper) {
        IOManager.startService(helper, this.redirect);
    }

    @Override
    public abstract InvokeHelper newInvokeHelper() throws IOException;

    @Override
    public String getConnectionUrl() {
        return this.url;
    }

    @Override
    public Properties getConnectionProps() {
        return this.props;
    }

    @Override
    public String getEngineId() {
        return this.props == null ? null : this.props.getProperty("engineId");
    }

    @Override
    public byte[] ping(byte[] request) throws IOException {
        return RPCInvoke.ping(IOManager.createInvokeHelper(null, this.newInvokeHelper(), false), request);
    }

    protected final void validate() throws IOException {
        if (this.isClosed()) {
            throw new RPCIOException(2004, "Connection closed.");
        }
    }

    public IServer getServer() {
        return this.server;
    }

    public void setServer(IServer server) {
        this.server = server;
    }
}

