/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io;

import com.kingdee.bos.rpc.io.ConnectionHelper;
import com.kingdee.bos.rpc.io.ConnectionManager;
import java.io.IOException;
import java.util.Properties;

public abstract class ConnectionFactory {
    protected final String name;

    protected ConnectionFactory(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract ConnectionHelper connect(Properties var1) throws IOException;

    public static ConnectionFactory createDirect(String serverName, String url) {
        return new Direct(serverName, url);
    }

    public static class Direct
    extends ConnectionFactory {
        public final String url;

        public Direct(String serverName, String url) {
            super(serverName);
            this.url = url;
        }

        @Override
        public ConnectionHelper connect(Properties props) throws IOException {
            return ConnectionManager.connect0(this.url, props);
        }

        public String toString() {
            return "DirectConnectionFactory(server=" + this.name + ", url=" + this.url + ")";
        }
    }
}

