/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io;

import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.impl.ContainerBase;
import com.kingdee.bos.rpc.io.ConnectionDriver;
import com.kingdee.bos.rpc.io.ConnectionHelper;
import com.kingdee.bos.rpc.io.ConnectionPool;
import com.kingdee.bos.rpc.io.IOManager;
import com.kingdee.bos.rpc.io.RPCIOException;
import com.kingdee.bos.rpc.io.server.ServerManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class ConnectionManager {
    private static final ArrayList drivers = new ArrayList();
    private static final HashMap urlMonitors = new HashMap();

    public static synchronized void registerDriver(ConnectionDriver driver) {
        drivers.add(driver);
    }

    public static synchronized void unregisterDriver(ConnectionDriver driver) {
        drivers.remove(driver);
    }

    public static synchronized ConnectionDriver[] getDrivers() {
        return drivers.toArray(new ConnectionDriver[drivers.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ConnectionHelper connect(String url, Properties props, boolean withCounter) throws IOException {
        UrlMonitor monitor;
        if (url.equalsIgnoreCase("internal") || url.toLowerCase().startsWith("server://")) {
            return ConnectionManager.connect0(url, props, withCounter);
        }
        UrlMonitor urlMonitor = monitor = ConnectionManager.getUrlMonitor(url);
        synchronized (urlMonitor) {
            monitor.checkTime();
            return ConnectionManager.connect0(url, props, withCounter);
        }
    }

    private static ConnectionHelper connect0(String url, Properties props, boolean withCounter) throws IOException {
        props = IOManager.prepareConnection(url, props);
        ConnectionDriver[] drivers = ConnectionManager.getDrivers();
        for (int i = 0; i < drivers.length; ++i) {
            ConnectionHelper cn = drivers[i].connect(url, props);
            if (cn == null) continue;
            if (withCounter) {
                ((ContainerBase)((Object)cn)).setCounter("Connection.client.count", url);
            }
            return cn;
        }
        throw new RPCIOException(2005, "no suited driver for url '" + url + "'");
    }

    public static ConnectionHelper connect(String url) throws IOException {
        return ConnectionManager.connect(url, null);
    }

    public static ConnectionHelper connect0(String url, Properties props) throws IOException {
        return ConnectionManager._connect(url, props, false);
    }

    public static ConnectionHelper connect(String url, Properties props) throws IOException {
        return ConnectionManager._connect(url, props, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UrlMonitor getUrlMonitor(String url) {
        UrlMonitor m = (UrlMonitor)urlMonitors.get(url);
        if (m == null) {
            HashMap hashMap = urlMonitors;
            synchronized (hashMap) {
                m = (UrlMonitor)urlMonitors.get(url);
                if (m == null) {
                    m = new UrlMonitor(url);
                    urlMonitors.put(url, m);
                }
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConnectionHelper _connect(String url, Properties props, boolean withCounter) throws IOException {
        if (props == null) {
            props = new Properties();
        }
        if (url.toLowerCase().startsWith("tcps")) {
            ServerManager.setCurrentServer("ssl");
        }
        if (url.equalsIgnoreCase("internal") || url.toLowerCase().startsWith("server://")) {
            return ConnectionManager.connect0(url, props, withCounter);
        }
        UrlMonitor urlMonitor = ConnectionManager.getUrlMonitor(url);
        synchronized (urlMonitor) {
            if (ServerManager.getConfig().useConnectionPool && !url.equalsIgnoreCase("tcp")) {
                return ConnectionPool.connect(url, props, withCounter);
            }
            return ConnectionManager.connect(url, props, withCounter);
        }
    }

    private static class UrlMonitor {
        private long lastTime = 0L;
        private String url;

        UrlMonitor(String url) {
            this.url = url;
        }

        void checkTime() {
            if (this.url.equalsIgnoreCase("internal") || this.url.toLowerCase().startsWith("server://")) {
                return;
            }
            long lt = this.lastTime;
            this.lastTime = System.currentTimeMillis();
            long waitTime = 0L;
            if (lt > 0L) {
                waitTime = ServerManager.getConfig().minConnectionInterval - (this.lastTime - lt);
            }
            if (waitTime > ServerManager.getConfig().minConnectionInterval) {
                waitTime = ServerManager.getConfig().minConnectionInterval;
            }
            if (waitTime > 0L) {
                try {
                    Thread.sleep(waitTime);
                }
                catch (Throwable e) {
                    RPCException.throwIt(e);
                }
            }
        }
    }
}

