/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io;

import com.kingdee.bos.rpc.Event;
import com.kingdee.bos.rpc.EventListener;
import com.kingdee.bos.rpc.event.CloseEvent;
import com.kingdee.bos.rpc.impl.SimplePool;
import com.kingdee.bos.rpc.io.Connection;
import com.kingdee.bos.rpc.io.ConnectionBase;
import com.kingdee.bos.rpc.io.ConnectionHelper;
import com.kingdee.bos.rpc.io.ConnectionManager;
import com.kingdee.bos.rpc.io.InvokeHelper;
import com.kingdee.bos.rpc.io.RPCIOException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class ConnectionPool {
    private static final SimplePool pool = new SimplePool(){

        @Override
        public Object createValue(Object key) throws Exception {
            CnKey cnKey = (CnKey)key;
            return new CnRef(cnKey, ConnectionManager.connect(cnKey.url, cnKey.props, cnKey.withCounter));
        }
    };

    public static ConnectionHelper connect0(String url, Properties props) throws IOException {
        return ConnectionPool.connect(url, props, false);
    }

    public static ConnectionHelper connect(String url) throws IOException {
        return ConnectionPool.connect(url, null, true);
    }

    public static ConnectionHelper connect(String url, Properties props) throws IOException {
        return ConnectionPool.connect(url, props, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static ConnectionHelper connect(String url, Properties props, boolean withCounter) throws IOException {
        if (props == null) {
            props = new Properties();
        }
        CnKey cnKey = new CnKey(url, props, withCounter);
        try {
            while (true) {
                CnRef ref;
                CnRef cnRef = ref = (CnRef)pool.get(cnKey);
                synchronized (cnRef) {
                    if (!ref.isClosed()) {
                        return new _ConnectionHelper(ref);
                    }
                }
            }
        }
        catch (Throwable e) {
            throw RPCIOException.create(e);
        }
    }

    private static class _InvokeHelper
    implements InvokeHelper {
        Connection cn;
        InvokeHelper helper;

        _InvokeHelper(Connection cn, InvokeHelper helper) {
            this.cn = cn;
            this.helper = helper;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.helper.getOutputStream();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.helper.getInputStream();
        }

        @Override
        public Connection getConnection() {
            return this.cn;
        }

        @Override
        public void close() {
            this.helper.close();
        }

        @Override
        public void setSocketOption() {
            this.helper.setSocketOption();
        }
    }

    private static class _ConnectionHelper
    extends ConnectionBase {
        CnRef ref;

        _ConnectionHelper(CnRef ref) {
            super(ref.cnKey.url, ref.cnKey.props);
            this.ref = ref;
            ref.addRef();
            this.addEventListener(CloseEvent.class, new EventListener(){

                @Override
                public void onEvent(Event event) {
                    _ConnectionHelper.this.removeEventListener(CloseEvent.class, this);
                    _ConnectionHelper.this.close();
                }
            });
        }

        @Override
        public InvokeHelper newInvokeHelper() throws IOException {
            InvokeHelper helper = this.ref.cn.newInvokeHelper();
            return new _InvokeHelper(this, helper);
        }

        @Override
        protected void finalClose() {
            this.ref.release();
        }
    }

    private static class CnRef {
        ConnectionHelper cn;
        CnKey cnKey;
        int refs = 0;
        boolean closed = false;

        CnRef(CnKey cnKey, final ConnectionHelper cn) {
            this.cnKey = cnKey;
            this.cn = cn;
            cn.addEventListener(CloseEvent.class, new EventListener(){

                @Override
                public void onEvent(Event ent) {
                    cn.removeEventListener(CloseEvent.class, this);
                    CnRef.this.close();
                }
            });
        }

        synchronized void addRef() {
            ++this.refs;
        }

        synchronized int getRefs() {
            return this.refs;
        }

        synchronized boolean isClosed() {
            return this.closed || this.cn.isClosed();
        }

        synchronized void release() {
            --this.refs;
            if (this.refs == 0) {
                this.close();
            }
        }

        synchronized void close() {
            if (!this.closed) {
                this.closed = true;
                pool.remove(this.cnKey);
                this.cn.close();
            }
        }
    }

    private static class CnKey {
        String url;
        Properties props;
        String key;
        boolean withCounter;

        CnKey(String url, Properties props, boolean withCounter) {
            this.url = url;
            this.props = props;
            this.key = url + props.toString();
            this.withCounter = withCounter;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object x) {
            if (x == null) {
                return false;
            }
            if (this == x) {
                return true;
            }
            if (!(x instanceof CnKey)) {
                return false;
            }
            return this.key.equals(((CnKey)x).key);
        }
    }
}

