/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io;

import com.kingdee.bos.rpc.Event;
import com.kingdee.bos.rpc.EventListener;
import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.RPCSession;
import com.kingdee.bos.rpc.ce.RPCConnectException;
import com.kingdee.bos.rpc.event.CloseEvent;
import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.impl.RPCInvoke;
import com.kingdee.bos.rpc.impl.RPCSessionImpl;
import com.kingdee.bos.rpc.io.ConnectionHelper;
import com.kingdee.bos.rpc.io.ConnectionManager;
import com.kingdee.bos.rpc.io.ConnectionMonitor;
import com.kingdee.bos.rpc.io.IOManager;
import com.kingdee.bos.rpc.io.InvokeHelper;
import com.kingdee.bos.rpc.io.RPCIOException;
import com.kingdee.bos.rpc.io.server.ServerManager;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;

public class Connector {
    static final Logger logger = Logger.getLogger(Connector.class);
    public String url;
    public final Properties props;
    private transient ConnectionHelper cn = null;
    private transient int refs = 0;
    public boolean serverRestarted = false;
    private final EventListener eventListener = new EventListener(){

        @Override
        public void onEvent(Event e) {
            Connector.this.onConnectionClosed((ConnectionHelper)e.source);
        }
    };
    private final WeakHashMap sessions = new WeakHashMap();
    private final SessionFinalizer sessionFinalizer = new SessionFinalizer();

    public byte[] ping(byte[] request) throws IOException {
        try {
            this.onNormal();
            return RPCInvoke.ping(this, request);
        }
        catch (Throwable e) {
            this.onError(e);
            throw RPCIOException.create(e);
        }
    }

    public void open() throws IOException {
        try {
            this.getConnection();
            this.onNormal();
        }
        catch (Throwable e) {
            this.onError(e);
            throw RPCIOException.create(e);
        }
    }

    public Connector(String url) {
        this(url, null);
    }

    public Connector(String url, Properties props) {
        this.url = url;
        this.props = props == null ? new Properties() : props;
    }

    protected final void finalize() throws Throwable {
        for (RPCSession session : this.sessions.keySet()) {
            session.close();
        }
        super.finalize();
    }

    public InvokeHelper newInvokeHelper() throws IOException {
        return this.newInvokeHelper(true, false);
    }

    public InvokeHelper newDirectInvokeHelper() throws IOException {
        return this.newInvokeHelper(true, true);
    }

    public InvokeHelper newNoRetryInvokeHelper() throws IOException {
        return this.newInvokeHelper(false, false);
    }

    private InvokeHelper createInvokeHelper(boolean direct) throws IOException {
        InvokeHelper helper = IOManager.createInvokeHelper(this, this.getConnection().newInvokeHelper(), direct);
        ConnectionMonitor monitor = ServerManager.getConfig().connectionMonitor;
        if (monitor != null) {
            helper = monitor.newInvoke(this, helper);
        }
        return helper;
    }

    protected void onError(Throwable e) {
        if (RPCException.getErrorCode(e) == 1005) {
            this.serverRestarted = true;
        }
    }

    protected void onNormal() {
        this.serverRestarted = false;
    }

    private InvokeHelper newInvokeHelper(boolean retry, boolean direct) throws IOException {
        Connector connector = this;
        synchronized (connector) {
            if (this.serverRestarted) {
                throw new RPCConnectException(1005, "Server(" + this.url + ") restarted.", 6002);
            }
            ConnectionMonitor monitor = ServerManager.getConfig().connectionMonitor;
            if (monitor != null) {
                monitor.beforeInvoke(this);
            }
            int i = 0;
            while (true) {
                try {
                    this.onNormal();
                    return this.createInvokeHelper(direct);
                }
                catch (Throwable ex) {
                    this.onError(ex);
                    if (ex instanceof ConnectException || ex instanceof SocketException) {
                        throw new RPCConnectException("Server(" + this.url + ") connect fail.", ex, 6002);
                    }
                    IOException e = RPCIOException.create(ex);
                    this.closeConnection();
                    if (monitor != null) {
                        monitor.connectFailed(this, e);
                    }
                    if (ex instanceof RPCConnectException) {
                        throw (RPCConnectException)ex;
                    }
                    if (RPCException.getErrorCode(e) == 1005) {
                        this.serverRestarted = true;
                        throw e;
                    }
                    if (retry) {
                        if (monitor != null) {
                            if (!monitor.retryConnect(this, e, i)) {
                                throw e;
                            }
                        } else {
                            if (i >= ServerManager.getConfig().connectionRetryTime) {
                                throw e;
                            }
                            IOUtil.logIOError(logger, e);
                        }
                    }
                    ++i;
                    continue;
                }
                break;
            }
        }
    }

    private synchronized void onConnectionClosed(ConnectionHelper cn) {
        cn.removeEventListener(CloseEvent.class, this.eventListener);
        if (this.cn == cn) {
            this.cn = null;
        }
    }

    private synchronized ConnectionHelper getConnection() throws IOException {
        if (this.cn != null && this.cn.isClosed()) {
            this.cn = null;
        }
        if (this.cn == null) {
            ConnectionMonitor monitor = ServerManager.getConfig().connectionMonitor;
            if (monitor != null) {
                monitor.beforeConnect(this);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("try to connect " + this.url));
            }
            this.cn = ConnectionManager.connect(this.url, this.props);
            this.cn.addEventListener(CloseEvent.class, this.eventListener);
            if (monitor != null) {
                monitor.connected(this);
            }
        }
        return this.cn;
    }

    public synchronized void closeConnection() {
        if (this.cn != null) {
            try {
                this.cn.removeEventListener(CloseEvent.class, this.eventListener);
                this.cn.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.cn = null;
        }
    }

    public synchronized int addRef() {
        return ++this.refs;
    }

    public int release() {
        return this.release(1);
    }

    private synchronized int release(int count) {
        this.refs -= count;
        if (this.refs <= 0) {
            this.closeConnection();
        }
        return this.refs;
    }

    private Connector _this() {
        return this;
    }

    public RPCSession createSession() {
        return this.createSession(true);
    }

    public RPCSession createSession(boolean stateable) {
        try {
            RPCSessionImpl session = RPCInvoke.createSession(this, stateable);
            this.sessions.put(session, this);
            this.onNormal();
            return session;
        }
        catch (Throwable e) {
            this.onError(e);
            throw RPCException.createIt(e);
        }
    }

    public void closeSession(long id) {
        this.sessionFinalizer.addSession(id);
    }

    public String getClientIp() {
        return this.props == null ? "" : this.props.getProperty("clientIp", "");
    }

    public String getServerIp() {
        return this.props == null ? "" : this.props.getProperty("serverIp", "");
    }

    class SessionFinalizer
    implements Runnable {
        private boolean alive = false;
        private final ArrayList sessions = new ArrayList();

        SessionFinalizer() {
        }

        synchronized void addSession(long id) {
            this.sessions.add(new Long(id));
            if (!this.alive) {
                this.alive = true;
                RPCEngine.startThread(this);
            }
        }

        synchronized long[] getSessions() {
            long[] ids = new long[this.sessions.size()];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = (Long)this.sessions.get(i);
            }
            this.sessions.clear();
            this.alive = false;
            Connector.this.release(ids.length - 1);
            return ids;
        }

        @Override
        public void run() {
            try {
                long[] sessions = this.getSessions();
                InvokeHelper helper = Connector.this.newInvokeHelper();
                RPCInvoke.closeSession(Connector.this._this(), helper, sessions);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Connector.this.release();
        }
    }
}

