/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io;

import com.kingdee.bos.rpc.io.ConnectionFactory;
import com.kingdee.bos.rpc.io.ConnectionHelper;
import com.kingdee.bos.rpc.io.RPCIOException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;

public class ServerManager {
    public static final String DEFAULT_SERVER_NAME = "";
    private static final HashMap servers = new HashMap();

    public static void registerServer(String name, String url) {
        ServerManager.registerServer(ConnectionFactory.createDirect(name, url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerServer(ConnectionFactory factory) {
        HashMap hashMap = servers;
        synchronized (hashMap) {
            servers.put(ServerManager._name(factory.getName()), factory);
        }
    }

    private static String _name(String s) {
        if (s == null || s.trim().length() == 0) {
            return DEFAULT_SERVER_NAME;
        }
        return s.toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionFactory getServer(String name) {
        HashMap hashMap = servers;
        synchronized (hashMap) {
            return (ConnectionFactory)servers.get(ServerManager._name(name));
        }
    }

    public static ConnectionHelper connect(String name, Properties props) throws IOException {
        ConnectionFactory cf = ServerManager.getServer(name);
        if (cf == null) {
            throw new RPCIOException(2007, "server '" + name + "' not found");
        }
        return cf.connect(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionFactory[] listServers() {
        HashMap hashMap = servers;
        synchronized (hashMap) {
            return servers.values().toArray(new ConnectionFactory[servers.size()]);
        }
    }
}

