/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.driver;

import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.io.Connection;
import com.kingdee.bos.rpc.io.ConnectionBase;
import com.kingdee.bos.rpc.io.InvokeHelper;
import com.kingdee.bos.rpc.io.RPCIOException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

class HttpConnectionHelper
extends ConnectionBase {
    private static final Logger logger = Logger.getLogger(HttpConnectionHelper.class);
    final String cnId;
    private volatile String cookie;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpConnectionHelper(String url, Properties props) throws IOException {
        block7: {
            super(url, props);
            this.cookie = null;
            URLConnection cn = this.openConnection();
            OutputStream out = cn.getOutputStream();
            out.write(78);
            IOUtil.writeProperties(out, props);
            out.close();
            cn.connect();
            InputStream in = cn.getInputStream();
            try {
                int r = in.read();
                if (r == 79) {
                    this.cnId = IOUtil.readLine(in);
                    this.props.setProperty("engineId", IOUtil.readLine(in));
                    Map<String, List<String>> map = cn.getHeaderFields();
                    Set<String> set = map.keySet();
                    for (String key : set) {
                        if (!"set-cookie".equalsIgnoreCase(key)) continue;
                        List<String> list = map.get(key);
                        if (list instanceof List) {
                            StringBuilder builder = new StringBuilder();
                            for (String str : list) {
                                builder.append(str);
                                builder.append(';');
                            }
                            this.cookie = builder.toString();
                        }
                        break block7;
                    }
                    break block7;
                }
                throw new RPCIOException(IOUtil.readLine(in));
            }
            finally {
                IOUtil.close(in);
            }
        }
    }

    @Override
    public InvokeHelper newInvokeHelper() throws IOException {
        return new _InvokeHelper(this);
    }

    URLConnection openConnection() throws IOException {
        URLConnection cn = new URL(this.url).openConnection();
        cn.setDoInput(true);
        cn.setDoOutput(true);
        cn.setRequestProperty("User-Agent", "Kingdee BOS-RPC V2.0");
        cn.setRequestProperty("Content-Type", "RPCInvoke");
        cn.setRequestProperty("Accept", "RPCInvoke");
        if (this.cookie != null && this.cookie.trim() != "") {
            cn.setRequestProperty("Cookie", this.cookie);
        }
        return cn;
    }

    @Override
    protected void finalClose() throws Throwable {
        try {
            URLConnection cn = this.openConnection();
            OutputStream out = cn.getOutputStream();
            IOUtil.writeLine(out, 'C' + this.cnId);
            out.close();
            cn.connect();
            InputStream in = cn.getInputStream();
            IOUtil.close(in);
        }
        catch (Throwable e) {
            IOUtil.logIOError(logger, e);
        }
    }

    private static class _InvokeHelper
    implements InvokeHelper {
        final URLConnection cn;
        private InputStream in = null;
        private OutputStream out = null;
        final HttpConnectionHelper parent;

        _InvokeHelper(HttpConnectionHelper parent) throws IOException {
            this.parent = parent;
            this.cn = parent.openConnection();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            if (this.out == null) {
                this.out = this.cn.getOutputStream();
                IOUtil.writeLine(this.out, 'I' + this.parent.cnId);
            }
            return this.out;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.in == null) {
                this.getOutputStream().close();
                this.cn.connect();
                this.in = this.cn.getInputStream();
                int r = this.in.read();
                if (r == 69) {
                    RPCIOException ex = new RPCIOException(IOUtil.readLine(this.in));
                    if (RPCException.getErrorCode(ex) == 1005) {
                        IOUtil.close(this.parent);
                    }
                    throw ex;
                }
            }
            return this.in;
        }

        @Override
        public void close() {
            IOUtil.close(this.out);
            IOUtil.close(this.in);
        }

        @Override
        public Connection getConnection() {
            return this.parent;
        }

        @Override
        public void setSocketOption() {
        }
    }
}

