/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.driver;

import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.io.ConnectionBase;
import com.kingdee.bos.rpc.io.IOManager;
import com.kingdee.bos.rpc.io.InvokeHelper;
import com.kingdee.bos.rpc.io.driver.InternalInvokeHelper;
import com.kingdee.bos.rpc.io.driver.StreamPipe;
import com.kingdee.bos.rpc.io.server.IServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class InternalConnectionHelper
extends ConnectionBase {
    public final InternalConnectionHelper peer;

    InternalConnectionHelper(Properties props) throws IOException {
        super("internal", props);
        this.peer = new InternalConnectionHelper(this);
        this.peer.setCounter("Connection.server.count", this.getConnectionUrl());
    }

    private static Properties peerProps(Properties props) throws IOException {
        Properties props1 = props == null ? new Properties() : (Properties)props.clone();
        Properties append = IOManager.responseConnection("internal", props1);
        if (append != null) {
            props1 = IOUtil.appendProperties(props1, append);
        }
        return props1;
    }

    InternalConnectionHelper(InternalConnectionHelper peer) throws IOException {
        super("internal", InternalConnectionHelper.peerProps(peer.props));
        this.peer = peer;
    }

    @Override
    protected void finalClose() throws Throwable {
    }

    @Override
    public InvokeHelper newInvokeHelper() throws IOException {
        this.validate();
        StreamPipe p1 = new StreamPipe();
        StreamPipe p2 = new StreamPipe();
        InternalInvokeHelper helper1 = new InternalInvokeHelper(this, p1, p2);
        InternalInvokeHelper helper2 = new InternalInvokeHelper(this.peer, p2, p1);
        this.startService(helper2);
        return helper1;
    }

    public InvokeHelper newInvokeHelper(InputStream in, OutputStream out) throws IOException {
        this.validate();
        StreamPipe p1 = new StreamPipe(in, null);
        StreamPipe p2 = new StreamPipe(null, out);
        InternalInvokeHelper helper = new InternalInvokeHelper(this, p1, p2);
        return helper;
    }

    @Override
    public void setServer(IServer server) {
        this.server = server;
        this.peer.server = server;
    }
}

