/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.driver;

import com.kingdee.bos.rpc.impl.CounterObject;
import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.io.driver.SocketPool;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.performance.IntValue;
import com.kingdee.bos.rpc.performance.PerformanceManager;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class PooledSocket
extends CounterObject {
    static final Logger logger = Logger.getLogger(PooledSocket.class);
    public static final short BLOCK_MAGIC = 10624;
    public static final short BLOCK_MAGIC_EOF = -2707;
    public static final short MAGIC_TEST = -32659;
    public static final short MAGIC_PINGNODELAY = -32658;
    public static final short MAGIC_PINGRESULT = -32657;
    final Socket sock;
    final DataInputStream in;
    final DataOutputStream out;
    private Throwable error = null;
    protected short currentIndex = 0;
    private boolean inputClosed = false;
    private boolean outputClosed = false;
    private InputStream input = null;
    private OutputStream output = null;
    private long lastIdleTime = System.currentTimeMillis();
    public final String url;
    public final Properties props;
    final SocketPool pool;
    private final IntValue counter;
    long lastTestTime = 0L;

    public long getIdleTime() {
        if (this.input == null && this.output == null) {
            return System.currentTimeMillis() - this.lastIdleTime;
        }
        return 0L;
    }

    protected PooledSocket(SocketPool pool, Socket sock, DataInputStream in, DataOutputStream out, String url, Properties props) {
        this.pool = pool;
        this.sock = sock;
        this.in = in;
        this.out = out;
        this.url = url;
        this.props = props;
        this.counter = PerformanceManager.getIntValue("PooledSocket." + url);
        this.counter.append(1);
    }

    public Socket getSocket() throws IOException {
        this.pool.checkConnectTimeoutRecently();
        return this.sock;
    }

    public synchronized InputStream getInputStream() {
        if (this.input == null) {
            this.input = new _Input(this.currentIndex);
        }
        return this.input;
    }

    public synchronized OutputStream getOutputStream() {
        if (this.output == null) {
            this.output = new _Output(this.currentIndex);
        }
        return this.output;
    }

    private void checkIndex(short index1, short index2) throws IOException {
        if (index1 != index2) {
            IOException ioe = new IOException("invalid stream index " + index1 + " != " + index2);
            logger.error((Object)ioe);
            this.error(ioe);
            throw ioe;
        }
    }

    protected void error(Throwable e) {
        this.error = e;
    }

    synchronized byte[] readBlock(_Input input) throws IOException {
        this.checkIndex(input.index, this.currentIndex);
        try {
            short magic = this.in.readShort();
            while (magic == -32659) {
                magic = this.in.readShort();
            }
            if (magic != 10624 && magic != -2707) {
                IOException err = new IOException("invalid block magic " + Integer.toHexString(0xFFFF & magic));
                logger.error((Object)err, (Throwable)err);
                throw err;
            }
            short idx = this.in.readShort();
            this.checkIndex(idx, input.index);
            int len = 0xFFFF & this.in.readShort();
            byte[] data = null;
            if (len > 0) {
                data = new byte[len];
                this.in.readFully(data);
            }
            if (len == 2 && data[0] == -128 && data[1] == 110) {
                this.sendPingResult();
                return this.readBlock(input);
            }
            if (magic == -2707) {
                input.eof = true;
            }
            return data;
        }
        catch (IOException e) {
            this.error(e);
            throw e;
        }
    }

    synchronized void sendPingResult() throws IOException {
        DataOutputStream dos = new DataOutputStream(this.getOutputStream());
        dos.writeShort(-32657);
        dos.flush();
    }

    synchronized void test(boolean force) throws IOException {
        long testInterval = ServerManager.getConfig().pooledSocketTestIntervalTime;
        if (force || this.getIdleTime() >= testInterval && System.currentTimeMillis() - this.lastTestTime >= testInterval) {
            if (this.out == null) {
                return;
            }
            this.out.writeShort(-32659);
            this.out.flush();
            this.lastTestTime = System.currentTimeMillis();
        }
    }

    synchronized void writeBlock(short index, byte[] b, int off, int len, boolean close) throws IOException {
        this.checkIndex(index, this.currentIndex);
        try {
            this.out.writeShort(close ? -2707 : 10624);
            this.out.writeShort(index);
            this.out.writeShort(len);
            if (len > 0) {
                this.out.write(b, off, len);
            }
        }
        catch (IOException e) {
            this.error(e);
            throw e;
        }
    }

    public synchronized void flushOutput(short index) throws IOException {
        try {
            this.checkIndex(index, this.currentIndex);
            this.out.flush();
        }
        catch (IOException e) {
            this.error(e);
            throw e;
        }
    }

    public synchronized void closeInput(short index) throws IOException {
        this.checkIndex(index, this.currentIndex);
        this.inputClosed = true;
        this.checkRelease();
    }

    public synchronized void closeOutput(short index) throws IOException {
        this.checkIndex(index, this.currentIndex);
        this.outputClosed = true;
        this.checkRelease();
    }

    protected void checkRelease() {
        if (this.inputClosed && this.outputClosed) {
            this.input = null;
            this.output = null;
            this.inputClosed = false;
            this.outputClosed = false;
            this.currentIndex = (short)(this.currentIndex + 1);
            this.lastIdleTime = System.currentTimeMillis();
            if (this.error != null || !this.releaseSocket()) {
                this.close();
            }
        }
    }

    public void close() {
        IOUtil.close(this.out);
        IOUtil.close(this.in);
        IOUtil.close(this.sock);
        super.releaseCounter();
        this.counter.append(-1);
    }

    protected abstract boolean releaseSocket();

    class _Output
    extends OutputStream {
        short index;
        byte[] buffer;
        int pos;
        volatile boolean closed = false;

        _Output(short index) {
            this.index = index;
            this.buffer = new byte[ServerManager.getConfig().blockBufferSize];
        }

        void check() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                this.flushData(true);
            }
            finally {
                PooledSocket.this.closeOutput(this.index);
            }
        }

        private synchronized void flushData(boolean force) throws IOException {
            if (this.pos == 0 && !this.closed) {
                return;
            }
            PooledSocket.this.writeBlock(this.index, this.buffer, 0, this.pos, this.closed);
            this.pos = 0;
            if (force) {
                PooledSocket.this.flushOutput(this.index);
            }
        }

        @Override
        public synchronized void flush() throws IOException {
            this.check();
            this.flushData(true);
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            this.check();
            while (len > 0) {
                int l = this.buffer.length - this.pos;
                if (l > len) {
                    l = len;
                }
                System.arraycopy(b, off, this.buffer, this.pos, l);
                off += l;
                len -= l;
                this.pos += l;
                if (this.pos < this.buffer.length) continue;
                this.flushData(false);
            }
        }

        @Override
        public synchronized void write(int b) throws IOException {
            this.check();
            this.buffer[this.pos++] = (byte)b;
            if (this.pos >= this.buffer.length) {
                this.flushData(false);
            }
        }
    }

    class _Input
    extends InputStream {
        short index;
        byte[] data = null;
        volatile boolean closed = false;
        boolean eof = false;
        int pos = 0;

        _Input(short index) {
            this.index = index;
        }

        void check() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed.");
            }
        }

        private synchronized int fetch() throws IOException {
            if (this.data == null || this.pos >= this.data.length) {
                if (this.eof) {
                    return 0;
                }
                this.data = PooledSocket.this.readBlock(this);
                this.pos = 0;
            }
            return this.data == null ? 0 : this.data.length - this.pos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                _Input _Input2 = this;
                synchronized (_Input2) {
                    while (this.fetch() > 0) {
                        this.pos = this.data.length;
                    }
                }
            }
            finally {
                PooledSocket.this.closeInput(this.index);
            }
        }

        @Override
        public synchronized int read() throws IOException {
            this.check();
            int len = this.fetch();
            if (len == 0) {
                return -1;
            }
            return 0xFF & this.data[this.pos++];
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            this.check();
            int maxLen = this.fetch();
            if (maxLen == 0) {
                return -1;
            }
            if (b == null || len == 0) {
                return 0;
            }
            if (len > maxLen) {
                len = maxLen;
            }
            System.arraycopy(this.data, this.pos, b, off, len);
            this.pos += len;
            return len;
        }
    }
}

