/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.driver;

import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.rpc.io.ConnectionDriver;
import com.kingdee.bos.rpc.io.ConnectionHelper;
import com.kingdee.bos.rpc.io.ConnectionManager;
import com.kingdee.bos.rpc.io.driver.PooledTCPConnection;
import com.kingdee.bos.rpc.netty.NettyPooledTCPConnection;
import java.io.IOException;
import java.util.Properties;

public class PooledTCPConnectionDriver
extends ConnectionDriver {
    public static final String PROTOCOL = "tcp";
    public static final String URL_PREFIX = "tcp://";

    public PooledTCPConnectionDriver() {
        super(PROTOCOL);
    }

    public PooledTCPConnectionDriver(String proto) {
        super(proto);
    }

    @Override
    public ConnectionHelper connect(String url, Properties props) throws IOException {
        if (!url.toLowerCase().startsWith(this.protocol + "://")) {
            return null;
        }
        if (ORMRPConfig.isNetty()) {
            return new NettyPooledTCPConnection(url, props, true);
        }
        return new PooledTCPConnection(url, props, true);
    }

    static {
        ConnectionManager.registerDriver(new PooledTCPConnectionDriver());
    }
}

