/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.driver;

import com.kingdee.bos.rpc.RPCConfig;
import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.ce.RPCConnectException;
import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.impl.RPCService;
import com.kingdee.bos.rpc.io.ConnectionHelper;
import com.kingdee.bos.rpc.io.ConnectionManager;
import com.kingdee.bos.rpc.io.DataDump;
import com.kingdee.bos.rpc.io.IOManager;
import com.kingdee.bos.rpc.io.RPCIOException;
import com.kingdee.bos.rpc.io.driver.ClientIpUtil;
import com.kingdee.bos.rpc.io.driver.NIOConnection;
import com.kingdee.bos.rpc.io.driver.PooledTCPConnection;
import com.kingdee.bos.rpc.io.driver.SSLTCPDriver;
import com.kingdee.bos.rpc.io.driver.StreamConnection;
import com.kingdee.bos.rpc.io.loadbalance.LoadBalanceLocalizer;
import com.kingdee.bos.rpc.io.nio.NIOSocket;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class RPCConnection {
    private static final Logger logger = Logger.getLogger(RPCConnection.class);
    public static final String RPC_METHOD = "RPC_INVOKE";
    public static final String RPC_PROTOCOL = "RPC/2.0";
    public static final String RPC_PROTOCOL_MULTICHANNEL = "RPC/2.0";
    public static final String RPC_PROTOCOL_POOL = "RPC_POOL/1.0";
    public static final String NAME_URL = "rpc_url";
    public static final String NAME_PROPS = "rpc_props";
    public static final String NAME_PROTOCOL = "rpc_protocol";
    public static final int RPC_OK = 200;
    public static final int RPC_VERSION = 505;
    public static final int RPC_INTERNAL_ERROR = 500;
    public static final int RPC_BAD_METHOD = 405;
    public static final String LBURL = "lbUrl";
    public static final String SERVER_IP = "serverIp";
    public String url = null;
    public Properties props = null;
    public InputStream in = null;
    public OutputStream out = null;
    public Socket sock = null;
    public String protocol;
    public String clientIp;
    public InetAddress clientInetAddress;
    public String serverIp;
    public String route;
    private LoadBalanceLocalizer lbl;
    private IServer server;
    public static final String SERVER_NAME = "serverName";
    public static final ThreadLocal lbUrlTL = new ThreadLocal();
    private static ThreadLocal currentSockTimeout;

    public RPCConnection() {
        this("RPC/2.0");
    }

    public RPCConnection(IServer server) {
        this("RPC/2.0", server);
    }

    public RPCConnection(String protocol) {
        this.protocol = protocol;
    }

    public RPCConnection(String protocol, IServer server) {
        this.protocol = protocol;
        this.server = server;
    }

    private static void notRPCServer(String response) throws IOException {
        String msg = "Server is not a RPC server.";
        if (response != null) {
            msg = msg + " the response is '" + response + "'";
        }
        throw new RPCIOException(2006, msg);
    }

    protected Properties getResponseProps() throws IOException {
        return IOManager.responseConnection(this.url, this.props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nioAccept(String serverName, SocketChannel channel, String redirectUrl) throws IOException {
        NIOSocket sock = NIOConnection.createSocket(channel);
        RPCConfig config = ServerManager.getConfig();
        this.setSocket(sock.socket(), config);
        this.in = sock.getInputStream();
        this.out = sock.getOutputStream();
        boolean bOK = false;
        ConnectionHelper redirect = null;
        try {
            redirect = this.accept(this.in, this.out, redirectUrl, serverName);
            bOK = true;
        }
        finally {
            if (!bOK) {
                IOUtil.close(sock);
            }
        }
        sock.socket().setSoTimeout(config.tcpServiceTimeout);
        NIOConnection cn = new NIOConnection(sock, this.url, this.props, false);
        cn.setRedirect(redirect);
        cn.setCounter("Connection.server.count", serverName);
        cn.setServer(this.server);
        cn.startService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(String serverName, Socket sock, String redirectUrl) throws IOException {
        RPCConfig config = ServerManager.getConfig();
        this.setSocket(sock, config);
        this.sock = sock;
        this.in = config.dumpInputStream ? new BufferedInputStream(DataDump.createInputStream(sock)) : new BufferedInputStream(sock.getInputStream());
        this.out = new BufferedOutputStream(sock.getOutputStream(), config.bufferedOutSize);
        boolean bOK = false;
        ConnectionHelper redirect = null;
        try {
            redirect = this.accept(this.in, this.out, redirectUrl, serverName);
            bOK = true;
        }
        finally {
            if (!bOK) {
                IOUtil.close(sock);
            }
        }
        sock.setSoTimeout(config.tcpServiceTimeout);
        if (this.protocol.equals("RPC/2.0")) {
            StreamConnection cn = new StreamConnection(this.url, this.props, false, sock, this.in, this.out);
            cn.setRedirect(redirect);
            cn.setCounter("Connection.server.count", serverName);
            cn.setServer(this.server);
            cn.startServiceLoop();
        } else {
            PooledTCPConnection cn = new PooledTCPConnection(this.url, this.props, false);
            cn.setRedirect(redirect);
            cn.setCounter("Connection.server.count", serverName);
            cn.setServer(this.server);
            cn.startService(this);
        }
    }

    private void setSocket(Socket sock, RPCConfig config) throws SocketException {
        int tc;
        if (config.receiveBufferSize > 0) {
            sock.setReceiveBufferSize(config.receiveBufferSize);
        }
        if (config.sendBufferSize > 0) {
            sock.setSendBufferSize(config.sendBufferSize);
        }
        if ((tc = config.trafficClass) > 0 && tc < 255) {
            sock.setTrafficClass(tc);
        }
        if (config.pp_connectionTime != -1 || config.pp_latency != -1 || config.pp_bandwidth != -1) {
            sock.setPerformancePreferences(config.pp_connectionTime, config.pp_latency, config.pp_bandwidth);
        }
        sock.setTcpNoDelay(config.tcpNoDelay);
        sock.setSoTimeout(config.tcpHandshakeTimeout);
        sock.setKeepAlive(config.socketKeepAlive);
    }

    public ConnectionHelper accept(InputStream in, OutputStream out, String redirectUrl, String serverName) throws IOException {
        ConnectionHelper redirect;
        Properties response;
        String status;
        int code;
        String ver;
        String line;
        block16: {
            this.in = in;
            this.out = out;
            line = IOUtil.readLine(in);
            if (line == null) {
                throw new IOException("Client socket is closed! Can't get data from client inputStream!");
            }
            int index = line.indexOf(32);
            int index1 = line.lastIndexOf(32);
            String method = line.substring(0, index);
            this.url = line.substring(index + 1, index1).trim();
            this.protocol = ver = line.substring(index1 + 1);
            code = 200;
            status = "OK";
            if (!ver.equalsIgnoreCase("RPC/2.0") && !ver.equalsIgnoreCase(RPC_PROTOCOL_POOL)) {
                code = 505;
                status = "protocol not supported.";
            } else if (!method.equalsIgnoreCase(RPC_METHOD)) {
                code = 405;
                status = "bad method '" + method + "'";
            }
            if (code == 200) {
                this.props = IOUtil.readProperties(in, new Properties());
                if (this.props == null) {
                    this.props = new Properties();
                }
                this.route = this.props.getProperty("route", "");
                this.route = this.route + (this.clientIp == null ? "unknown" : this.clientIp);
                this.props.setProperty("route", this.route);
            }
            response = null;
            redirect = null;
            try {
                if (redirectUrl == null) {
                    response = this.getResponseProps();
                    if (response == null) {
                        response = new Properties();
                    }
                    if (response.getProperty(SERVER_NAME) == null) {
                        response.setProperty(SERVER_NAME, serverName);
                    }
                } else {
                    redirect = ConnectionManager.connect(redirectUrl, this.props);
                    response = new Properties();
                    response.setProperty("engineId", redirect.getEngineId());
                    response.setProperty(SERVER_NAME, redirect.getConnectionProps().getProperty(SERVER_NAME));
                    if (this.props.getProperty("isByLB") != null) {
                        response.setProperty("isByLB", this.props.getProperty("isByLB"));
                    }
                }
                response.setProperty("clientIp", this.clientIp == null ? "unknown" : this.clientIp);
                response.setProperty(SERVER_IP, this.serverIp == null ? "unknown" : this.serverIp);
                if ("true".equals(this.props.get("getClientIp"))) {
                    boolean ipv4 = this.clientInetAddress instanceof Inet4Address;
                    String s = "" + (ipv4 ? "ipv4" : "ipv6") + "/" + this.clientInetAddress.getHostAddress();
                    response.setProperty("clientInetAddress", s);
                }
                this.props.setProperty(SERVER_IP, this.serverIp);
            }
            catch (Throwable e) {
                code = RPCException.getErrorCode(e);
                String msg = e.getMessage();
                if (msg == null || msg.trim() == "") break block16;
                status = msg;
            }
        }
        IOUtil.writeLine(out, ver + " " + code + " " + status);
        if (code != 200) {
            IOUtil.writeLine(out);
            out.flush();
            throw new RPCIOException(code, line + " : " + status);
        }
        if (this.lbl != null) {
            response.setProperty(LBURL, this.lbl.connect());
        }
        IOUtil.writeProperties(out, response);
        out.flush();
        return redirect;
    }

    public static InetSocketAddress getAddress(String url, int defaultPort) throws UnknownHostException {
        int port;
        String host;
        int index = url.indexOf(47) + 2;
        int index1 = url.indexOf(47, index);
        String address = index1 < 0 ? url.substring(index) : url.substring(index, index1);
        index = address.indexOf(58);
        if (index < 0) {
            host = address;
            port = defaultPort;
        } else {
            host = address.substring(0, index);
            port = Integer.parseInt(address.substring(index + 1));
        }
        InetAddress addr = InetAddress.getByName(host);
        return new InetSocketAddress(addr, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionHelper nioConnect(String url, Properties props) throws IOException {
        this.url = url;
        this.props = props;
        InetSocketAddress addr = RPCConnection.getAddress(url, 11034);
        SocketChannel channel = SocketChannel.open(addr);
        NIOSocket sock = NIOConnection.createSocket(channel);
        boolean bOK = false;
        try {
            RPCConfig config = ServerManager.getConfig();
            this.setSocket(sock.socket(), config);
            this.connect(sock.getInputStream(), sock.getOutputStream(), url);
            if (currentSockTimeout != null) {
                Integer sto = (Integer)currentSockTimeout.get();
                if (sto != null) {
                    sock.socket().setSoTimeout(sto);
                }
            } else {
                sock.socket().setSoTimeout(config.tcpClientTimeout);
            }
            bOK = true;
        }
        finally {
            if (!bOK) {
                IOUtil.close(sock);
            }
        }
        NIOConnection cn = new NIOConnection(sock, url, props, true);
        cn.startService();
        return cn;
    }

    public static synchronized void initCurrentSockTimeout() {
        if (currentSockTimeout == null) {
            currentSockTimeout = new ThreadLocal();
        }
    }

    public static ThreadLocal getCurrentSockTimeout() {
        return currentSockTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect0(String url, Properties props) throws IOException {
        InetSocketAddress addr;
        String newurl;
        this.url = newurl = RPCConnection.parseQuery(url, props);
        this.props = props;
        RPCConfig config = ServerManager.getConfig();
        if (url.startsWith("tcps://")) {
            addr = RPCConnection.getAddress(newurl, 11033);
            this.sock = SSLTCPDriver.connect(addr);
        } else {
            addr = RPCConnection.getAddress(newurl, 11034);
            try {
                this.sock = new Socket();
                this.sock.connect(addr, config.socketConnectTimeout);
            }
            catch (IOException e) {
                logger.error((Object)("###connect to url error: " + url));
            }
        }
        boolean bOK = false;
        try {
            this.setSocket(this.sock, config);
            this.out = new BufferedOutputStream(this.sock.getOutputStream(), config.bufferedOutSize);
            this.in = new BufferedInputStream(this.sock.getInputStream());
            String lbUrl = this.connect(this.in, this.out, url);
            if (lbUrl != null && lbUrlTL.get() == null) {
                props.remove("engineId");
                props.remove(SERVER_NAME);
                lbUrlTL.set(lbUrl);
                bOK = false;
                return;
            }
            if (currentSockTimeout != null) {
                Integer sto = (Integer)currentSockTimeout.get();
                if (sto != null) {
                    this.sock.setSoTimeout(sto);
                }
            } else {
                this.sock.setSoTimeout(config.tcpClientTimeout);
            }
            bOK = true;
        }
        finally {
            if (!bOK) {
                IOUtil.close(this.sock);
            }
        }
    }

    public ConnectionHelper connect(String url, Properties props) throws IOException {
        this.connect0(url, props);
        StreamConnection cn = new StreamConnection(url, this.props, true, this.sock, this.in, this.out);
        cn.startServiceLoop();
        return cn;
    }

    public static String parseQuery(String strUrl, Properties props) {
        String resultString = strUrl;
        try {
            int i = strUrl.indexOf("://");
            if (i > 1) {
                String s = strUrl.substring(i);
                String protol = strUrl.substring(0, i);
                s = "http" + s;
                URL url = new URL(s);
                String queryString = url.getQuery();
                if (queryString != null && queryString.length() > 0) {
                    Hashtable querys = RPCConnection.parseQueryString(queryString);
                    props.putAll((Map<?, ?>)querys);
                }
                StringBuffer result = new StringBuffer(strUrl.length());
                result.append(url.getProtocol());
                result.append(":");
                if (url.getAuthority() != null && url.getAuthority().length() > 0) {
                    result.append("//");
                    result.append(url.getAuthority());
                }
                if ((i = (resultString = result.toString()).indexOf("://")) > 1) {
                    resultString = resultString.substring(i);
                    resultString = protol + resultString;
                }
            }
        }
        catch (MalformedURLException e) {
            logger.warn((Object)e, (Throwable)e);
        }
        return resultString;
    }

    private static Hashtable parseQueryString(String s) {
        int sep;
        Hashtable h = new Hashtable();
        int spos = 0;
        while ((sep = s.indexOf(61, spos)) != -1) {
            int send = s.indexOf(38, sep);
            if (send == -1) {
                send = s.length();
            }
            RPCConnection.add(h, s.substring(spos, sep), s.substring(sep + 1, send));
            spos = send + 1;
        }
        return h;
    }

    private static void add(Hashtable table, String key, String value) {
        key = RPCConnection.parse(key);
        value = RPCConnection.parse(value);
        table.put(key, value);
    }

    private static String parse(String str) {
        StringBuffer nstr = new StringBuffer();
        block7: for (int i = 0; i < str.length(); ++i) {
            char ch2 = str.charAt(i);
            switch (ch2) {
                case '%': {
                    try {
                        nstr.append((char)Integer.parseInt(str.substring(i + 1, i + 3), 16));
                    }
                    catch (NumberFormatException _) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException _) {
                        throw new IllegalArgumentException();
                    }
                    i += 2;
                    continue block7;
                }
                case '+': {
                    nstr.append(' ');
                    continue block7;
                }
                default: {
                    nstr.append(ch2);
                }
            }
        }
        return nstr.toString();
    }

    private String connect(InputStream in, OutputStream out, String originalUrl) throws IOException {
        boolean getClientIp;
        if (this.props == null) {
            this.props = new Properties();
        }
        if (getClientIp = ClientIpUtil.shouldGet()) {
            this.props.put("getClientIp", "true");
        }
        IOUtil.writeLine(out, "RPC_INVOKE " + this.url + " " + this.protocol);
        IOUtil.writeProperties(out, this.props);
        out.flush();
        String line = IOUtil.readLine(in);
        try {
            int code;
            int index = line.indexOf(32);
            int index1 = line.indexOf(32, index + 1);
            String ver = line.substring(0, index);
            if (!ver.equals(this.protocol)) {
                RPCConnection.notRPCServer(line);
            }
            if ((code = Integer.parseInt(line.substring(index + 1, index1).trim())) != 200) {
                if (code == 500) {
                    throw new RPCConnectException(code, line + "  url: " + originalUrl, 6001);
                }
                if (code == 1005) {
                    throw new RPCConnectException(code, line);
                }
                throw new RPCIOException(code, line);
            }
        }
        catch (Throwable e) {
            if (e instanceof RPCConnectException) {
                throw (RPCConnectException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            IOUtil.logIOError(logger, e);
            RPCConnection.notRPCServer(line);
        }
        IOUtil.readProperties(in, this.props);
        if (RPCService.inServiceInvoke.get() != null && RPCEngine.identity.equals(this.props.get("engineId")) && RPCService.inServiceInvoke.get().equals(this.props.get(SERVER_NAME))) {
            throw new RuntimeException("Not support remote call to self in remote proxy!");
        }
        String lbUrl = this.props.getProperty(LBURL);
        this.props.remove(LBURL);
        if (getClientIp) {
            this.props.remove("getClientIp");
            String clientInetAddress = this.props.getProperty("clientInetAddress");
            ClientIpUtil.setAddress(clientInetAddress);
        }
        return lbUrl;
    }

    public void setLbl(LoadBalanceLocalizer lbl) {
        this.lbl = lbl;
    }
}

