/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.driver;

import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.io.RPCIOException;
import com.kingdee.bos.rpc.io.driver.MultiChannelsConnection;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;
import org.apache.log4j.Logger;

public class StreamConnection
extends MultiChannelsConnection {
    protected final InputStream in;
    protected final OutputStream out;
    protected final Object owner;
    private static final Logger logger = Logger.getLogger(StreamConnection.class);
    private ServiceRunner serviceRunner = null;

    public StreamConnection(String url, Properties props, boolean isClient, Object owner, InputStream in, OutputStream out) {
        super(url, props, isClient);
        this.owner = owner;
        this.in = in;
        this.out = out;
        this.client = ((Socket)owner).toString();
    }

    public synchronized void startServiceLoop() {
        if (this.serviceRunner != null) {
            throw new Error("Service always started.");
        }
        this.serviceRunner = new ServiceRunner(this.in);
        RPCEngine.startThread(this.serviceRunner);
    }

    @Override
    protected synchronized void send(byte[] b, int off, int len) throws IOException {
        int l = IOUtil.intFromBytes(b, off + 4 & 0xFFFFFF) & 0x1FFFFFFF;
        if (l + 8 != len) {
            logger.error((Object)("send data error: l=" + l + " len=" + len), new Throwable());
        }
        try {
            this.out.write(b, off, len);
            this.out.flush();
        }
        catch (Throwable e) {
            this.close(e);
            throw RPCIOException.create(e);
        }
    }

    @Override
    protected void finalClose() throws Throwable {
        IOUtil.close(this.out);
        IOUtil.close(this.in);
        IOUtil.close(this.owner);
        super.finalClose();
    }

    private class ServiceRunner
    implements Runnable {
        final DataInputStream in;

        ServiceRunner(InputStream in) {
            this.in = new DataInputStream(in);
        }

        @Override
        public void run() {
            while (StreamConnection.this.serviceLoop(this.in)) {
            }
        }
    }
}

